/*
 * BtDrvD.c
 *
 *  Created on: 2014/02/17
 *      Author: seagbri
 */

#include "driverlib.h"
#include "SYS_msgID.h"
#include "FRM_sys.h"
#include "FRM_frm.h"
#include "BtDrvD.h"
#include "BtDrvD_RegAccess.h"

BTDRV_UARTCTRL g_taBTC_Mng;						/* UARTǗe[u */




/*
* *************************************************************************
* MODULE    :BtDrvD_initialize
* ABSTRACT  :ʐMhCo
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_initialize(void)
{
	/* RAM */
	BtDrvD_Com_initRam();

	/* ʐMhCoԂu~vɂ */
	g_taBTC_Mng.ucSts = BTDRV_COMMSTS_STOP;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_start
* ABSTRACT  :ʐMhCoN
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
int8_t BtDrvD_start(uint8_t baudrate)
{
	int8_t   ret = BTDRV_RET_OK;			/* ߂l */

		/* UARTJnݒ */
		BtDrvD_RegAccess_startUart(baudrate);

		/* RAM */
		BtDrvD_Com_initRam();

		/* ʐMhCoԂuAChv֑J */
		g_taBTC_Mng.ucSts = BTDRV_COMMSTS_IDLE;
	return ret;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_stop
* ABSTRACT  :ʐMhCo~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void BtDrvD_stop(void)
{
	/* UARTIݒ */
	BtDrvD_RegAccess_stopUart();

	/* ʐMhCoԂu~v֑J */
	g_taBTC_Mng.ucSts = BTDRV_COMMSTS_STOP;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_initRam
* ABSTRACT  :RAM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void BtDrvD_Com_initRam(void)
{
	/* UARTǗe[u */
	g_taBTC_Mng.ucSts = BTDRV_COMMSTS_STOP;
	g_taBTC_Mng.ucMode = BTDRV_MODE_SPP;
	g_taBTC_Mng.TryCnt = 0;

	g_taBTC_Mng.tCommSendInfo.ucDataCnt = 0;
	g_taBTC_Mng.tCommSendInfo.ucDataNum = 0;
	g_taBTC_Mng.tCommSendInfo.ucWriteIndex = 0;
	g_taBTC_Mng.tCommSendInfo.ucReadIndex = 0;

	g_taBTC_Mng.tSppSendInfo.ucDataCnt = 0;
	g_taBTC_Mng.tSppSendInfo.ucDataNum = 0;
	g_taBTC_Mng.tSppSendInfo.ucWriteIndex = 0;
	g_taBTC_Mng.tSppSendInfo.ucReadIndex = 0;

	g_taBTC_Mng.tRecvInfo.ucMode = BTDRV_RCVRES_FORMAT_UNKNOWN;
	g_taBTC_Mng.tRecvInfo.ucDataSize = 0;
	g_taBTC_Mng.tRecvInfo.ucEventFlg = BTDRV_FALSE;
	g_taBTC_Mng.tRecvInfo.ucEventSize = 0;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_Commsend
* ABSTRACT  :CommandM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_Commsend(uint8_t *pData, uint16_t size)
{
	uint16_t uc_DataNum;				/* Mް	*/
	uint8_t rts_signal;					/* RTSM	*/
	uint8_t uc_SendData;				/* Mް		*/
	uint8_t  ret_stock;					/* Mް~Ϗreturn	*/
	int8_t  ret = BTDRV_RET_OK;			/* ߂l */

														/* Ұ	*/
	if( (size == 0) || (size > BTDRV_SENDDATA_SIZE) )
	{													/* NG */
		ret = BTDRV_RET_PARAM_ERR;
	}													/* ײޏ	*/
	else if(g_taBTC_Mng.ucSts == BTDRV_COMMSTS_STOP)
	{													/* NG */
		ret = BTDRV_RET_NG;
	}
	else
	{														/* LOK							*/
		ret_stock = BtDrvD_Com_Commstock(pData, size);		/* Mް~					*/
		if(ret_stock == TRUE)
		{													/* ~ϐ					*/
		//	__DI();											/* ݋֎~		*/
			uc_DataNum = g_taBTC_Mng.tCommSendInfo.ucDataNum;	/* Mް擾	*/
		//	__EI();											/* ݋		*/

			/* MHi~ްP̏ꍇAMj	*/
			if(uc_DataNum == 1)
			{												/* M				*/
				/* BluetoothW[RTSMmF					*/
			 	rts_signal = GPIO_getInputPinValue(BTDRV_RTS_PORT,BTDRV_RTS_PIN);
				if(rts_signal == OFF)
				{												/* RTS LOW 				*/
					g_taBTC_Mng.ucSts = BTDRV_COMMSTS_SEND;		/* ײޏԑJ(M)	*/
					uc_SendData = BtDrvD_Com_getCOMMNextData();
					BtDrvD_RegAccess_send(uc_SendData);			/* ްM				*/

					/* gC񐔂 */
					g_taBTC_Mng.TryCnt = 0;
				}
				else
				{												/* RTS HIGH 				*/
					/* RTSĎgC */
					ret = BtDrvD_Com_retryRts();
					/* gCAEg */
					if(ret != BTDRV_RET_OK)
					{
						/* do nothing.. */
					}
				}
			}
		}
		else
		{														/* ~ώs					*/
			ret = BTDRV_RET_FULL;								/* Mޯ̧ް۰		*/
		}
	}

	return ret;		/*  */
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_Commstock
* ABSTRACT  :Mް~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_Commstock(uint8_t *pData, uint16_t size)
{
	uint8_t uc_DataNum;		/* Mް	*/
	uint8_t  ret;				/* return */

	ret = TRUE;

	//__DI();											/* ݋֎~		*/
	uc_DataNum = g_taBTC_Mng.tCommSendInfo.ucDataNum;	/* Mް擾	*/
	//__EI();											/* ݋		*/

													/* Mް~		*/
	if(uc_DataNum >= BTDRV_DATANUM)
	{												/* MްFULL			*/
		ret = FALSE;
	}
	else
	{												/* Mް~ω\		*/
													/* Mް~			*/
		g_taBTC_Mng.tCommSendInfo.ucDataSize[g_taBTC_Mng.tCommSendInfo.ucWriteIndex] = size;
		memcpy(g_taBTC_Mng.tCommSendInfo.ucData[g_taBTC_Mng.tCommSendInfo.ucWriteIndex],
				   pData,
				   size
				  );
		g_taBTC_Mng.tCommSendInfo.ucWriteIndex++;		/* IndexXV		*/
		if(g_taBTC_Mng.tCommSendInfo.ucWriteIndex >= BTDRV_DATANUM)
		{											/* MAX0ɂ(ݸ)	*/
			g_taBTC_Mng.tCommSendInfo.ucWriteIndex = 0;
		}

		//__DI();								/* ݋֎~		*/
		g_taBTC_Mng.tCommSendInfo.ucDataNum++;	/* MްXV	*/
		//__EI();								/* ݋		*/
	}

	return ret;		/*  */
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_Sppsend
* ABSTRACT  :SPPf[^M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_Sppsend(uint8_t *pData, uint16_t size)
{
	uint16_t uc_DataNum;				/* Mް	*/
	uint8_t rts_signal;					/* RTSM	*/
	uint8_t uc_SendData;				/* Mް		*/
	uint8_t  ret_stock;					/* Mް~Ϗreturn	*/
	int8_t  ret = BTDRV_RET_OK;			/* ߂l */

														/* Ұ	*/
	if( (size == 0) || (size > BTDRV_SSPSENDDATA_SIZE) )
	{													/* NG */
		ret = BTDRV_RET_PARAM_ERR;
	}													/* ײޏ	*/
	else if(g_taBTC_Mng.ucSts == BTDRV_COMMSTS_STOP)
	{													/* NG */
		ret = BTDRV_RET_NG;
	}
	else
	{														/* LOK							*/
		ret_stock = BtDrvD_Com_Sppstock(pData, size);		/* Mް~					*/
		if(ret_stock == TRUE)
		{													/* ~ϐ					*/
		//	__DI();											/* ݋֎~		*/
			uc_DataNum = g_taBTC_Mng.tSppSendInfo.ucDataNum;	/* Mް擾	*/
		//	__EI();											/* ݋		*/

			/* MHi~ްP̏ꍇAMj	*/
			if(uc_DataNum == 1)
			{												/* M				*/
				/* BluetoothW[RTSMmF					*/
			 	rts_signal = GPIO_getInputPinValue(BTDRV_RTS_PORT,BTDRV_RTS_PIN);
				if(rts_signal == OFF)
				{												/* RTS LOW 				*/
					g_taBTC_Mng.ucSts = BTDRV_COMMSTS_SEND;		/* ײޏԑJ(M)	*/
					uc_SendData = BtDrvD_Com_getSSPNextData();
					BtDrvD_RegAccess_send(uc_SendData);			/* ްM				*/

					/* gC񐔂 */
					g_taBTC_Mng.TryCnt = 0;
				}
				else
				{												/* RTS HIGH 				*/
					/* RTSĎgC */
					ret = BtDrvD_Com_retryRts();
					/* gCAEg */
					if(ret != BTDRV_RET_OK)
					{
						/* do nothing.. */
					}
				}
			}
		}
		else
		{														/* ~ώs					*/
			ret = BTDRV_RET_FULL;								/* Mޯ̧ް۰		*/
		}
	}

	return ret;		/*  */
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_Sppstock
* ABSTRACT  :Mް~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_Sppstock(uint8_t *pData, uint16_t size)
{
	uint8_t uc_DataNum;		/* Mް	*/
	uint8_t  ret;				/* return */

	ret = TRUE;

	//__DI();											/* ݋֎~		*/
	uc_DataNum = g_taBTC_Mng.tSppSendInfo.ucDataNum;	/* Mް擾	*/
	//__EI();											/* ݋		*/

													/* Mް~		*/
	if(uc_DataNum >= BTDRV_DATANUM)
	{												/* MްFULL			*/
		ret = FALSE;
	}
	else
	{												/* Mް~ω\		*/
													/* Mް~			*/
		g_taBTC_Mng.tSppSendInfo.ucDataSize[g_taBTC_Mng.tSppSendInfo.ucWriteIndex] = size;
		g_taBTC_Mng.tSppSendInfo.ucData[g_taBTC_Mng.tSppSendInfo.ucWriteIndex] = pData;
		g_taBTC_Mng.tSppSendInfo.ucWriteIndex++;		/* IndexXV		*/
		if(g_taBTC_Mng.tSppSendInfo.ucWriteIndex >= BTDRV_DATANUM)
		{											/* MAX0ɂ(ݸ)	*/
			g_taBTC_Mng.tSppSendInfo.ucWriteIndex = 0;
		}

		//__DI();								/* ݋֎~		*/
		g_taBTC_Mng.tSppSendInfo.ucDataNum++;	/* MްXV	*/
		//__EI();								/* ݋		*/
	}

	return ret;		/*  */
}


/*
* *************************************************************************
* MODULE    :BtDrvD_Com_getSSPNextData
* ABSTRACT  :ɑMSPPް擾
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_getSSPNextData(void)
{
	uint8_t	uc_SendData;	/* Mް		*/

	/* Mް擾	*/
	uc_SendData = *(g_taBTC_Mng.tSppSendInfo.ucData[g_taBTC_Mng.tSppSendInfo.ucReadIndex] + g_taBTC_Mng.tSppSendInfo.ucDataCnt);

	g_taBTC_Mng.tSppSendInfo.ucDataCnt++;

												/* MްŌォH	*/
	if(g_taBTC_Mng.tSppSendInfo.ucDataSize[g_taBTC_Mng.tSppSendInfo.ucReadIndex]
		<= g_taBTC_Mng.tCommSendInfo.ucDataCnt)
	{											/* MްŌ		*/
		g_taBTC_Mng.ucSts = BTDRV_COMMSTS_IDLE;	/* ײޏԑJ(ҋ@)		*/
	}
	return uc_SendData;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_getCOMMNextData
* ABSTRACT  :ɑMCommandް擾
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvD_Com_getCOMMNextData(void)
{
	uint8_t	uc_SendData;	/* Mް		*/

	/* Mް擾	*/
	uc_SendData =g_taBTC_Mng.tCommSendInfo.ucData[g_taBTC_Mng.tCommSendInfo.ucReadIndex][g_taBTC_Mng.tCommSendInfo.ucDataCnt];

	g_taBTC_Mng.tCommSendInfo.ucDataCnt++;

												/* MްŌォH	*/
	if(g_taBTC_Mng.tCommSendInfo.ucDataSize[g_taBTC_Mng.tCommSendInfo.ucReadIndex]
		<= g_taBTC_Mng.tCommSendInfo.ucDataCnt)
	{											/* MްŌ		*/
		g_taBTC_Mng.ucSts = BTDRV_COMMSTS_IDLE;	/* ײޏԑJ(ҋ@)		*/
	}
	return uc_SendData;
}
/*
* *************************************************************************
* MODULE    :BtDrvD_Com_retryRts
* ABSTRACT  :RTSĎgC
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/

int8_t BtDrvD_Com_retryRts(void)
{
	uint8_t rtsnum = 0;						/* RTSĎ */
	int8_t   ret = BTDRV_RET_OK;				/* ߂l */

	/* ʐMvgRRTSĎ񐔎擾 */
	rtsnum = BTDRV_RTS_NUM;

	/* gC񐔂RTSĎK񐔖 */
	if(g_taBTC_Mng.TryCnt < rtsnum)
	{
		/* RTSĎ^C}ݒ */
		/* 10ms^C}Zbg */
		SYS_SetTimer(TIMID_BLUETOOTH_RTS10MS,SYSAPI_TIMER_MIDACCURACY);

		/* gC񐔂CNg */
		g_taBTC_Mng.TryCnt++;
	}
	/* gC񐔂RTSĎK񐔈ȏ */
	else
	{
		/* Mʒʒm(RTSt[G[)bZ[WM */
		BtDrvD_Com_sendmessage(BLOCK_ID_BLUETOOTH,BLOCK_ID_BLUETOOTH,MSGID_BLUETOOTH_ERR_RTS);

		/* ~σf[^j */
		g_taBTC_Mng.ucSts = BTDRV_COMMSTS_IDLE;			/* ʐMhCoԂuҋ@v֑J */
		g_taBTC_Mng.TryCnt                 = 0;			/* gC */
		g_taBTC_Mng.tCommSendInfo.ucDataNum    = 0;		/* CommandMÃf[^ */
		g_taBTC_Mng.tCommSendInfo.ucDataCnt    = 0;		/* CommandMJE^ */
		g_taBTC_Mng.tCommSendInfo.ucReadIndex  = 0;		/* CommandǍIndex */
		g_taBTC_Mng.tCommSendInfo.ucWriteIndex = 0;		/* CommandIndex */
		g_taBTC_Mng.tSppSendInfo.ucDataNum    = 0;		/* SppMÃf[^ */
		g_taBTC_Mng.tSppSendInfo.ucDataCnt    = 0;		/* SppMJE^ */
		g_taBTC_Mng.tSppSendInfo.ucReadIndex  = 0;		/* SppǍIndex */
		g_taBTC_Mng.tSppSendInfo.ucWriteIndex = 0;		/* SppIndex */
		ret = BTDRV_RET_NG;
	}

	return ret;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_timeoutRts
* ABSTRACT  :RTSĎ^CAEg
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void BtDrvD_timeoutRts(void)
{
	uint8_t rtsst = OFF;						/* RTSM */
	uint8_t data = 0;							/* Mf[^ */
	int8_t  ret = BTDRV_RET_OK;					/* ߂l */

	/* RTSM擾 */
	rtsst = GPIO_getInputPinValue(BTDRV_RTS_PORT,BTDRV_RTS_PIN);

	/* RTSMLow */
	if(rtsst == OFF)
	{
		/* ʐMhCoԁuAChv */
		if(g_taBTC_Mng.ucSts == BTDRV_COMMSTS_IDLE)
		{
			/* ʐMhCoԂuMv֑J */
			g_taBTC_Mng.ucSts = BTDRV_COMMSTS_SEND;

			/* [hʂɑMf[^ݒ */
			if(g_taBTC_Mng.ucMode == BTDRV_MODE_SPP)
			{
				/* SPP  */
				data = BtDrvD_Com_getSSPNextData();;
			}
			else
			{
				/* Command  */
				data = BtDrvD_Com_getCOMMNextData();;
			}

			/* f[^M */
			BtDrvD_RegAccess_send(data);
		}
		/* ʐMhCoԁuMv */
		else if(g_taBTC_Mng.ucSts == BTDRV_COMMSTS_SEND)
		{
			/* [hʂɎMf[^擾  */
			if(g_taBTC_Mng.ucMode == BTDRV_MODE_SPP)
			{
				/* SPP  */
				data = BtDrvD_Com_getSSPNextData();;
			}
			else
			{
				/* Command  */
				data = BtDrvD_Com_getCOMMNextData();;
			}
			/* f[^M */
			BtDrvD_RegAccess_send(data);
		}
		/* ʐMhCoԁu~v */
		else
		{
			/* do nothing.. */
		}

		/* gC񐔂 */
		g_taBTC_Mng.TryCnt = 0;
	}
	/* RTSMHigh */
	else
	{
		/* RTSĎgC */
		ret = BtDrvD_Com_retryRts();
		/* gCAEg */
		if(ret != BTDRV_RET_OK)
		{
			/* do nothing.. */
		}
	}
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_Com_sendmessage(uint16_t bfrom,uint16_t bto, uint16_t mid)
{
	FRM_MSG msg = {0};

	msg.blk_from	= bfrom;
	msg.blk_to		= bto;
	msg.id			= mid;
	FRM_frm_sndmsg(msg);
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Com_getMng
* ABSTRACT  :UARTǗe[u擾
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
BTDRV_UARTCTRL* BtDrvD_Com_getMng(void)
{
	return (&g_taBTC_Mng);
}
