/*
 * BtDrvD_Int.c
 *
 *  Created on: 2014/02/21
 *      Author: seagbri
 */
#include "driverlib.h"
#include "SYS_msgID.h"
#include "BtDrvD_RegAccess.h"
#include "BtDrvD.h"
#include "FRM_frm.h"
#include "FRM_sys.h"

static void BtDrvD_Int_sendmessage(uint16_t mid, uint16_t size,uint8_t* data);
static int8_t BtDrvD_Int_createRcvData(uint8_t ucData);
static void BtDrvD_Int_recv(void);
static void BtDrvD_Int_send(void);

//******************************************************************************
//
//This is the USCI_A1 interrupt vector service routine.
//
//******************************************************************************
#pragma vector=USCI_A1_VECTOR
__interrupt void USCI_A1_ISR(void)
{
        switch (__even_in_range(UCA0IV, 4)) {
        //Vector 2 - RXIFG
        case 2:
        		BtDrvD_Int_recv();
                break;
        //Vector 4 - TXIFG
        case 4:
        		BtDrvD_Int_send();
        		break;
        default: break;
        }
}


/*
* *************************************************************************
* MODULE    :BtDrvD_Int_send
* ABSTRACT  :M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_Int_send(void)
{
	BTDRV_UARTCTRL*	Mng;					/* UARTǗe[u		*/
	uint8_t uc_SendData;					/* Mް		*/
	uint8_t rts_signal;						/* RTSM	*/
	int8_t  ret = BTDRV_RET_OK;				/* ߂l */

	Mng = BtDrvD_Com_getMng();
	/* ײޏԂmF	*/
	if(Mng->ucSts == BTDRV_COMMSTS_IDLE)
	{													/* ײޏԂҋ@			*/
		/* BTDrv֑Mʒʒm(M)bZ[WM */
	//	BtDrvD_Com_sendResultMsg(BTDRV_SNDRCVSTS_OK);

		if(Mng->ucMode == BTDRV_MODE_SPP)
		{
			/* UARTǗðٍXV */
			Mng->tSppSendInfo.ucDataCnt = 0;		/* M					*/
			Mng->tSppSendInfo.ucReadIndex++;		/* ǍIndex				*/
			if(Mng->tSppSendInfo.ucReadIndex >= BTDRV_DATANUM)
			{											/* MAX0ɂ(ݸ)	*/
				Mng->tSppSendInfo.ucReadIndex = 0;
			}
			Mng->tSppSendInfo.ucDataNum--;		/* Mް				*/
			if(Mng->tSppSendInfo.ucDataNum > 0)
			{											/* Mް				*/
				/* Mްݒ	*/
				uc_SendData = BtDrvD_Com_getSSPNextData();
			}
		}
		else
		{
			/* UARTǗðٍXV */
			Mng->tCommSendInfo.ucDataCnt = 0;		/* M					*/
			Mng->tCommSendInfo.ucReadIndex++;		/* ǍIndex				*/
			if(Mng->tCommSendInfo.ucReadIndex >= BTDRV_DATANUM)
			{												/* MAX0ɂ(ݸ)	*/
				Mng->tCommSendInfo.ucReadIndex = 0;
			}
			Mng->tCommSendInfo.ucDataNum--;			/* Mް				*/
			if(Mng->tCommSendInfo.ucDataNum > 0)
			{												/* Mް				*/
				/* Mްݒ	*/
				uc_SendData = BtDrvD_Com_getCOMMNextData();
			}
		}
		Mng->ucSts = BTDRV_COMMSTS_SEND;				/* ײޏԑJ(M)		*/
		BtDrvD_RegAccess_send(uc_SendData);					/* ްM					*/
		/* gC񐔂 */
		Mng->TryCnt = 0;

	}
	else if(Mng->ucSts == BTDRV_COMMSTS_SEND)
	{	/* ײޏԂM		*/
		/* RTSMmF				*/
	 	rts_signal = GPIO_getInputPinValue(BTDRV_RTS_PORT,BTDRV_RTS_PIN);
		if(rts_signal == ON)
		{												/* RTS HIGH 			*/
			/* RTSĎgC */
			ret = BtDrvD_Com_retryRts();
			/* gCAEg */
			if(ret != BTDRV_RET_OK)
			{
				/* do nothing.. */
			}
		}
		else
		{														/* RTS LOW				*/
			if(Mng->ucMode == BTDRV_MODE_SPP)
			{
				uc_SendData = BtDrvD_Com_getSSPNextData();		/* ɑMް擾	*/
			}
			else
			{
				uc_SendData = BtDrvD_Com_getCOMMNextData();		/* ɑMް擾	*/
			}
			if(Mng->ucSts != BTDRV_COMMSTS_IDLE)
			{
				BtDrvD_RegAccess_send(uc_SendData);					/* ްM					 	*/
			}
			/* gC񐔂 */
			Mng->TryCnt = 0;
		}
	}
	else
	{
	}
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Int_recv
* ABSTRACT  :M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_Int_recv(void)
{
	BTDRV_UARTCTRL*	Mng;

	int8_t  cre_data_ret;						/* ڰсA߹Đ */
	uint8_t uc_RecvData;						/* Mް */


	Mng	= BtDrvD_Com_getMng();
	/* ް */
	uc_RecvData	= BtDrvD_RegAccess_recv();
	cre_data_ret = BtDrvD_Int_createRcvData(uc_RecvData);

	/* ްʔ	*/
	if(cre_data_ret == BTDRV_RET_OK)
	{												/* ް			*/
		if(Mng->tRecvInfo.ucMode == BTDRV_RCVRES_FORMAT_COMM)
		{
			/* BtDrv֎MʒmbZ[WM */
			BtDrvD_Int_sendmessage(MSGID_BLUETOOTH_DRVRCV_COMM,Mng->tRecvInfo.ucDataSize,Mng->tRecvInfo.ucData);
		}
		else
		{
			/* BtDrv֎MʒmbZ[WM */
			BtDrvD_Int_sendmessage(MSGID_BLUETOOTH_DRVRCV_SPP,Mng->tRecvInfo.ucDataSize,Mng->tRecvInfo.ucData);
		}
		/* UARTǗðق̎Mر	*/
		Mng->tRecvInfo.ucDataSize = 0;				/* 	Mް		*/
		Mng->tRecvInfo.ucMode	= BTDRV_RCVRES_FORMAT_UNKNOWN;/* 	MtH[}bg	*/
	}
	else if(cre_data_ret == BTDRV_RET_WORK)
	{												/* ް			*/
													/* Ȃ		*/
	}
	else
	{
		/* do nothing.. */
	}

}
/*
* *************************************************************************
* MODULE    :BtDrvD_Int_createRcvSppData
* ABSTRACT  :Mް
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static int8_t BtDrvD_Int_createRcvData(uint8_t ucData)
{
	int8_t	ret;	/* return	*/
	BTDRV_UARTCTRL*	Mng;

	static const uint8_t BTDRV_INT_CHATTBL[2] =
		{
				"\r\n"

		};

	ret = BTDRV_RET_WORK;
	Mng	= BtDrvD_Com_getMng();

	/* Mްi[			*/
	Mng->tRecvInfo.ucData[Mng->tRecvInfo.ucDataSize] = ucData;
	Mng->tRecvInfo.ucDataSize++;
	/* MtH[}bg𔻒f			*/
	if(Mng->tRecvInfo.ucMode == BTDRV_RCVRES_FORMAT_UNKNOWN)
	{
		/* ŏ2Bytes𔻒f			*/
		if(Mng->tRecvInfo.ucDataSize >BTDRV_RCVRES_COMMFORMAT_NUM)
		{
			/* ŏ2Bytes"\r\n"𔻒f			*/
			if((Mng->tRecvInfo.ucData[0]==BTDRV_INT_CHATTBL[0])&&
				(Mng->tRecvInfo.ucData[1]==BTDRV_INT_CHATTBL[1]))
			{
				Mng->tRecvInfo.ucMode = BTDRV_RCVRES_FORMAT_COMM;
			}
			else
			{
				Mng->tRecvInfo.ucMode = BTDRV_RCVRES_FORMAT_SPP;
			}
		}
	}
	else
	{
		/* SPPMtH[}bg			*/
		if(Mng->tRecvInfo.ucMode == BTDRV_RCVRES_FORMAT_SPP)
		{
			if(Mng->tRecvInfo.ucDataSize>=BTDRV_RCVRES_SSPFORMAT_NUM)
			{
				ret = BTDRV_RET_OK;
			}

		}
		/* CommandMtH[}bg			*/
		else
		{
			/* Ō2Bytes𔻒f			*/
			if(Mng->tRecvInfo.ucDataSize >(BTDRV_RCVRES_COMMFORMAT_NUM+BTDRV_RCVRES_COMMFORMAT_NUM))
			{
				if((Mng->tRecvInfo.ucData[Mng->tRecvInfo.ucDataSize-2]==BTDRV_INT_CHATTBL[0])&&
					(Mng->tRecvInfo.ucData[Mng->tRecvInfo.ucDataSize-1]==BTDRV_INT_CHATTBL[1]))
				{
					ret = BTDRV_RET_OK;
				}
			}
		}
	}
	return ret;
}

/*
* *************************************************************************
* MODULE    :BtDrvD_Int_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_Int_sendmessage(uint16_t mid, uint16_t size,uint8_t* data)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_BLUETOOTH;
	msg.blk_to		= BLOCK_ID_BLUETOOTH;
	msg.id			= mid;
	msg.size		= size;
	msg.ptr			= (UINT16*)data;
	FRM_frm_sndmsg(msg);
}
