/*
 * BtDrvD_RegAccess.c
 *
 *  Created on: 2014/02/20
 *      Author: seagbri
 */
#include "driverlib.h"
#include "BtDrvD_RegAccess.h"
#include "BtDrvD.h"

/*
* *************************************************************************
* MODULE    :BtDrvD_RegAccess_startUart
* ABSTRACT  :UARTJnݒ
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void BtDrvD_RegAccess_startUart(uint8_t BaudRate)
{
static const BTDRV_REGACCESS_BAUDRATE BTDRV_12MHZTBL[BTDRV_BAUDRATE_NUM] =
	{
			/* 115200 */
			104,	1,	0,
			/* 230400 */
			52,		0,	0,
			/* 460800 */
			26,		0,	0
	};

	/* P8.2 Bluetooth UARTM */
	/* P8.3 Bluetooth UARTM */
    GPIO_setAsPeripheralModuleFunctionInputPin(
    		BTDRV_UART_PORT,
    		BTDRV_UART_SEND_PIN + BTDRV_UART_RECEIVE_PIN
            );
    /* Baudrate = (115.2kbps), clock freq = (12Mhz) */
    /* UCBRx = (104), UCBRFx = 0, UCBRSx = (1), UCOS16 = 0 */
    if ( STATUS_FAIL == USCI_A_UART_initAdvance(USCI_A1_BASE,
    											USCI_A_UART_CLOCKSOURCE_SMCLK,
    											BTDRV_12MHZTBL[BaudRate].UCBRx,
    											BTDRV_12MHZTBL[BaudRate].UCBRFx,
    											BTDRV_12MHZTBL[BaudRate].UCBRSx,
                                                USCI_A_UART_NO_PARITY,
                                                USCI_A_UART_MSB_FIRST,
                                                USCI_A_UART_ONE_STOP_BIT,
                                                USCI_A_UART_MODE,
                                                USCI_A_UART_LOW_FREQUENCY_BAUDRATE_GENERATION ))
            return;
    /* Enable UART module for operation */
    USCI_A_UART_enable(USCI_A1_BASE);

    /* Enable Transmit and Receive Interrupt */
    USCI_A_UART_clearInterruptFlag(USCI_A1_BASE,
                                   USCI_A_UART_RECEIVE_INTERRUPT|USCI_A_UART_TRANSMIT_INTERRUPT
                                   );
    USCI_A_UART_enableInterrupt(USCI_A1_BASE,
                                USCI_A_UART_RECEIVE_INTERRUPT|USCI_A_UART_TRANSMIT_INTERRUPT
                                );
    /* CTSLowɂ */
	GPIO_setOutputLowOnPin(BTDRV_CTS_PORT,BTDRV_CTS_PIN);

}

/*
* *************************************************************************
* MODULE    :BtDrvD_RegAccess_startUart
* ABSTRACT  :UARTIݒ
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvD_RegAccess_stopUart(void)
{
    /* CTSHighɂ */
	GPIO_setOutputHighOnPin(BTDRV_CTS_PORT,BTDRV_CTS_PIN);
	/* Disable UART module for operation */
	USCI_A_UART_disable(USCI_A1_BASE);
}

/*
* *************************************************************************
* MODULE    :BtDrvD_RegAccess_send
* ABSTRACT  :UARTM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void BtDrvD_RegAccess_send(uint8_t data)
{
	/* Send data */
    USCI_A_UART_transmitData(USCI_A1_BASE,data);
}

/*
* *************************************************************************
* MODULE    :BtDrvD_RegAccess_recv
* ABSTRACT  :UARTM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

uint8_t BtDrvD_RegAccess_recv(void)
{
	uint8_t receivedData;
	/* Receive the data */
	receivedData =USCI_A_UART_receiveData(USCI_A1_BASE);
	return receivedData;
}
