/*
 * BtDrvM_Power.c
 *
 *  Created on: 2014/02/18
 *      Author: seagbri
 */
#include "driverlib.h"
#include "SYS_msgID.h"
#include "FRM_frm.h"
#include "BtDrvM.h"
#include "BtDrvD.h"

static T_DBTC_POW_MNGTBL g_taBTC_Pow_Mng;						/* Power Ǘe[u */

/*
* *************************************************************************
* MODULE    :BtDrvM_Power_initialize
* ABSTRACT  :ʐMhCod
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvM_Power_initialize(void)
{
	/* RAM */
	g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_POWEROFF;
}

/*
* *************************************************************************
* MODULE    :BtDrvM_Power_Start
* ABSTRACT  :ʐMhCodJn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvM_Power_Start(void)
{
	/* BluetoothW[BT_MODE(High:Automatic Mode) */
	GPIO_setOutputHighOnPin(GPIO_PORT_P4,GPIO_PIN6);
	/* BluetoothW[BT_ROLE(Low:Slave) */
	GPIO_setOutputLowOnPin(GPIO_PORT_P4,GPIO_PIN5);
	/* BluetoothW[ZbgFLow */
	GPIO_setOutputLowOnPin(GPIO_PORT_P8,GPIO_PIN0);
	/* BluetoothW[dI */
	GPIO_setOutputHighOnPin(GPIO_PORT_P8,GPIO_PIN7);
	/* 50ms^C}Zbg */
	SYS_SetTimer(TIMID_BLUETOOTH_50MS,SYSAPI_TIMER_MIDACCURACY);
	/* ԂXV */
	g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_WAITPOWERON;
}

/*
* *************************************************************************
* MODULE    :BtDrvM_Power_Start
* ABSTRACT  :ʐMhCodJn(Command mode)
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvM_Power_ConfigStart(void)
{
	/* BluetoothW[BT_MODE(High:Command mode) */
	GPIO_setOutputLowOnPin(GPIO_PORT_P4,GPIO_PIN6);
	/* BluetoothW[BT_ROLE(Low:Slave) */
	GPIO_setOutputLowOnPin(GPIO_PORT_P4,GPIO_PIN5);
	/* BluetoothW[ZbgFLow */
	GPIO_setOutputLowOnPin(GPIO_PORT_P8,GPIO_PIN0);
	/* BluetoothW[dI */
	GPIO_setOutputHighOnPin(GPIO_PORT_P8,GPIO_PIN7);
	/* 50ms^C}Zbg */
	SYS_SetTimer(TIMID_BLUETOOTH_50MS,SYSAPI_TIMER_MIDACCURACY);
	/* ԂXV */
	g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_WAITCONFIG;
}

/*
* *************************************************************************
* MODULE    :BtDrvM_Power_Timeout
* ABSTRACT  :dJn(Time out)
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvM_Power_Timeout(void)
{
	/* BluetoothW[ZbgFHigh*/
	GPIO_setOutputHighOnPin(GPIO_PORT_P8,GPIO_PIN0);
	if(g_taBTC_Pow_Mng.ucSts == DBTC_POWSTS_WAITPOWERON)
	{
		/* ԂXV*/
		g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_POWERON;
		/* ʐMN*/
		BtDrvD_start(DBTC_BTD_BAUD1152);
		/* LED_*/
	}
	else
	{
		/* ԂXV*/
		g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_POWERONCOMMAND;
		/* ʐMN*/
		BtDrvD_start(DBTC_BTD_BAUD1152);
		/* Host͕ԐM*/
	}

}

/*
* *************************************************************************
* MODULE    :BtDrvM_Power_Start
* ABSTRACT  :d~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BtDrvM_Power_Stop(void)
{
	/* BluetoothW[BT_MODE(High:Automatic Mode)*/
	GPIO_setOutputHighOnPin(GPIO_PORT_P4,GPIO_PIN6);
	/* BluetoothW[BT_ROLE(Low:Slave)*/
	GPIO_setOutputLowOnPin(GPIO_PORT_P4,GPIO_PIN5);
	/* BluetoothW[ZbgFLow*/
	GPIO_setOutputLowOnPin(GPIO_PORT_P8,GPIO_PIN0);
	/* BluetoothW[dIt*/
	GPIO_setOutputLowOnPin(GPIO_PORT_P8,GPIO_PIN7);
	/* 50ms^C}NA */
	SYS_ClearTimer(TIMID_BLUETOOTH_50MS,SYSAPI_TIMER_MIDACCURACY);
	/* LED*/

	/* ԂXV*/
	g_taBTC_Pow_Mng.ucSts = DBTC_POWSTS_POWEROFF;
}
/*
* *************************************************************************
* MODULE    :BtDrvM_get_PowerSts
* ABSTRACT  :d~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t BtDrvM_get_PowerSts(void)
{
	return(g_taBTC_Pow_Mng.ucSts);
}
