/*
 * EcgM.c
 *
 *  Created on: 2013/12/23
 *      Author: seagbri
 */
#include "driverlib.h"
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <EcgM.h>

UINT16 ECGM_STS;				//動作中状態Recode/Вluetooth
ECGM_ADDATA DMA_DST[2];		//ADC conversion result is stored in this variable
UINT8 ECGM_DST_POINT;		//保存ポイント
UINT8 ECGM_ALARMON;			//アラム用フラグ

static void ECGM_OnReq(UINT16 cmd);
static void ECGM_OffReq(UINT16 cmd);
static void ECGM_sendmessage(UINT16 bto, UINT16 mid, UINT16* ptr);
static void ECGM_ADconvertStart(void);
static void ECGM_DataGetComplete(UINT16* ptr);
static void ECGM_DmaDataComplete(void);
static void ECGM_DmaInitial(void);
static void ECGM_ADInitial(void);
static void ECGM_AlarmNotify(void);
/*
* *************************************************************************
* MODULE    :ECGM_root
* ABSTRACT  :root処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
void ECGM_root(FRM_MSG *msg)
{
	switch(msg->id){
				//ECG ON要求処理
		case	MSGID_ECGM_ON:
				ECGM_OnReq(msg->cmd);
				break;
				//ECG OFF要求処理
		case	MSGID_ECGM_OFF:
				ECGM_OffReq(msg->cmd);
				break;
				//ECG データ取得完了処理
		case	MSGID_ECGM_DATAGETCOMPLETE:
				ECGM_DataGetComplete(msg->ptr);
				break;
				//Alarm通知処理
		case	MSGID_ECGM_ALARMNOTIFY:
				ECGM_AlarmNotify();
				break;
		default:
			break;
	}
}

/*
* *************************************************************************
* MODULE    :ECGM_Initial
* ABSTRACT  :初期化処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
void ECGM_Initial(void)
{
	ECGM_STS = ECGM_REQ_NON;
	ECGM_DST_POINT = ECGM_POINT_0;
	ECGM_ALARMON = OFF;
}

/*
* *************************************************************************
* MODULE    :ECGM_AlarmNotify
* ABSTRACT  :Alarm通知処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/12 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_AlarmNotify(void)
{
	ECGM_ALARMON = ON;
}
/*
* *************************************************************************
* MODULE    :ECGM_OnReq
* ABSTRACT  :ON要求処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_OnReq(UINT16 cmd)
{
	UINT16 sbak;

	sbak = ECGM_STS;
	//ラストを保存
	ECGM_STS |= cmd;
	//要求を確認
	if((sbak == ECGM_REQ_NON)&&
	   (ECGM_STS != ECGM_REQ_NON ))
	{
		//データ取得を開始
		ECGM_ADconvertStart();
	}
}
/*
* *************************************************************************
* MODULE    :ECGM_OffReq
* ABSTRACT  :OFF要求
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_OffReq(UINT16 cmd)
{
	ECGM_STS &= (!cmd);

}
/*
* *************************************************************************
* MODULE    :ECGM_DataGetComplete
* ABSTRACT  :データ取得済み処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_DataGetComplete(UINT16* ptr)
{
	if(ECGM_ALARMON == ON)
	{
		ECGM_ALARMON = OFF;
		//Recode処理
		if((ECGM_STS & ECGM_REQ_RECODE) == ECGM_REQ_RECODE)
		{
			//送信
			ECGM_sendmessage(BLOCK_ID_RECODE,MSGID_RECODE_ALARMDATAGETCOMPLETE,ptr);
		}
		//Bluetooth処理
		if((ECGM_STS & ECGM_REQ_BLUETOOTH) == ECGM_REQ_BLUETOOTH)
		{
			//送信
			ECGM_sendmessage(BLOCK_ID_BLUETOOTH,MSGID_BLUETOOTH_ALARMDATAGETCOMPLETE,ptr);
		}
	}
	else
	{
		//Recode処理
		if((ECGM_STS & ECGM_REQ_RECODE) == ECGM_REQ_RECODE)
		{
			//送信
			ECGM_sendmessage(BLOCK_ID_RECODE,MSGID_RECODE_DATAGETCOMPLETE,ptr);
		}
		//Bluetooth処理
		if((ECGM_STS & ECGM_REQ_BLUETOOTH) == ECGM_REQ_BLUETOOTH)
		{
			//送信
			ECGM_sendmessage(BLOCK_ID_BLUETOOTH,MSGID_BLUETOOTH_DATAGETCOMPLETE,ptr);
		}
	}
}

/*
* *************************************************************************
* MODULE    :ECGM_sendmessage
* ABSTRACT  :Message送信処理
* FUNCTION  :
* ARGUMENT  :bfrom 元　bto 先　mid　メッセージID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_sendmessage(UINT16 bto, UINT16 mid, UINT16* ptr)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_ECGM;
	msg.blk_to		= bto;
	msg.id			= mid;
	msg.cmd			= 0x00;
	msg.size		= ECGM_DATA_SIZE;
	msg.ptr			= ptr;
	FRM_frm_sndmsg(msg);
}
/*
* *************************************************************************
* MODULE    :RECODE_Getsts
* ABSTRACT  :ECGMの現状態を取得
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :状態
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
UINT16 RECODE_Getsts(void)
{
	return ECGM_STS;
}

/*
* *************************************************************************
* MODULE    :ECGM_ADconvertStart
* ABSTRACT  :A/D変換を開始
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_ADconvertStart(void)
{
	//A/D変換初期化
	ECGM_ADInitial();
    //DMA初期化
    ECGM_DmaInitial();
    //LPM3 w/ interrupts
  //  __bis_SR_register(LPM3_bits + GIE);
    //For Debugger
    __no_operation();
}

#if 1
//------------------------------------------------------------------------------
//DMA Interrupt Service Routine
//------------------------------------------------------------------------------
#pragma vector=DMA_VECTOR
__interrupt void DMA_ISR(void)
{
        switch (__even_in_range(DMAIV, 16)) {
        case 0: break;
        case 2:         //DMA0IFG = DMA Channel 0
        		ECGM_DmaDataComplete();
                break;
        case 4: break;  //DMA1IFG = DMA Channel 1
        case 6: break;  //DMA2IFG = DMA Channel 2
        case 8: break;  //DMA3IFG = DMA Channel 3
        case 10: break; //DMA4IFG = DMA Channel 4
        case 12: break; //DMA5IFG = DMA Channel 5
        case 14: break; //DMA6IFG = DMA Channel 6
        case 16: break; //DMA7IFG = DMA Channel 7
        default: break;
        }
}
#endif
/*
* *************************************************************************
* MODULE    :ECGM_DmaDataComplete
* ABSTRACT  :DMA完了処理
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_DmaDataComplete(void)
{
	//ECGM送信
	ECGM_sendmessage(BLOCK_ID_ECGM,MSGID_ECGM_DATAGETCOMPLETE,DMA_DST[ECGM_DST_POINT].buf);
	//現状態を確認
	if(ECGM_STS == ECGM_REQ_NON)
	{
		//A/D変換停止
		TIMER_A_stop(TIMER_B0_BASE);
	}
	else
	{
		//A/D変換開始
		ECGM_DmaInitial();
	}
}

/*
* *************************************************************************
* MODULE    :ECGM_ADInitial
* ABSTRACT  :A/D変換初期化
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_ADInitial(void)
{
    //Set up Timer B0
    TIMER_A_initCompare(TIMER_B0_BASE,
                        TIMER_A_CAPTURECOMPARE_REGISTER_0,
                        TIMER_A_CAPTURECOMPARE_INTERRUPT_DISABLE,
                        TIMER_A_OUTPUTMODE_RESET_SET,
                        0);

    //Start timer B0
    TIMER_A_startUpMode(TIMER_B0_BASE,
                        TIMER_A_CLOCKSOURCE_SMCLK,
                        TIMER_A_CLOCKSOURCE_DIVIDER_12,
                        0x07D0,
                        TIMER_A_TAIE_INTERRUPT_DISABLE,
                        TIMER_A_CCIE_CCR0_INTERRUPT_DISABLE,
                        TIMER_A_DO_CLEAR);

    //Initialize and setup the ADC12 Module
    /*
     * Base Address of the ADC12 Module
     * Use internal ADC12 bit as sample/hold signal to start conversion
     * USE MODOSC 5MHZ Digital Oscillator as clock source
     * Use default clock divider of 1
     */
    ADC12_A_init(ADC12_A_BASE,
                 ADC12_A_SAMPLEHOLDSOURCE_3,
                 ADC12_A_CLOCKSOURCE_ADC12OSC,
                 ADC12_A_CLOCKDIVIDER_1);

    ADC12_A_enable(ADC12_A_BASE);
    /*
     * Base Address of the ADC12 Module
     * For memory buffers 0-7 sample/hold for 256 clock cycles
     * For memory buffers 8-15 sample/hold for 4 clock cycles (default)
     * Enable Multiple Sampling
     */
    ADC12_A_setupSamplingTimer(ADC12_A_BASE,
                               ADC12_A_CYCLEHOLD_128_CYCLES,
                               ADC12_A_CYCLEHOLD_4_CYCLES,
                               ADC12_A_MULTIPLESAMPLESENABLE);

#ifdef ECGM_ECGBAT_SQUENCE
    //Configure Memory Buffer(A/D(VBATA1))
    /*
     * Base Address of the ADC12 Module
     * Configure memory buffer 5
     * Map input A5 to memory buffer 5
     * Vref+ = AVcc
     * Vref- = AVss
     * Memory buffer 5 is not the end of a sequence
     */
    ADC12_A_memoryConfigure(ADC12_A_BASE,
                            ADC12_A_MEMORY_5,
                            ADC12_A_INPUT_A5,
                            ADC12_A_VREFPOS_AVCC,
                            ADC12_A_VREFNEG_AVSS,
                            ADC12_A_NOTENDOFSEQUENCE);
    //Configure Memory Buffer(A/D(ECG Data))
    /*
     * Base Address of the ADC12 Module
     * Configure memory buffer 14
     * Map input A14 to memory buffer 14
     * Vref+ = AVcc
     * Vref- = AVss
     * Memory buffer 14 is the end of a sequence
     */
    ADC12_A_memoryConfigure(ADC12_A_BASE,
                            ADC12_A_MEMORY_14,
                            ADC12_A_INPUT_A14,
                            ADC12_A_VREFPOS_AVCC,
                            ADC12_A_VREFNEG_AVSS,
                            ADC12_A_ENDOFSEQUENCE);

    //Enable/Start sampling and conversion
    /*
     * Base Address of the ADC12 Module
     * Start the conversion into memory buffer 5
     * Use the repeated sequence of channels
     */
    ADC12_A_startConversion(ADC12_A_BASE,
                            ADC12_A_MEMORY_5,
                            ADC12_A_REPEATED_SEQOFCHANNELS);
#else
    //Configure Memory Buffer
    /*
     * Base Address of the ADC12 Module
     * Configure memory buffer 0
     * Map input A0 to memory buffer 0
     * Vref+ = AVcc
     * Vref- = AVss
     * Memory buffer 0 is not the end of a sequence
     */
    ADC12_A_memoryConfigure(ADC12_A_BASE,
                            ADC12_A_MEMORY_14,
                            ADC12_A_INPUT_A14,
                            ADC12_A_VREFPOS_AVCC,
                            ADC12_A_VREFNEG_AVSS,
                            ADC12_A_NOTENDOFSEQUENCE);
    //Enable/Start sampling and conversion
    /*
     * Base Address of the ADC12 Module
     * Start the conversion into memory buffer 14
     * Use the single-channel, single-conversion mode
     */
    ADC12_A_startConversion(ADC12_A_BASE,
    						ADC12_A_MEMORY_14,
                            ADC12_A_REPEATED_SINGLECHANNEL);
#endif
}
/*
* *************************************************************************
* MODULE    :ECGM_DmaInitial
* ABSTRACT  :DMA初期化
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/徐征
* UPDATE    :
* **************************************************************************
*/
static void ECGM_DmaInitial(void)
{
    //Disable the DMA from preempting a Read-Modify-Write Operation in the CPU
    DMA_disableTransferDuringReadModifyWrite(DMA_BASE);

    //Initialize and Setup DMA Channel 0
    /*
     * Base Address of the DMA Module
     * Configure DMA channel 0
     * Configure channel for repeated single transfers
     * DMA interrupt flag will be set after every 1 transfer
     * Use DMA Trigger Source 24 (ADC12xIFG)
     * Transfer Word-to-Word
     * Trigger upon Rising Edge of Trigger Source Signal
     */
    DMA_init(DMA_BASE,
             DMA_CHANNEL_0,
             DMA_TRANSFER_REPEATED_SINGLE,
             ECGM_DATA_RATE,
             DMA_TRIGGERSOURCE_24,
             DMA_SIZE_SRCWORD_DSTWORD,
             DMA_TRIGGER_RISINGEDGE);
    /*
     * Base Address of the DMA Module
     * Configure DMA channel 0
     * Use ADC12 Memory Buffer 14 as source
     * Don't move the source address after every transfer
     */
    DMA_setSrcAddress(DMA_BASE,
                      DMA_CHANNEL_0,
                      ADC12_A_getMemoryAddressForDMA(ADC12_A_BASE,
                                                     ADC12_A_MEMORY_14),
                      DMA_DIRECTION_UNCHANGED);
    /*
     * Base Address of the DMA Module
     * Configure DMA channel 0
     * Use DMA_DST as destination
     * Increment destination address after every transfer
     */
    ECGM_DST_POINT ++;
    if(ECGM_DST_POINT > ECGM_POINT_MAX)
    {
    	ECGM_DST_POINT = ECGM_POINT_0;
    }

    DMA_setDstAddress(DMA_BASE,
                      DMA_CHANNEL_0,
                      (uint32_t)DMA_DST[ECGM_DST_POINT].buf,
                      DMA_DIRECTION_INCREMENT);

    //Enable DMA channel 0 interrupt
    DMA_clearInterrupt(DMA_BASE,
                       DMA_CHANNEL_0);
    DMA_enableInterrupt(DMA_BASE,
                        DMA_CHANNEL_0);

    //Enable transfers on DMA channel 0
    DMA_enableTransfers(DMA_BASE,
                        DMA_CHANNEL_0);

}
