/*
 * FRM_sys.c
 *
 *  Created on: 2014-1-16
 *      Author: john
 */

#include <FRM_sys.h>
#include <FRM_frm.h>

FRM_MAIN_APP theApp = {0};

/*
* *************************************************************************
* MODULE    :FRM_sys_queue_init
* ABSTRACT  :bZ[WL[B
* FUNCTION  :obt@[NAAL[TOP/ENDL[obt@Y̒ԂƂB
* 				END = TOP - 1 ƂA\B
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void FRM_sys_queue_init(FRM_SYS_QUEUE *queue)
{
	//L[TOP/ENDL[obt@Y̒ԂƂ
	queue->dq_top = (FRM_SYS_QUEUE_MAX / 2);
	queue->dq_end = (FRM_SYS_QUEUE_MAX / 2) - 1;
}

/*
* *************************************************************************
* MODULE    :FRM_sys_queue_isFull
* ABSTRACT  :L[^ǂ𒲂ׂ
* FUNCTION  :L[^ǂ𒲂ׂ
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :^ȂTRUE
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 FRM_sys_queue_isFull(const FRM_SYS_QUEUE *queue)
{
	UINT8 ret = FALSE;
	//Oobt@̂
	if ( ((queue->dq_top - queue->dq_end) == 2) || ((queue->dq_end - queue->dq_top) == (FRM_SYS_QUEUE_MAX - 2)) )
	{
		ret = TRUE;
	}
	return ret;
}
/*
* *************************************************************************
* MODULE    :FRM_sys_queue_isEmpty
* ABSTRACT  :L[󂩂ǂ𒲂ׂ
* FUNCTION  :L[󂩂ǂ𒲂ׂ
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :ȂTRUE
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 FRM_sys_queue_isEmpty(const FRM_SYS_QUEUE *queue)
{
	UINT8 ret = FALSE;
	//Oobt@̂
	if ( ((queue->dq_top - queue->dq_end) == 1) || ((queue->dq_end - queue->dq_top) == (FRM_SYS_QUEUE_MAX - 1)) )
	{
		ret = TRUE;
	}
	return ret;
}
/*
* *************************************************************************
* MODULE    :FRM_sys_queue_push
* ABSTRACT  :bZ[WL[֒lPUSHiX^bNjB
* FUNCTION  :bZ[WL[֒lPUSHiX^bNjB
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void FRM_sys_queue_push(FRM_SYS_QUEUE *queue, FRM_MSG msg)
{
	UINT8 bIsFull;

	//L[^ǂ𒲂ׂ
	bIsFull = FRM_sys_queue_isFull(queue);
	if (bIsFull == FALSE)
	{
		//bZ[WL[֒lPUSH
		queue->dq_top--;
		if (queue->dq_top < 0)
		{
			queue->dq_top = FRM_SYS_QUEUE_MAX - 1;
		}
		memcpy(&queue->queue_buffer[queue->dq_top],&msg,sizeof(FRM_MSG));
	}
	else
	{
		//L[t̓Zbg
		//reset
	}
}
/*
* *************************************************************************
* MODULE    :FRM_sys_queue_put
* ABSTRACT  :bZ[WL[֒lPUTiǉjB
* FUNCTION  :bZ[WL[֒lPUTiǉjB
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void FRM_sys_queue_put(FRM_SYS_QUEUE *queue, FRM_MSG msg)
{
	UINT8 bIsFull;

	//L[^ǂ𒲂ׂ
	bIsFull = FRM_sys_queue_isFull(queue);
	if (bIsFull == FALSE)
	{
		//bZ[WL[֒lPUT
		queue->dq_end++;
		if (queue->dq_end >= FRM_SYS_QUEUE_MAX)
		{
			queue->dq_end = 0;
		}
		memcpy(&queue->queue_buffer[queue->dq_end] ,&msg,sizeof(FRM_MSG));
	}
	else
	{
		//L[t̓Zbg
		//reset
	}
}
/*
* *************************************************************************
* MODULE    :FRM_sys_queue_pop
* ABSTRACT  :bZ[WL[̍ŏʂloB
* FUNCTION  :bZ[WL[̍ŏʂloB
* ARGUMENT  :Ώۂ̃L[
* NOTE      :
* RETURN    :L[TOP̓eB
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
FRM_MSG FRM_sys_queue_pop(FRM_SYS_QUEUE *queue)
{
	FRM_MSG ret;
	UINT8 bIsEmpty;

	//L[󂩂ǂ𒲂ׂ
	bIsEmpty = FRM_sys_queue_isEmpty(queue);
	if (bIsEmpty == TRUE)
	{
		ret.blk_to = BLOCK_NON;
	}
	else
	{
		//bZ[WL[̍ŏʂlo
		memcpy(&ret,&queue->queue_buffer[queue->dq_top],sizeof(FRM_MSG));
	//	queue->queue_buffer[queue->dq_top] = NULL;
		queue->dq_top++;
		if (queue->dq_top >= FRM_SYS_QUEUE_MAX)
		{
			queue->dq_top = 0;
		}
	}
	return ret;
}

/*
* *************************************************************************
* MODULE    :FRM_frm_rcvmsg
* ABSTRACT  :t[[NbZ[WM֐B
* FUNCTION  :t[[NbZ[WM֐B
* ARGUMENT  :
* NOTE      :
* RETURN    :msg̓e
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
FRM_MSG FRM_frm_rcvmsg(void)
{
	FRM_MSG			msg;
	FRM_MAIN_APP 	*app;

	//ݓ삵ĂAvP[Vt[[Nւ̃AhX
	app = FRM_frm_getapp();
	//bZ[WL[̍ŏʂlo
	msg = FRM_sys_queue_pop(&app->queue);

	return msg;
}
/*
* *************************************************************************
* MODULE    :FRM_frm_sndmsg
* ABSTRACT  :t[[NpbZ[WSEND֐B
* FUNCTION  :t[[NpbZ[WSEND֐B
* ARGUMENT  :MiL[֊i[j郁bZ[W\̂ւ̃AhX
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void FRM_frm_sndmsg(FRM_MSG msg)
{
	FRM_MAIN_APP *app;

	//ݓ삵ĂAvP[Vt[[Nւ̃AhX
	app = FRM_frm_getapp();

	//bZ[WL[֒lPUT
	FRM_sys_queue_put(&app->queue, msg);

}
/*
* *************************************************************************
* MODULE    :FRM_frm_getapp
* ABSTRACT  :ݓ삵ĂAvP[Vt[[Nւ̃AhXԂB
* FUNCTION  :ݓ삵ĂAvP[Vt[[Nւ̃AhXԂB
* ARGUMENT  :
* NOTE      :
* RETURN    :ݓ삵ĂAvP[Vt[[Nւ̃AhX
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
FRM_MAIN_APP* FRM_frm_getapp(void)
{
	FRM_MAIN_APP *ret;

	ret	= &theApp;

	return ret;
}


