/*
 * SYS_TimerHdr.c
 *
 *  Created on: 2013/08/12
 *      Author: seagbri
 */
#include "driverlib.h"
#include <SYS_msgID.h>
#include <Power.h>
#include <FRM_sys.h>
#include <FRM_frm.h>



void Timer_Dummy_Handler( void );

/**
 * ^C}`(2ms)
 */
UINT8	SysTimer10msCnt;	//xp10msJEg
SYSAPI_TIMER_STATUS SysApiTimerStsHi [SYSAPI_TIMER_HI_MAX] = {0};//xp^C}
SYSAPI_TIMER_STATUS SysApiTimerStsMid [SYSAPI_TIMER_HI_MAX] = {0};//xpRAM^C}
/*** High accuracy table***/
const SYSAPI_TIMER_HI_REG SysApiHiRegTbl [SYSAPI_TIMER_HI_MAX] =
{
	{ TIMID_DUMMY,  5,        Timer_Dummy_Handler },    // High accuracy DUMMY handler (10ms)
};
/*** Middle accuracy table***/
const SYSAPI_TIMER_ML_REG SysApiMidRegTbl [SYSAPI_TIMER_MID_MAX] =
{
	{ TIMID_LED_500MS,  50,			BLOCK_ID_LED, MSGID_LED_TIMEOUT},    // (500ms)
	{ TIMID_RECODE_500MS,  50,		BLOCK_ID_RECODE, MSGID_RECODE_TIMEOUT},    // (500ms)
	{ TIMID_BLUETOOTH_50MS,  5,	BLOCK_ID_BLUETOOTH, MSGID_BLUETOOTH_POWERTIMEOUT},    // (50ms)
	{ TIMID_BLUETOOTH_RTS10MS,  1,	BLOCK_ID_BLUETOOTH, MSGID_BLUETOOTH_RTSTIMEOUT},    // (10ms)
	{ TIMID_INTEG_WATISLEEP,  100,	BLOCK_ID_INTEG, MSGID_INTEG_WAITSLEEPTIMEOUT},    // (100ms)
};
/**
 * ^C}`(10ms)
 */
UINT8	SysTimer100msCnt;	//xp10msJEg
SYSAPI_TIMER_STATUS SysApiTimer10msStsHi [SYSAPI_TIMER_HI10MS_MAX] = {0};//xp^C}
SYSAPI_TIMER_STATUS SysApiTimer10msStsMid [SYSAPI_TIMER_HI10MS_MAX] = {0};//xpRAM^C}

/*** High accuracy table(10ms)***/
const SYSAPI_TIMER_ML_REG SysApiHi10msRegTbl [SYSAPI_TIMER_MID_MAX] =
{
	{ TIMID_HI_INPUT_10MS,		1,	BLOCK_ID_INPUT, MSGID_INPUT_TIMEOUT10MS},    // (10ms)
};

/*** High accuracy table(100ms)***/
const SYSAPI_TIMER_ML_REG SysApiMid100msRegTbl [SYSAPI_TIMER_MID_MAX] =
{
	{ TIMID_MID_LED_500MS,		5,	BLOCK_ID_LED,		MSGID_LED_TIMEOUT},			// (500ms)
	{ TIMID_MID_RECODE_500MS,	5,	BLOCK_ID_RECODE,	MSGID_RECODE_TIMEOUT},		// (500ms)
	{ TIMID_MID_BLUETOOTH_50MS,	5,	BLOCK_ID_BLUETOOTH,	MSGID_BLUETOOTH_POWERTIMEOUT},	// (50ms)
};
/*
* *************************************************************************
* MODULE    :SYSAPI_TimerCountdown
* ABSTRACT  :^C}JEg_EB
* FUNCTION  :^C}ԃe[u[vAJE^lJEg_EB
* ARGUMENT  :
* NOTE      :
* RETURN    : 0:X[vp@1FEFNAbv
* CREATE    : 2014/02/11 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 SYSAPI_Timer10msCountdown(void )
{
	UINT8	ret = POWER_SLEEP;
	UINT8	i;
	FRM_MSG msg;
	//x^C}Ԃ[v
	for (i = 0; (i < SYSAPI_TIMER_HI10MS_MAX) ; i++)
	{
		// ^CAEgꍇɂ́Aw肳ꂽApp֑MB
		if(SysApiTimer10msStsHi[i].count != 0 )
		{
			SysApiTimer10msStsHi[i].count--;
			if(SysApiTimer10msStsHi[i].count == 0)
			{
				msg.blk_from	= BLOCK_ID_TIMER;
				msg.blk_to		= SysApiHi10msRegTbl[i].blk_id;
				msg.id			= SysApiHi10msRegTbl[i].msg_id;
				FRM_frm_sndmsg(msg);
				//CPUEFCNAbv
				ret = POWER_WAKEUP;
			}
		}
	}
	//x̒Pʂ10ms
	if(SysTimer100msCnt<SYSAPI_TIMER_100ms_CNT)
	{
		SysTimer100msCnt++;
	}
	else
	{
		SysTimer100msCnt=0;
		//x^C}Ԃ[v
		for (i = 0; (i < SYSAPI_TIMER_MID100MS_MAX) ; i++)
		{
			// ^CAEgꍇɂ́Aw肳ꂽApp֑MB
			if(SysApiTimer10msStsMid[i].count != 0 )
			{
				SysApiTimer10msStsMid[i].count--;
				if(SysApiTimer10msStsMid[i].count == 0)
				{
					msg.blk_from	= BLOCK_ID_TIMER;
					msg.blk_to		= SysApiMid100msRegTbl[i].blk_id;
					msg.id			= SysApiMid100msRegTbl[i].msg_id;
					FRM_frm_sndmsg(msg);
					//CPUEFCNAbv
					ret = POWER_WAKEUP;
				}
			}
		}
	}
	return ret;
}

/*
* *************************************************************************
* MODULE    :SYSAPI_TimerCountdown
* ABSTRACT  :^C}JEg_EB
* FUNCTION  :^C}ԃe[u[vAJE^lJEg_EB
* ARGUMENT  :
* NOTE      :
* RETURN    : 0:X[vp@1FEFNAbv
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 SYSAPI_TimerCountdown(void )
{
	UINT8	ret = POWER_SLEEP;
	UINT8	i;
	FRM_MSG msg;
	//x
	for (i = 0; (i < SYSAPI_TIMER_HI_MAX) ; i++)
	{
		//x^C}Ԃ[v
		if(SysApiTimerStsHi[i].count != 0 )
		{
			SysApiTimerStsHi[i].count--;
			// ^CAEgꍇɂ́Aw肳ꂽ^CAEg֐R[
			if(SysApiTimerStsHi[i].count == 0)
			{
				SysApiHiRegTbl[i].Func();
			}
		}
	}
	//x̒Pʂ10ms
	if(SysTimer10msCnt<SYSAPI_TIMER_10ms_CNT)
	{
		SysTimer10msCnt++;
	}
	else
	{
		SysTimer10msCnt=0;
		//x^C}Ԃ[v
		for (i = 0; (i < SYSAPI_TIMER_MID_MAX) ; i++)
		{
			// ^CAEgꍇɂ́Aw肳ꂽApp֑MB
			if(SysApiTimerStsMid[i].count != 0 )
			{
				SysApiTimerStsMid[i].count--;
				if(SysApiTimerStsMid[i].count == 0)
				{
					msg.blk_from	= BLOCK_ID_TIMER;
					msg.blk_to		= SysApiMidRegTbl[i].blk_id;
					msg.id			= SysApiMidRegTbl[i].msg_id;
					FRM_frm_sndmsg(msg);
					//CPUEFCNAbv
					ret = POWER_WAKEUP;
				}
			}
		}
	}
	return ret;
}

/*
* *************************************************************************
* MODULE    :SYSAPI_Timer10mhdr
* ABSTRACT  :10ms̃^C}B
* FUNCTION  :10ms̃^C}B
* ARGUMENT  :
* NOTE      :
* RETURN    : 0:X[vp@1FEFNAbv
* CREATE    : 2014/02/11 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 SYSAPI_Timer10mhdr( void )
{
	UINT8	ret = POWER_SLEEP;

	ret = SYSAPI_Timer10msCountdown();

	return ret;
}
/*
* *************************************************************************
* MODULE    :SYSAPI_Timer2mhdr
* ABSTRACT  :2ms̃^C}B
* FUNCTION  :2ms̃^C}B
* ARGUMENT  :
* NOTE      :
* RETURN    : 0:X[vp@1FEFNAbv
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
UINT8 SYSAPI_Timer2mhdr( void )
{
	UINT8	ret = POWER_SLEEP;

	ret = SYSAPI_TimerCountdown();

	return ret;
}

void Timer_Dummy_Handler( void )
{

}
/*
* *************************************************************************
* MODULE    :SYSAPI_Timer2mhdr
* ABSTRACT  :^C}ݒ肷B
* FUNCTION  :timer_id^C}IDnumx/xB
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void SYS_SetTimer(UINT16 timer_id, UINT8 num)
{
	UINT8	i;

	//x
	if(num == SYSAPI_TIMER_HIACCURACY)
	{
		for (i = 0; (i < SYSAPI_TIMER_HI_MAX) ; i++)
		{
			if(SysApiHiRegTbl[i].tim_id == timer_id)
			{
				SysApiTimerStsHi[i].count = SysApiHiRegTbl[i].tim_id;
			}
		}
	}
	//x
	else if(num == SYSAPI_TIMER_MIDACCURACY)
	{
		for (i = 0; (i < SYSAPI_TIMER_MID_MAX) ; i++)
		{
			if(SysApiMidRegTbl[i].tim_id == timer_id)
			{
				SysApiTimerStsMid[i].count = SysApiMidRegTbl[i].tim_id;
			}
		}
	}
}
/*
* *************************************************************************
* MODULE    :SYS_ClearTimer
* ABSTRACT  :^C}NAB
* FUNCTION  :timer_id^C}IDnumx/xB
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void SYS_ClearTimer(UINT16 timer_id, UINT8 num)
{
	UINT8	i;

	//x
	if(num == SYSAPI_TIMER_HIACCURACY)
	{
		for (i = 0; (i < SYSAPI_TIMER_HI_MAX) ; i++)
		{
			if(SysApiHiRegTbl[i].tim_id == timer_id)
			{
				SysApiTimerStsHi[i].count = 0;
			}
		}
	}
	//x
	else if(num == SYSAPI_TIMER_MIDACCURACY)
	{
		for (i = 0; (i < SYSAPI_TIMER_MID_MAX) ; i++)
		{
			if(SysApiMidRegTbl[i].tim_id == timer_id)
			{
				SysApiTimerStsMid[i].count = 0;
			}
		}
	}
}
