/*
 * HostDrvD.c
 *
 *  Created on: 2014/02/27
 *      Author: seagbri
 */
#include "driverlib.h"
#include "SYS_msgID.h"
#include "FRM_sys.h"
#include "FRM_frm.h"
#include "HostDrvD.h"
#include "HostDrvD_RegAccess.h"

HOSTDRV_UARTCTRL g_taHOSTC_Mng;						/* UARTǗe[u */




/*
* *************************************************************************
* MODULE    :HostDrvD_initialize
* ABSTRACT  :ʐMhCo
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_initialize(void)
{
	/* RAM */
	HostDrvD_Com_initRam();

	/* ʐMhCoԂu~vɂ */
	g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_STOP;
}

/*
* *************************************************************************
* MODULE    :HostDrvD_start
* ABSTRACT  :ʐMhCoN
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/
int8_t HostDrvD_start(uint8_t baudrate)
{
	int8_t   ret = HOSTDRV_RET_OK;			/* ߂l */

		/* UARTJnݒ */
		HostDrvD_RegAccess_startUart(baudrate);

		/* RAM */
		HostDrvD_Com_initRam();

		/* ʐMhCoԂuAChv֑J */
		g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_IDLE;

		return ret;
}

/*
* *************************************************************************
* MODULE    :HostDrvD_stop
* ABSTRACT  :ʐMhCo~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void HostDrvD_stop(void)
{
	/* UARTIݒ */
	HostDrvD_RegAccess_stopUart();

	/* ʐMhCoԂu~v֑J */
	g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_STOP;
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Com_initRam
* ABSTRACT  :RAM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/17 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void HostDrvD_Com_initRam(void)
{
	/* UARTǗe[u */
	g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_STOP;
	g_taHOSTC_Mng.TryCnt = 0;

	g_taHOSTC_Mng.tSendInfo.ucDataCnt = 0;
	g_taHOSTC_Mng.tSendInfo.ucDataNum = 0;
	g_taHOSTC_Mng.tSendInfo.ucWriteIndex = 0;
	g_taHOSTC_Mng.tSendInfo.ucReadIndex = 0;

	g_taHOSTC_Mng.tRecvInfo.ucDataSize = 0;
	g_taHOSTC_Mng.tRecvInfo.ucEventFlg = HOSTDRV_FALSE;
	g_taHOSTC_Mng.tRecvInfo.ucEventSize = 0;
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Com_Send
* ABSTRACT  :f[^M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t HostDrvD_Com_Send(uint8_t *pData, uint16_t size)
{
	uint16_t uc_DataNum;				/* Mް	*/
	uint8_t uc_SendData;				/* Mް		*/
	uint8_t  ret_stock;					/* Mް~Ϗreturn	*/
	int8_t  ret = HOSTDRV_RET_OK;			/* ߂l */

														/* Ұ	*/
	if( (size == 0) || (size > HOSTIF_MESSAGEDATA_SIZE) )
	{													/* NG */
		ret = HOSTDRV_RET_PARAM_ERR;
	}													/* ײޏ	*/
	else if(g_taHOSTC_Mng.ucSts == HOSTDRV_COMMSTS_STOP)
	{													/* NG */
		ret = HOSTDRV_RET_NG;
	}
	else
	{														/* LOK							*/
		ret_stock = HostDrvD_Com_Stock(pData, size);		/* Mް~					*/
		if(ret_stock == TRUE)
		{													/* ~ϐ					*/
		//	__DI();											/* ݋֎~		*/
			uc_DataNum = g_taHOSTC_Mng.tSendInfo.ucDataNum;	/* Mް擾	*/
		//	__EI();											/* ݋		*/

			/* MHi~ްP̏ꍇAMj	*/
			if(uc_DataNum == 1)
			{												/* M				*/											/* RTS LOW 				*/
				g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_SEND;	/* ײޏԑJ(M)	*/
				uc_SendData = HostDrvD_Com_getNextData();
				HostDrvD_RegAccess_send(uc_SendData);			/* ްM				*/

				/* gC񐔂 */
				g_taHOSTC_Mng.TryCnt = 0;
			}
		}
		else
		{														/* ~ώs					*/
			ret = HOSTDRV_RET_FULL;								/* Mޯ̧ް۰		*/
		}
	}

	return ret;		/*  */
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Com_Stock
* ABSTRACT  :Mް~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t HostDrvD_Com_Stock(uint8_t *pData, uint16_t size)
{
	uint8_t uc_DataNum;		/* Mް	*/
	uint8_t  ret;				/* return */

	ret = TRUE;

	//__DI();											/* ݋֎~		*/
	uc_DataNum = g_taHOSTC_Mng.tSendInfo.ucDataNum;	/* Mް擾	*/
	//__EI();											/* ݋		*/

													/* Mް~		*/
	if(uc_DataNum >= HOSTDRV_DATANUM)
	{												/* MްFULL			*/
		ret = FALSE;
	}
	else
	{												/* Mް~ω\		*/
													/* Mް~			*/
		g_taHOSTC_Mng.tSendInfo.ucDataSize[g_taHOSTC_Mng.tSendInfo.ucWriteIndex] = size;
		memcpy(g_taHOSTC_Mng.tSendInfo.ucData[g_taHOSTC_Mng.tSendInfo.ucWriteIndex],
				   pData,
				   size
				  );
		g_taHOSTC_Mng.tSendInfo.ucWriteIndex++;		/* IndexXV		*/
		if(g_taHOSTC_Mng.tSendInfo.ucWriteIndex >= HOSTDRV_DATANUM)
		{											/* MAX0ɂ(ݸ)	*/
			g_taHOSTC_Mng.tSendInfo.ucWriteIndex = 0;
		}

		//__DI();									/* ݋֎~		*/
		g_taHOSTC_Mng.tSendInfo.ucDataNum++;		/* MްXV	*/
		//__EI();									/* ݋		*/
	}

	return ret;		/*  */
}


/*
* *************************************************************************
* MODULE    :HostDrvD_Com_getCOMMNextData
* ABSTRACT  :ɑMCommandް擾
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/19 Seagbri/
* UPDATE    :
* **************************************************************************
*/
uint8_t HostDrvD_Com_getNextData(void)
{
	uint8_t	uc_SendData;	/* Mް		*/

	/* Mް擾	*/
	uc_SendData =g_taHOSTC_Mng.tSendInfo.ucData[g_taHOSTC_Mng.tSendInfo.ucReadIndex][g_taHOSTC_Mng.tSendInfo.ucDataCnt];

	g_taHOSTC_Mng.tSendInfo.ucDataCnt++;

													/* MްŌォH	*/
	if(g_taHOSTC_Mng.tSendInfo.ucDataSize[g_taHOSTC_Mng.tSendInfo.ucReadIndex]
		<= g_taHOSTC_Mng.tSendInfo.ucDataCnt)
	{												/* MްŌ		*/
		g_taHOSTC_Mng.ucSts = HOSTDRV_COMMSTS_IDLE;	/* ײޏԑJ(ҋ@)		*/
	}
	return uc_SendData;
}



/*
* *************************************************************************
* MODULE    :HostDrvD_Com_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_Com_sendmessage(uint16_t bfrom,uint16_t bto, uint16_t mid)
{
	FRM_MSG msg = {0};

	msg.blk_from	= bfrom;
	msg.blk_to		= bto;
	msg.id			= mid;
	FRM_frm_sndmsg(msg);
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Com_getMng
* ABSTRACT  :UARTǗe[u擾
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
HOSTDRV_UARTCTRL* HostDrvD_Com_getMng(void)
{
	return (&g_taHOSTC_Mng);
}




