/*
 * HostDrv_Int.c
 *
 *  Created on: 2014/02/27
 *      Author: seagbri
 */
#include "driverlib.h"
#include "SYS_msgID.h"
#include "HostDrvD_RegAccess.h"
#include "HostDrvD.h"
#include "FRM_frm.h"
#include "FRM_sys.h"


static void HostDrvD_Int_sendmessage(uint16_t mid, uint16_t size,uint8_t* data);
static int8_t HostDrvD_Int_createRcvData(uint8_t ucData);
static void HostDrvD_Int_recv(void);
static void HostDrvD_Int_send(void);

//******************************************************************************
//
//This is the USCI_A0 interrupt vector service routine.
//
//******************************************************************************
#pragma vector=USCI_A0_VECTOR
__interrupt void USCI_A0_ISR(void)
{
        switch (__even_in_range(UCA0IV, 4)) {
        //Vector 2 - RXIFG
        case 2:
        		HostDrvD_Int_recv();
                break;
        //Vector 4 - TXIFG
        case 4:
        		HostDrvD_Int_send();
        		break;
        default: break;
        }
}


/*
* *************************************************************************
* MODULE    :HostDrvD_Int_send
* ABSTRACT  :M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_Int_send(void)
{
	HOSTDRV_UARTCTRL*	Mng;					/* UARTǗe[u		*/
	uint8_t uc_SendData;						/* Mް		*/

	Mng = HostDrvD_Com_getMng();
	/* ײޏԂmF	*/
	if(Mng->ucSts == HOSTDRV_COMMSTS_IDLE)
	{													/* ײޏԂҋ@			*/
		/* HostDrv֑Mʒʒm(M)bZ[WM */
	//	HostDrvD_Com_sendResultMsg(BTDRV_SNDRCVSTS_OK);

		/* UARTǗðٍXV */
		Mng->tSendInfo.ucDataCnt = 0;		/* M					*/
		Mng->tSendInfo.ucReadIndex++;		/* ǍIndex				*/
		if(Mng->tSendInfo.ucReadIndex >= HOSTDRV_DATANUM)
		{									/* MAX0ɂ(ݸ)	*/
			Mng->tSendInfo.ucReadIndex = 0;
		}
		Mng->tSendInfo.ucDataNum--;			/* Mް				*/
		if(Mng->tSendInfo.ucDataNum > 0)
		{									/* Mް				*/
			/* Mްݒ	*/
			uc_SendData = HostDrvD_Com_getNextData();
		}
		Mng->ucSts = HOSTDRV_COMMSTS_SEND;	/* ײޏԑJ(M)		*/
		HostDrvD_RegAccess_send(uc_SendData);	/* ްM					*/
		/* gC񐔂 */
		Mng->TryCnt = 0;

	}
	else if(Mng->ucSts == HOSTDRV_COMMSTS_SEND)
	{	/* ײޏԂM		*/
		uc_SendData = HostDrvD_Com_getNextData();		/* ɑMް擾	*/
		if(Mng->ucSts != HOSTDRV_COMMSTS_IDLE)
		{
			HostDrvD_RegAccess_send(uc_SendData);	/* ްM					 	*/
		}
		/* gC񐔂 */
		Mng->TryCnt = 0;
	}
	else
	{
	}
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Int_recv
* ABSTRACT  :M
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_Int_recv(void)
{
	HOSTDRV_UARTCTRL*	Mng;

	int8_t  cre_data_ret;						/* ڰсA߹Đ */
	uint8_t uc_RecvData;						/* Mް */


	Mng	= HostDrvD_Com_getMng();
	/* ް */
	uc_RecvData	= HostDrvD_RegAccess_recv();
	cre_data_ret = HostDrvD_Int_createRcvData(uc_RecvData);

	/* ްʔ	*/
	if(cre_data_ret == HOSTDRV_RET_OK)
	{												/* ް			*/
		/* HostDrv֎MʒmbZ[WM */
		HostDrvD_Int_sendmessage(MSGID_HOSTIF_DRVRCV,Mng->tRecvInfo.ucDataSize,Mng->tRecvInfo.ucData);
		/* UARTǗðق̎Mر	*/
		Mng->tRecvInfo.ucDataSize = 0;				/* 	Mް		*/
	}
	else if(cre_data_ret == HOSTDRV_RET_WORK)
	{												/* ް			*/
													/* Ȃ		*/
	}
	else
	{
		/* do nothing.. */
	}

}
/*
* *************************************************************************
* MODULE    :HostDrvD_Int_createRcvSppData
* ABSTRACT  :Mް
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static int8_t HostDrvD_Int_createRcvData(uint8_t ucData)
{
	int8_t	ret;	/* return	*/
	HOSTDRV_UARTCTRL*	Mng;



	ret = HOSTDRV_RET_WORK;
	Mng	= HostDrvD_Com_getMng();

	/* Mްi[			*/
	Mng->tRecvInfo.ucData[Mng->tRecvInfo.ucDataSize] = ucData;
	Mng->tRecvInfo.ucDataSize++;
	if(Mng->tRecvInfo.ucDataSize>=HOSTIF_MESSAGEDATA_SIZE)
	{
		ret = HOSTDRV_RET_OK;
	}
	return ret;
}

/*
* *************************************************************************
* MODULE    :HostDrvD_Int_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_Int_sendmessage(uint16_t mid, uint16_t size,uint8_t* data)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_HOSTIF;
	msg.blk_to		= BLOCK_ID_HOSTIF;
	msg.id			= mid;
	msg.size		= size;
	msg.ptr			= (UINT16*)data;
	FRM_frm_sndmsg(msg);
}


