/*
 * HostDrvD_RegAccess.c
 *
 *  Created on: 2014/02/27
 *      Author: seagbri
 */
#include "driverlib.h"
#include "HostDrvD_RegAccess.h"
#include "HostDrvD.h"
/*
* *************************************************************************
* MODULE    :HostDrvD_RegAccess_startUart
* ABSTRACT  :UARTJnݒ
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void HostDrvD_RegAccess_startUart(uint8_t BaudRate)
{
static const HOSTDRV_REGACCESS_BAUDRATE HOSTDRV_12MHZTBL[HOSTDRV_BAUDRATE_NUM] =
	{
			/* 115200 */
			104,	1,	0,
			/* 230400 */
			52,		0,	0,
			/* 460800 */
			26,		0,	0
	};

	/* P2.4 Host UARTM */
	/* P2.5 Host UARTM */
    GPIO_setAsPeripheralModuleFunctionInputPin(
    		HOSTDRV_UART_PORT,
    		HOSTDRV_UART_SEND_PIN + HOSTDRV_UART_RECEIVE_PIN
            );
    /* Baudrate = (115.2kbps), clock freq = (12Mhz) */
    /* UCBRx = (104), UCBRFx = 0, UCBRSx = (1), UCOS16 = 0 */
    if ( STATUS_FAIL == USCI_A_UART_initAdvance(USCI_A0_BASE,
    											USCI_A_UART_CLOCKSOURCE_SMCLK,
    											HOSTDRV_12MHZTBL[BaudRate].UCBRx,
    											HOSTDRV_12MHZTBL[BaudRate].UCBRFx,
    											HOSTDRV_12MHZTBL[BaudRate].UCBRSx,
                                                USCI_A_UART_NO_PARITY,
                                                USCI_A_UART_MSB_FIRST,
                                                USCI_A_UART_ONE_STOP_BIT,
                                                USCI_A_UART_MODE,
                                                USCI_A_UART_LOW_FREQUENCY_BAUDRATE_GENERATION ))
            return;
    /* Enable UART module for operation */
    USCI_A_UART_enable(USCI_A0_BASE);

    /* Enable Transmit and Receive Interrupt */
    USCI_A_UART_clearInterruptFlag(USCI_A0_BASE,
                                   USCI_A_UART_RECEIVE_INTERRUPT|USCI_A_UART_TRANSMIT_INTERRUPT
                                   );
    USCI_A_UART_enableInterrupt(USCI_A0_BASE,
                                USCI_A_UART_RECEIVE_INTERRUPT|USCI_A_UART_TRANSMIT_INTERRUPT
                                );

}

/*
* *************************************************************************
* MODULE    :HostDrvD_RegAccess_startUart
* ABSTRACT  :UARTIݒ
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HostDrvD_RegAccess_stopUart(void)
{
	/* Disable UART module for operation */
	USCI_A_UART_disable(USCI_A0_BASE);
}

/*
* *************************************************************************
* MODULE    :HostDrvD_RegAccess_send
* ABSTRACT  :UARTM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

void HostDrvD_RegAccess_send(uint8_t data)
{
	/* Send data */
    USCI_A_UART_transmitData(USCI_A0_BASE,data);
}

/*
* *************************************************************************
* MODULE    :HostDrvD_RegAccess_recv
* ABSTRACT  :UARTM
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/20 Seagbri/
* UPDATE    :
* **************************************************************************
*/

uint8_t HostDrvD_RegAccess_recv(void)
{
	uint8_t receivedData;
	/* Receive the data */
	receivedData =USCI_A_UART_receiveData(USCI_A0_BASE);
	return receivedData;
}


