/*
 * HostIF.c
 *
 *  Created on: 2014/01/02
 *      Author: seagbri
 */

#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <HostIF.h>
#include <HostDrvD.h>
#include <Bluetooth.h>

void HOST_BluetoothResultCode(FRM_MSG *msg);
void HOST_BluetoothConfigRsp(void);
void HOST_DiagOn(void);
void HOST_DiagOff(void);
static void HOST_sendBTmessage(uint16_t cmd,uint16_t size,uint16_t*ptr);
static void HOST_DrvRcv(FRM_MSG *msg);

/*
* *************************************************************************
* MODULE    :HOST_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/1/2 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_Initial(void)
{
	HostDrvD_initialize();
}

/*
* *************************************************************************
* MODULE    :HOST_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/1/2 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_root(FRM_MSG *msg)
{
	switch(msg->id){
				//BluetoothConfig modeɑJڊ
		case	MSGID_HOSTIF_BLUETOOTHCONFIGRSP:
				HOST_BluetoothConfigRsp();
				break;
				//BluetoothResult Code
		case	MSGID_HOSTIF_BLUETOOTHRESULTCODE:
				HOST_BluetoothResultCode(msg);
				break;
				//Diag@Io
		case	MSGID_HOSTIF_DIAGON:
				HOST_DiagOn();
				break;
				//Diag@Ito
		case	MSGID_HOSTIF_DIAGOFF:
				HOST_DiagOff();
				break;
				//HostM
		case	MSGID_HOSTIF_DRVRCV:
				HOST_DrvRcv(msg);
				break;
		default:
				break;
	}
}
/*
* *************************************************************************
* MODULE    :HOST_BluetoothConfigRsp
* ABSTRACT  :BluetoothConfig modeɑJڊ
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/1/2 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_BluetoothConfigRsp(void)
{
	//do noting...
}
/*
* *************************************************************************
* MODULE    :HOST_BluetoothConfigRsp
* ABSTRACT  :BluetoothResult Code
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/1/2 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_BluetoothResultCode(FRM_MSG *msg)
{
	//Host͑M
	HostDrvD_Com_Send((uint8_t*)msg->ptr, msg->size);
}

/*
* *************************************************************************
* MODULE    :HOST_DiagOn
* ABSTRACT  :Diag ON
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/26 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_DiagOn(void)
{
	/*Host͒ʐMJn */
	HostDrvD_start(DBTC_HOSTD_BAUD1152);
}

/*
* *************************************************************************
* MODULE    :HOST_DiagOff
* ABSTRACT  :Diag OFF
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/26 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void HOST_DiagOff(void)
{
	/*Host͒ʐM~ */
	HostDrvD_stop();
}

/*
* *************************************************************************
* MODULE    :HOST_DrvRcv
* ABSTRACT  :Get data from driver
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/27 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void HOST_DrvRcv(FRM_MSG *msg)
{
	T_HOSTIF_FORMAT_MNGTBL* Hbuf = (T_HOSTIF_FORMAT_MNGTBL*)msg->ptr;

	/*HeadmF */
	if(Hbuf->to == HOSTIF_DATFRM_HEAD_HBM2)
	{
		/*KindmF */
		if(Hbuf->kind == HOSTIF_DATFRM_KIND_BLUETOOTH)
		{
			/*Bluetooth command */
			HOST_sendBTmessage(BLUE_HOSTCMD_CONFIG,(uint16_t)Hbuf->size,(uint16_t*)&Hbuf->data[0]);
		}
	}
}
/*
* *************************************************************************
* MODULE    :HOST_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void HOST_sendBTmessage(uint16_t cmd,uint16_t size,uint16_t*ptr)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_HOSTIF;
	msg.blk_to		= BLOCK_ID_BLUETOOTH;
	msg.id			= MSGID_BLUETOOTH_HOSTCMD;
	msg.cmd			= cmd;
	msg.size		= size;
	msg.ptr			= (UINT16*)ptr;

	FRM_frm_sndmsg(msg);
}
