/*
 * Input.c
 *
 *  Created on: 2013/09/13
 *      Author: seagbri
 */
#include "driverlib.h"
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Input.h>
#include <Recode.h>
#include <Bluetooth.h>

UINT8		ModeSWStatus;			// MODE SWm
UINT8		ModeSWCht;				// MODE SW`^EJE^
UINT8		AlarmSWStatus;			// ALARM SWm
UINT8		AlarmSWCht;				// ALARM SW`^EJE^
UINT8		SDCardDetStatus;		// SD Card detectm
UINT8		SDCardDetCht;			// SD Card detect`^EJE^
UINT8		DiagDetStatus;			// Diag detectm
UINT8		DiagDetCht;				// Diag detect`^EJE^

static void INPUT_Start(void);
static void INPUT_CheckNotifyMODESW(void);
static void INPUT_NotifyMODESW(void);
static void INPUT_ModeSWCht(void);
static void INPUT_CheckNotifyALARMSW(void);
static void INPUT_NotifyALARMSW(void);
static void INPUT_AlarmSWCht(void);
static void INPUT_CheckNotifySDCardDet(void);
static void INPUT_SDCardCht(void);
static void INPUT_NotifySDCardDet(void);
static void INPUT_CheckNotifyDiagDet(void);
static void INPUT_DiagCht(void);
static void INPUT_NotifyDiagDet(void);
static void INPUT_sendmessage(UINT16 bto, UINT16 mid,UINT16 cmd);
static UINT8 INPUT_Chata(UINT8 ChtCnt, UINT8 OnOff);
/*
* *************************************************************************
* MODULE    :INTEG_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void INPUT_root(FRM_MSG *msg)
{
	switch(msg->id){
			//Jn
		case MSGID_INPUT_START:
			INPUT_Start();
			break;
			//10ms@cycle
		case MSGID_INPUT_TIMEOUT10MS:
			INPUT_10msCircle();
			break;
			//1s@cycle
		case MSGID_INPUT_TIMEOUT1S:
			INPUT_1sCircle();
			break;
		default:
			break;
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void INPUT_Initial(void)
{
	/* MODE SW  */
	ModeSWStatus	= OFF;
	ModeSWCht		= COUNT_OFF;

	/* Jn */
	INPUT_Start();
}
/*
* *************************************************************************
* MODULE    :INPUT_Start
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_Start(void)
{
	//10ms timer start
	SYS_SetTimer(MSGID_INPUT_TIMEOUT10MS,SYSAPI_TIMER_MIDACCURACY);
}
/*
* *************************************************************************
* MODULE    :INPUT_10msCircle
* ABSTRACT  :10ms@cycle
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void INPUT_10msCircle(void)
{
	/* Off SW Check */
	/* Real SW check */
	/* Recoder SW check */
	INPUT_CheckNotifyMODESW();
	/* Alarm SW check */
	INPUT_CheckNotifyALARMSW();
	/* SD Card detect check */
	INPUT_CheckNotifySDCardDet();
	/* Diag detect check */
	INPUT_CheckNotifyDiagDet();
	/* 10ms timer start */
	SYS_SetTimer(MSGID_INPUT_TIMEOUT10MS,SYSAPI_TIMER_MIDACCURACY);
}

void INPUT_1sCircle(void)
{
	//SD card start

	//100ms timer start
	SYS_SetTimer(MSGID_INPUT_TIMEOUT1S,SYSAPI_TIMER_MIDACCURACY);
}

/*
* *************************************************************************
* MODULE    :INPUT_CheckNotifyMODESW
* ABSTRACT  :MODE SW ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_CheckNotifyMODESW(void)
{
	UINT8	Last_ModeSW;							//MODE SWԕێ[N

	/* MODE SW 捞݊Jn */
	Last_ModeSW = ModeSWStatus;						//MODE SW Xgԕۑ
	/* MODE SW `^O */
	INPUT_ModeSWCht();
	/* MODE SWω */
	if(Last_ModeSW != ModeSWStatus )
	{
		/* MODE SW̏Ԃʒm */
		INPUT_NotifyMODESW();
	}
	else
	{
		//ωȂׁAȂ
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_ModeSWCht
* ABSTRACT  :`^O
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_ModeSWCht(void)
{
	UINT8 Port;

	/* MODE SWḿA|[g͂̏ꍇ	*/
	Port = GPIO_getInputPinValue(GPIO_PORT_P1,GPIO_PIN7);

	/* MODE SWḿA|[g͂̏ꍇ										*/
	if( Port == MODESW_ON )
	{
		Port = ON;									/* ڑ					*/
	}
	else
	{
		Port = OFF;									/* ڑ				*/
	}

	ModeSWCht = INPUT_Chata(ModeSWCht, Port);		/* `^O		*/

	if( ModeSWCht >= ON_CHT4 )						/* `^ʂONmH	*/
	{
		ModeSWStatus = ON;
	}
	else if( (ModeSWCht & OFF_MASK) >= OFF_CHT4 )	/* `^ʂOFFmH*/
	{
		ModeSWStatus = OFF;
	}
	else
	{
		/* Ȃ															*/
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_NotifyMODESW
* ABSTRACT  :ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_NotifyMODESW(void)
{

	if(ModeSWStatus == MODESW_ON)
	{
		/* MODE SW M	*/
		INPUT_sendmessage(BLOCK_ID_INTEG, MSGID_INPUT_INPUTNOTIFY, INPUT_NOTIFY_MODESW_ON);
	}
	else
	{
		/* MODE SW M	*/
		INPUT_sendmessage(BLOCK_ID_INTEG, MSGID_INPUT_INPUTNOTIFY, INPUT_NOTIFY_MODESW_OFF);
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_CheckNotifyALARMSW
* ABSTRACT  :ALARM SW ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_CheckNotifyALARMSW(void)
{
	UINT8	Last_AlarmSW;							//ALARM SWԕێ[N

	/* ALARM SW 捞݊Jn */
	Last_AlarmSW = ModeSWStatus;						//ALARM SW Xgԕۑ
	/* ALARM SW `^O */
	INPUT_AlarmSWCht();
	/* ALARM SWω */
	if(Last_AlarmSW != AlarmSWStatus )
	{
		/* ALARM SW̏Ԃʒm */
		INPUT_NotifyALARMSW();
	}
	else
	{
		//ωȂׁAȂ
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_AlarmSWCht
* ABSTRACT  :`^O
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_AlarmSWCht(void)
{
	UINT8 Port;

	/* ALARM SWḿA|[g͂̏ꍇ	*/
	Port = GPIO_getInputPinValue(GPIO_PORT_P3,GPIO_PIN0);

	/* ALARM SWḿA|[g͂̏ꍇ										*/
	if( Port == ALARMSW_ON )
	{
		Port = ON;									/* ڑ					*/
	}
	else
	{
		Port = OFF;									/* ڑ				*/
	}

	AlarmSWCht = INPUT_Chata(AlarmSWCht, Port);		/* `^O		*/

	if( AlarmSWCht >= ON_CHT4 )						/* `^ʂONmH	*/
	{
		AlarmSWStatus = ON;
	}
	else if( (AlarmSWCht & OFF_MASK) >= OFF_CHT4 )	/* `^ʂOFFmH*/
	{
		AlarmSWStatus = OFF;
	}
	else
	{
		/* Ȃ															*/
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_NotifyALARMSW
* ABSTRACT  :ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_NotifyALARMSW(void)
{

	if(AlarmSWStatus == ALARMSW_ON)
	{
		/* Alarm SW M	*/
		INPUT_sendmessage(BLOCK_ID_INTEG, MSGID_INPUT_INPUTNOTIFY, INPUT_NOTIFY_ALARMSW_ON);
	}
	else
	{
		/* Alarm SW M	*/
		INPUT_sendmessage(BLOCK_ID_INTEG, MSGID_INPUT_INPUTNOTIFY, INPUT_NOTIFY_ALARMSW_OFF);
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_CheckNotifyDiagDet
* ABSTRACT  :Diag ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/25 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_CheckNotifyDiagDet(void)
{
	UINT8	Last_Diag;								//Diag detectԕێ[N

	/* Diag 捞݊Jn */
	Last_Diag = DiagDetStatus;						//SD Card detect Xgԕۑ
	/* Diag `^O */
	INPUT_DiagCht();
	/* Diagω */
	if(Last_Diag != DiagDetStatus )
	{
		/* Diag̏Ԃʒm */
		INPUT_NotifyDiagDet();
	}
	else
	{
		//ωȂׁAȂ
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_CheckNotifySDCardDet
* ABSTRACT  :SD Card ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_CheckNotifySDCardDet(void)
{
	UINT8	Last_SDCard;							//SD Card detectԕێ[N

	/* SD Card 捞݊Jn */
	Last_SDCard = SDCardDetStatus;					//SD Card detect Xgԕۑ
	/* SD Card `^O */
	INPUT_SDCardCht();
	/* SD Cardω */
	if(Last_SDCard != SDCardDetStatus )
	{
		/* SD Card̏Ԃʒm */
		INPUT_NotifySDCardDet();
	}
	else
	{
		//ωȂׁAȂ
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_DiagCht
* ABSTRACT  :`^O
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/25 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_DiagCht(void)
{
	UINT8 Port;

	/* SD Card detectḿA|[g͂̏ꍇ	*/
	Port = GPIO_getInputPinValue(GPIO_PORT_P1,GPIO_PIN6);

	/* SD Card detectḿA|[g͂̏ꍇ										*/
	if( Port == DIAGDET_ON )
	{
		Port = ON;									/* ڑ					*/
	}
	else
	{
		Port = OFF;									/* ڑ				*/
	}

	DiagDetCht = INPUT_Chata(DiagDetCht, Port);	/* `^O		*/

	if( DiagDetCht >= ON_CHT4 )					/* `^ʂONmH	*/
	{
		DiagDetStatus = ON;
	}
	else if( (DiagDetCht & OFF_MASK) >= OFF_CHT4 )/* `^ʂOFFmH*/
	{
		DiagDetStatus = OFF;
	}
	else
	{
		/* Ȃ															*/
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_NotifyDiagDet
* ABSTRACT  :ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/25 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_NotifyDiagDet(void)
{

	if(DiagDetStatus == DIAGDET_ON)
	{
		/* SD Card detect M	*/
		INPUT_sendmessage(BLOCK_ID_BLUETOOTH, MSGID_INPUT_DIAGDET, INPUT_DIAGDET_ON);
	}
	else
	{
		/* SD Card detect M	*/
		INPUT_sendmessage(BLOCK_ID_BLUETOOTH, MSGID_INPUT_DIAGDET, INPUT_DIAGDET_OFF);
	}
}
/*
* *************************************************************************
* MODULE    :INPUT_SDCardCht
* ABSTRACT  :`^O
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_SDCardCht(void)
{
	UINT8 Port;

	/* SD Card detectḿA|[g͂̏ꍇ	*/
	Port = GPIO_getInputPinValue(GPIO_PORT_P4,GPIO_PIN2);

	/* SD Card detectḿA|[g͂̏ꍇ										*/
	if( Port == SDCARDDET_ON )
	{
		Port = ON;									/* ڑ					*/
	}
	else
	{
		Port = OFF;									/* ڑ				*/
	}

	SDCardDetCht = INPUT_Chata(SDCardDetCht, Port);	/* `^O		*/

	if( SDCardDetCht >= ON_CHT4 )					/* `^ʂONmH	*/
	{
		SDCardDetStatus = ON;
	}
	else if( (SDCardDetCht & OFF_MASK) >= OFF_CHT4 )/* `^ʂOFFmH*/
	{
		SDCardDetStatus = OFF;
	}
	else
	{
		/* Ȃ															*/
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_NotifySDCardDet
* ABSTRACT  :ʒm
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_NotifySDCardDet(void)
{

	if(SDCardDetStatus == SDCARDDET_ON)
	{
		/* SD Card detect M	*/
		INPUT_sendmessage(BLOCK_ID_RECODE, MSGID_RECODE_SDCARDDET, RECODE_SDCARDDET_ON);
	}
	else
	{
		/* SD Card detect M	*/
		INPUT_sendmessage(BLOCK_ID_RECODE, MSGID_RECODE_SDCARDDET, RECODE_SDCARDDET_OFF);
	}
}

/*
* *************************************************************************
* MODULE    :INPUT_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INPUT_sendmessage(UINT16 bto, UINT16 mid,UINT16 cmd)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_INPUT;
	msg.blk_to		= bto;
	msg.id			= mid;
	msg.cmd			= cmd;
	FRM_frm_sndmsg(msg);
}

/*
* *************************************************************************
* MODULE    :INPUT_NotifyMICDET
* ABSTRACT  :ʃ`^O
* FUNCTION  :u_int8 ChtCnt ..... `^OJE^
* 			 BOOL OnOff ..... ON/OFF
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static UINT8 INPUT_Chata(UINT8 ChtCnt, UINT8 OnOff)
{
	if( OnOff == ON )								/* |[gON ?			*/
	{
		if( ChtCnt != ON_MASK )						/* ONA15񖢖 ?	*/
		{
			ChtCnt += ON_COUNT;
		}
		ChtCnt &= ON_MASK;
	}
	else
	{
		if( ChtCnt != OFF_MASK )					/* OFFA15񖢖 ?	*/
		{
			ChtCnt += OFF_COUNT;
		}
		ChtCnt &= OFF_MASK;
	}
	return(ChtCnt);									/* `^OJE^Ԃ*/
}
