/*
 * Integmang.c
 *
 *  Created on: 2013/09/13
 *      Author: seagbri
 */
#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Input.h>
#include <Integmang.h>
#include <Power.h>

uint8_t Integ_mode;
uint8_t Integ_Btmode;

static void INTEG_Start(void);
static void INTEG_Input(UINT16 cmd);
static void INTEG_Vbuson(void);
static void INTEG_Vbusoff(void);

static void INTEG_Input_ModeSwOff(void);
static void INTEG_Input_ModeSwOn(void);
static void INTEG_sendmessage(UINT16 bfrom,UINT16 bto, UINT16 mid);
static void INTEG_Input_AlarmSwOff(void);
static void INTEG_Input_AlarmSwOn(void);
static void INTEG_DiagDet(UINT16 cmd);
static void INTEG_WaitSleepTimeout(void);
static void INTEG_WakeUp(void);
/*
* *************************************************************************
* MODULE    :INTEG_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void INTEG_root(FRM_MSG *msg)
{
	switch(msg->id){
				//Jn
		case	MSGID_INTEG_START:
				INTEG_Start();
				break;
		case	MSGID_INPUT_INPUTNOTIFY:
				//Inputʒm
				INTEG_Input(msg->cmd);
				break;
				//InputʒmiVBUS ONj
		case	MSGID_INPUT_VBUSON:
				INTEG_Vbuson();
				break;
				//InputʒmiVBUS OFFj
		case	MSGID_INPUT_VBUSOFF:
				INTEG_Vbusoff();
				break;
				//InputʒmiDiag detectj
		case	MSGID_INPUT_DIAGDET:
				INTEG_DiagDet(msg->cmd);
				break;
				//Time out(Off[hŃX[v҂)
		case	MSGID_INTEG_WAITSLEEPTIMEOUT:
				INTEG_WaitSleepTimeout();
				break;
		case	MSGID_INTEG_WAKEUP:
				INTEG_WakeUp();
				break;
		default:
			break;
	}
}
/*
* *************************************************************************
* MODULE    :INTEG_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void INTEG_Initial(void)
{
	//Bluetooth̓I[gݒ
	Integ_Btmode = INTEG_BTMODE_AUTO;
	//[hOffݒ
	Integ_mode = INTEG_MODE_OFF;
	//Jn𑗐M
	INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_INTEG,MSGID_INTEG_START);
}

/*
* *************************************************************************
* MODULE    :INTEG_Start
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Start(void)
{
	//TestpLED_ł
	INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_LED,MSGID_LED_TEST);

}

/*
* *************************************************************************
* MODULE    :INTEG_Input
* ABSTRACT  :InputʒmM
* FUNCTION  :
* ARGUMENT  :cmd@InputʐMR}h
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Input(UINT16 cmd)
{
	switch(cmd){
		case	INPUT_NOTIFY_OFFSW_OFF:
				break;
		case	INPUT_NOTIFY_OFFSW_ON:
				break;
		case	INPUT_NOTIFY_REALSW_OFF:
				break;
		case	INPUT_NOTIFY_REALSW_ON:
				break;
		case	INPUT_NOTIFY_RECODESW_OFF:
				break;
		case	INPUT_NOTIFY_RECODESW_ON:
				break;
				//Mode SW OFF
		case	INPUT_NOTIFY_MODESW_OFF:
				INTEG_Input_ModeSwOff();
				break;
				//Mode SW ON
		case	INPUT_NOTIFY_MODESW_ON:
				INTEG_Input_ModeSwOn();
				break;
				//Alarm SW Off
		case	INPUT_NOTIFY_ALARMSW_OFF:
				INTEG_Input_AlarmSwOff();
				break;
				//Alarm SW ON
		case	INPUT_NOTIFY_ALARMSW_ON:
				INTEG_Input_AlarmSwOn();
				break;
		default:
			break;
	}
}
/*
* *************************************************************************
* MODULE    :INTEG_Input_AlarmSwOff
* ABSTRACT  :Alarm SW OFF
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/12 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Input_AlarmSwOff(void)
{
}
/*
* *************************************************************************
* MODULE    :INTEG_Input_AlarmSwOn
* ABSTRACT  :Alarm SW ON
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/12 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Input_AlarmSwOn(void)
{
	//Mode offȊȌꍇ
	if( Integ_mode != INTEG_MODE_OFF )
	{
		//RecodeONvʒm
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_ECGM,MSGID_ECGM_ALARMNOTIFY);
	}
	//Mode off̏ꍇ
	else
	{
	}
}
/*
* *************************************************************************
* MODULE    :INTEG_Input_ModeSwOff
* ABSTRACT  :Mode SW OFF
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Input_ModeSwOff(void)
{
}
/*
* *************************************************************************
* MODULE    :INTEG_Input_ModeSwOn
* ABSTRACT  :Mode SW ON
* FUNCTION  :
* ARGUMENT  :cmd@InputʐMR}h
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_Input_ModeSwOn(void)
{
	//Mode off̏ꍇ
	if( Integ_mode == INTEG_MODE_OFF )
	{
		Integ_mode = INTEG_MODE_RECODE;
		//RecodeONvʒm
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_RECODE,MSGID_RECODE_START);
	}
	//Mode Recodȅꍇ
	else if( Integ_mode == INTEG_MODE_RECODE )
	{
		Integ_mode = INTEG_MODE_BLUETOOTH;
		//RecodeOFFvʒm
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_RECODE,MSGID_RECODE_STOP);
		//BluetoothONvʒm
		if(Integ_Btmode == INTEG_BTMODE_AUTO)
		{
			INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_BLUETOOTH,MSGID_RECODE_START);
		}
		else
		{
			INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_BLUETOOTH,MSGID_BLUETOOTH_CONFIGSTART);
		}
	}
	//Mode Bluetooth̏ꍇ
	else
	{
		Integ_mode = INTEG_MODE_OFF;
		//RecodeOFFvʒm
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_RECODE,MSGID_RECODE_STOP);
		//BluetoothOFFvʒm
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_RECODE,MSGID_RECODE_STOP);
		//100ms^C}ZbgAX[v҂
		SYS_SetTimer(TIMID_INTEG_WATISLEEP,SYSAPI_TIMER_MIDACCURACY);
	}
}

static void INTEG_Vbuson(void)
{
}
static void INTEG_Vbusoff(void)
{
}

/*
* *************************************************************************
* MODULE    :INTEG_DiagDet
* ABSTRACT  :Diag detect
* FUNCTION  :
* ARGUMENT  :cmd@InputʐMR}h
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/26 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_DiagDet(UINT16 cmd)
{
	if(cmd == INPUT_DIAGDET_ON)
	{
		Integ_Btmode = INTEG_BTMODE_AUTO;
		/* HostIF̓Iv */
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_HOSTIF,MSGID_HOSTIF_DIAGON);
	}
	else
	{
		Integ_Btmode = INTEG_BTMODE_COMM;
		/* HostIF̓Itv */
		INTEG_sendmessage(BLOCK_ID_INTEG,BLOCK_ID_HOSTIF,MSGID_HOSTIF_DIAGOFF);
	}
}
/*
* *************************************************************************
* MODULE    :INTEG_WaitSleepTimeout
* ABSTRACT  :Time out(Off[hŃX[v҂)
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/28 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_WaitSleepTimeout(void)
{
	//Mode off̏ꍇ
	if( Integ_mode == INTEG_MODE_OFF )
	{
		/* X[v */
		POW_EnterPowerSaveDeep();
	}
}
/*
* *************************************************************************
* MODULE    :INTEG_WakeUp
* ABSTRACT  :EFNAbv
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/28 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_WakeUp(void)
{
	//100ms^C}ZbgAX[v҂
	SYS_SetTimer(TIMID_INTEG_WATISLEEP,SYSAPI_TIMER_MIDACCURACY);
}
/*
* *************************************************************************
* MODULE    :INTEG_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bfrom M bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void INTEG_sendmessage(UINT16 bfrom,UINT16 bto, UINT16 mid)
{
	FRM_MSG msg = {0};

	msg.blk_from	= bfrom;
	msg.blk_to		= bto;
	msg.id			= mid;
	FRM_frm_sndmsg(msg);
}
