/*
 * Led.c
 *
 *  Created on: 2013/12/18
 *      Author: seagbri
 */
#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Led.h>

uint8_t LED_testLed;

void LED_AllStop(void);
void LED_RecodeReq(UINT16 cmd);
void LED_Test(void);

/*
* *************************************************************************
* MODULE    :LED_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_root(FRM_MSG *msg)
{
	switch(msg->id){
				//S
		case	MSGID_LED_ALLSTOP:
				LED_AllStop();
				break;
				//eXgp
		case	MSGID_LED_TEST:
				LED_Test();
				break;
				//Recode_Ev
		case	MSGID_LED_RECREQ:
				LED_RecodeReq(msg->cmd);
				break;
		default:
			break;
	}
}

/*
* *************************************************************************
* MODULE    :LED_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_Initial(void)
{

}

/*
* *************************************************************************
* MODULE    :LED_AllStop
* ABSTRACT  :S
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_AllStop(void)
{

}

/*
* *************************************************************************
* MODULE    :LED_Test
* ABSTRACT  :eXgp
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_Test(void)
{
	//TestypLED_
	LED_testLed=1;
	GPIO_setOutputHighOnPin(GPIO_PORT_P1,GPIO_PIN1);	//High
	//500ms^C}Zbg
	SYS_SetTimer(TIMID_LED_500MS,SYSAPI_TIMER_MIDACCURACY);
}

/*
* *************************************************************************
* MODULE    :LED_Timeout
* ABSTRACT  :eXgp
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_Timeout(void)
{
	if(LED_testLed == 0)
	{
		LED_testLed=1;
		GPIO_setOutputHighOnPin(GPIO_PORT_P1,GPIO_PIN1);	//High
	}
	else
	{
		LED_testLed=0;
		GPIO_setOutputLowOnPin(GPIO_PORT_P1,GPIO_PIN1);		//Low
	}
	//500ms^C}Zbg
	SYS_SetTimer(TIMID_LED_500MS,SYSAPI_TIMER_MIDACCURACY);
}
/*
* *************************************************************************
* MODULE    :LED_RecodeReq
* ABSTRACT  :Recode_Ev
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void LED_RecodeReq(UINT16 cmd)
{
	switch(LEDAPI_RECODE_ON)
	{
		case	LEDAPI_RECODE_ON:
				break;
		case	LEDAPI_RECODE_OFF:
				break;
		case	LEDAPI_RECODE_ERROR:
				break;
	}
}
