/*
 * Power.c
 *
 *  Created on: 2013/12/19
 *      Author: seagbri
 */
#include "driverlib.h"
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Power.h>
#include <Bluetooth.h>
#include <EcgM.h>
#include <HostIF.h>
#include <Input.h>
#include <Integmang.h>
#include <Led.h>
#include <Recode.h>

static void POW_ColdStart(void);
static void POW_BeforeEnterPowerSaveDeep(void);
static void POWER_sendmessage(UINT16 bto, UINT16 mid);
/*
* *************************************************************************
* MODULE    :POW_Initialize
* ABSTRACT  :S
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_Initialize(void)
{
	/* Stop watchdog timer */
	WDT_A_hold(WDT_A_BASE);
	/* Config clocks. MCLK=SMCLK=MCLK_FREQUENCY; ACLK=REFO=32kHz */
	POW_initClocks(MCLK_FREQUENCY);
	/* |[g */
	POW_initPort();
	/* RTC */
	POW_initRtc();
	/* ^C} */
	POW_initTimer();
	/* e@\ */
	POW_ColdStart();
}

/*
* *************************************************************************
* MODULE    :POW_ColdStart
* ABSTRACT  :e@\
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/11 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void POW_ColdStart(void)
{
	/* Bluetooth */
	BLUE_Initial();
	/* Recode */
	RECODE_Initial();
	/* EcgM */
	ECGM_Initial();
	/* Input */
	INPUT_Initial();
	/* Host */
	HOST_Initial();
	/* Integmang */
	INTEG_Initial();
	/* LED */
	LED_Initial();
}
/*
* *************************************************************************
* MODULE    :POW_initRtc
* ABSTRACT  :RTC
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2014/02/10 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_initRtc(void)
{
	Calendar currentTime;

    //Setup Current Time for Calendar
    currentTime.Seconds    = 00;
    currentTime.Minutes    = 26;
    currentTime.Hours      = 13;
    currentTime.DayOfWeek  = 03;
    currentTime.DayOfMonth = 20;
    currentTime.Month      = 02;
    currentTime.Year       = 2014;
    //Initialize Calendar Mode of RTC
    /*
     * Base Address of the RTC_A_A
     * Pass in current time, intialized above
     * Use binary as Calendar Register Format
     */
    RTC_B_calendarInit(RTC_B_BASE,
                       currentTime,
                       RTC_B_FORMAT_BINARY);

    RTC_B_clearInterrupt(RTC_B_BASE,
                         RTCRDYIFG + RTCTEVIFG + RTCAIFG);
    //Start RTC Clock
    RTC_B_startClock(RTC_B_BASE);
}
/*
* *************************************************************************
* MODULE    :POW_initPort
* ABSTRACT  :|[g
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_initPort(void)
{
	/************* P1 ***************/
	//P1.0 NC
	//P1.1 LED4@]p
	//P1.2 LED5@]p
	GPIO_setAsOutputPin(GPIO_PORT_P1,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2);		// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P1,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2);		// Low
	//P1.3 S8 DIPXCb`]p
	//P1.4 S8 DIPXCb`]p
	//P1.5 S8 DIPXCb`]p
	//P1.6 S8 DIPXCb`]p
	//P1.7 S4 MODE XCb`
	GPIO_setAsInputPinWithPullUpresistor(GPIO_PORT_P1,GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
																// Set  to input PullUp

	//test
	GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P1,GPIO_PIN0);

	/************* P2 ***************/
	//P2.0 PS/SYNC@DC/DC(L=DC/DC Power Save)
	//P2.1 NC
	//P2.2 NC
	//P2.3 NC
	//P2.4 NC
	//P2.5 NC
	//P2.6 NC
	//P2.7 NC
	GPIO_setAsOutputPin(GPIO_PORT_P2,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);				// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P2,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);				// Low

	/************* P3 ***************/

	//P3.0 S5 ALARM XCb`
	GPIO_setAsInputPinWithPullUpresistor(GPIO_PORT_P3,GPIO_PIN0);// Set  to input PullUp
	//P3.1 LED1 Y  Bluetooth[h
	//P3.2 LED1 G Bluetooth[h
	//P3.3 LED2 Y Storage[h
	//P3.5 LED2 G Storage[h
	//P3.6 LED3 Y dCWP[^
	//P3.7 LED3 G dCWP[^
	GPIO_setAsOutputPin(GPIO_PORT_P3,GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P3,GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
																// Low
	//test
	GPIO_setOutputHighOnPin(GPIO_PORT_P3,GPIO_PIN1|GPIO_PIN2);
																// High
	GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P3,GPIO_PIN4);

	/************* P4 ***************/
	//P4.0 S7 ]p
	//P4.1 NC
	//P4.2 microSD Card oiLFJ[h}jSDIN
	//P4.7 Bluetooth UART CTS
	GPIO_setAsInputPinWithPullUpresistor(GPIO_PORT_P4,GPIO_PIN0|GPIO_PIN2|GPIO_PIN7);
																// Set  to input PullUp
	//P4.3 Bluetooth Not in use
	//P4.4 Bluetooth Not in use
	//P4.5 Bluetooth BT_ROLE(Low:Slave)
	//P4.6 Bluetooth BT_MODE(High:Automatic Mode)
	GPIO_setAsOutputPin(GPIO_PORT_P4,GPIO_PIN1|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P4,GPIO_PIN1|GPIO_PIN3|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6);
																// Low


	/************* P6 ***************/
	//P6.0 NC
	//P6.1 NC
	//P6.2 NC
	//P6.3 NC
	//P6.4 NC
	//P6.7 NC
	GPIO_setAsOutputPin(GPIO_PORT_P6,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN7);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P6,GPIO_PIN0|GPIO_PIN1|GPIO_PIN2|GPIO_PIN3|GPIO_PIN4|GPIO_PIN7);
																// Low

	//P6.6 dĎH̃Cl[u/fBZ[u̐؂ւ
	GPIO_setAsOutputPin(GPIO_PORT_P6,GPIO_PIN6);				// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P6,GPIO_PIN6);				// Low
	//P6.5 A/DRo[^(VBATA1)
    //Enable A/D channel A0
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P6,
            GPIO_PIN5
            );

    /************* P7 ***************/
	//P7.4 NC
	//P7.5 NC
	//P7.7 NC
	GPIO_setAsOutputPin(GPIO_PORT_P7,GPIO_PIN4|GPIO_PIN5|GPIO_PIN7);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P6,GPIO_PIN4|GPIO_PIN5|GPIO_PIN7);
																// Low

    //P7.6 A/DRo[^(ECGf[^)
    //Enable A/D channel A0
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P7,
            GPIO_PIN6
            );

    /************* P8 ***************/
	//P8.0 Bluetooth UART RESET
	//P8.1 Bluetooth UART RTS
	//P8.4 BluetoothdON/OFF
	//P8.7 microSD Card dON/OFF
	GPIO_setAsOutputPin(GPIO_PORT_P8,GPIO_PIN0|GPIO_PIN1|GPIO_PIN4|GPIO_PIN7);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P8,GPIO_PIN0|GPIO_PIN4|GPIO_PIN7);
																// Low
	//P8.2 Bluetooth UARTM
	//P8.3 Bluetooth UARTM
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P8,
            GPIO_PIN2 + GPIO_PIN3
            );
	//P8.5 xZT[ I2Cf[^
	//P8.6 xZT[ I2CNbN
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P8,
            GPIO_PIN5 + GPIO_PIN6
            );

    /************* P9 ***************/
    //P9.1 microSD Card SPI CLK
    //P9.2 microSD Card SPI M
    //P9.3 microSD Card SPI M
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P9,
            GPIO_PIN1 + GPIO_PIN2+ GPIO_PIN3
            );
    //P9.0 microSD Card SPI CS
    //P9.4 NC
    //P9.5 NC
    //P9.6 NC
    //P9.7 NC
	GPIO_setAsOutputPin(GPIO_PORT_P9,GPIO_PIN0|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
																// Set  to output direction
	GPIO_setOutputLowOnPin(GPIO_PORT_P9,GPIO_PIN0|GPIO_PIN4|GPIO_PIN5|GPIO_PIN6|GPIO_PIN7);
																// Low
}
/*
* *************************************************************************
* MODULE    :POW_initClocks
* ABSTRACT  :NbN
* FUNCTION  :SMCLK=XT2=12MhzAACLK=REFOCLK=32768hz
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_initClocks(DWORD mclkFreq)
{
//test
#if 1
	uint8_t returnValue = 0;

    //Initializes the XT1 and XT2 crystal frequencies being used
    UCS_setExternalClockSource(  UCS_BASE,
                                 UCS_XT1_CRYSTAL_FREQUENCY,
                                 UCS_XT2_CRYSTAL_FREQUENCY
                                 );

    //Initialize XT1. Returns STATUS_SUCCESS if initializes successfully
    returnValue = UCS_LFXT1StartWithTimeout(
            UCS_BASE,
            UCS_XT1_DRIVE0,
            UCS_XCAP_3,
            UCS_XT1_TIMEOUT
            );

    //Startup HF XT2 crystal Port select XT2
    GPIO_setAsPeripheralModuleFunctionInputPin(
            GPIO_PORT_P7,
            GPIO_PIN2 + GPIO_PIN3
            );

    //Initialize XT2. Returns STATUS_SUCCESS if initializes successfully
    returnValue = UCS_XT2StartWithTimeout(
            UCS_BASE,
            UCS_XT2DRIVE_8MHZ_16MHZ,
            UCS_XT2_TIMEOUT
            );

    //Set DCO FLL reference = REFO
    UCS_clockSignalInit(
            UCS_BASE,
            UCS_FLLREF,
            UCS_REFOCLK_SELECT,
            UCS_CLOCK_DIVIDER_1
            );

    //Select XT1 as ACLK source
    UCS_clockSignalInit(
            UCS_BASE,
            UCS_ACLK,
            UCS_XT1CLK_SELECT,
            UCS_CLOCK_DIVIDER_1
            );

#ifdef POWER_USEDCO_ENABLE
    //Select DCO as SMCLK source
    UCS_clockSignalInit(
            UCS_BASE,
            UCS_SMCLK,
            UCS_DCOCLK_SELECT,
            UCS_CLOCK_DIVIDER_1
            );
    //Stop XT2
    UCS_XT2Off(UCS_BASE);
#else
    //Select XT2 as SMCLK source
    UCS_clockSignalInit(
            UCS_BASE,
            UCS_SMCLK,
            UCS_XT2CLK_SELECT,
            UCS_CLOCK_DIVIDER_1
            );
#endif
    //Set Ratio and Desired MCLK Frequency  and initialize DCO
    UCS_initFLLSettle(
        UCS_BASE,
        mclkFreq/1000,
        mclkFreq/32768);

    // Enable global oscillator fault flag
    SFR_clearInterrupt(SFR_BASE,
                       SFR_OSCILLATOR_FAULT_INTERRUPT
                       );
    SFR_enableInterrupt(SFR_BASE,
                        SFR_OSCILLATOR_FAULT_INTERRUPT
                        );

    // Enable global interrupt
    __bis_SR_register(GIE);

//
#else
	//12MhzNbNݒ肷
	UCS_clockSignalInit(
	   UCS_BASE,
	   UCS_SMCLK,
	   UCS_XT2CLK_SELECT,
	   UCS_CLOCK_DIVIDER_1);

	UCS_clockSignalInit(
	   UCS_BASE,
	   UCS_ACLK,
	   UCS_XT1CLK_SELECT,
	   UCS_CLOCK_DIVIDER_1);

    UCS_initFLLSettle(
        UCS_BASE,
        mclkFreq/1000,
        mclkFreq/32768);
    // Enable global interrupt
    __bis_SR_register(GIE);
#endif
}
/*
* *************************************************************************
* MODULE    :POW_initTimer
* ABSTRACT  :^C}
* FUNCTION  :TimerA=2ms
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_initTimer(void)
{
	//10ms^C}ݒ肷
    TIMER_A_clearTimerInterruptFlag(TIMER_A0_BASE);
#if 1
    TIMER_A_configureUpMode(TIMER_A0_BASE,
    	TIMER_A_CLOCKSOURCE_SMCLK,
    	TIMER_A_CLOCKSOURCE_DIVIDER_12,
        10000,
        TIMER_A_TAIE_INTERRUPT_DISABLE,
        TIMER_A_CAPTURECOMPARE_INTERRUPT_ENABLE,
        TIMER_A_DO_CLEAR
        );

    TIMER_A_startCounter(TIMER_A0_BASE,
        TIMER_A_UP_MODE);
#else
    //Set up Timer A0
    TIMER_A_initCompare(TIMER_A0_BASE,
                        TIMER_A_CAPTURECOMPARE_REGISTER_0,
                        TIMER_A_CAPTURECOMPARE_INTERRUPT_ENABLE,
                        TIMER_A_OUTPUTMODE_RESET_SET,
                        0);
    //Start timer A0
    TIMER_A_startUpMode(TIMER_A0_BASE,
                        TIMER_A_CLOCKSOURCE_SMCLK,
                        TIMER_A_CLOCKSOURCE_DIVIDER_12,
                        2000,
                        TIMER_A_TAIE_INTERRUPT_DISABLE,
                        TIMER_A_CAPTURECOMPARE_INTERRUPT_ENABLE,
                        TIMER_A_DO_CLEAR);
#endif

    TIMER_A_enableInterrupt(TIMER_A0_BASE);

}

/*
* *************************************************************************
* MODULE    :POW_ContinueTimer
* ABSTRACT  :^C}ĊJ
* FUNCTION  :TimerA=2ms
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_ContinueTimer(void)
{
#if 1
    TIMER_A_configureUpMode(TIMER_A0_BASE,
    	TIMER_A_CLOCKSOURCE_SMCLK,
    	TIMER_A_CLOCKSOURCE_DIVIDER_12,
#ifdef POWER_TIMERUSE_10MS
        10000,
#else
        2000,
#endif
        TIMER_A_TAIE_INTERRUPT_DISABLE,
        TIMER_A_CAPTURECOMPARE_INTERRUPT_ENABLE,
        TIMER_A_DO_CLEAR
        );
    TIMER_A_startCounter(TIMER_A0_BASE,
        TIMER_A_UP_MODE);

#endif
}

/*
* *************************************************************************
* MODULE    :POW_EnterPowerSave
* ABSTRACT  :p[Z[t
* FUNCTION  :ECGf[^擾̊ԊuAMCUX[vB
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_EnterPowerSave(void)
{
#ifdef POWER_POWERSAVE_ENABLE
    //Stop WDT
    WDT_A_hold(WDT_A_BASE);

    //ACLKRTCp̂ߕύXłȂ
    //SMCLKA/Dϊp̂ߕύXłȂ

    //SVS Low side is turned off
    PMM_disableSvsL(PMM_BASE);

    //Monitor low side is turned off
    PMM_disableSvmL(PMM_BASE);

    //Monitor high side is turned off
    PMM_disableSvmH(PMM_BASE);

    //SVS High side is turned on
    PMM_enableSvsH(PMM_BASE);

    //Enable POR on SVS Event
    PMM_enableSvsHReset(PMM_BASE);

    //SVS high side Full perf mode,
    PMM_SvsHEnabledInLPMFullPerf(PMM_BASE);

    //stays on in LPM0,enhanced protect
    //Wait until high side, low side settled
    while ( 0 == PMM_getInterruptStatus(PMM_BASE,
                                        SVSMLDLYIFG + SVSMHDLYIFG )
            ) ;

    PMM_clearPMMIFGS(PMM_BASE);

    //Enter LPM0, enable interrupts
    __bis_SR_register(LPM0_bits + GIE);

    //For debugger
    __no_operation();
#endif
}

/*
* *************************************************************************
* MODULE    :POW_EnterPowerSaveDeep
* ABSTRACT  :p[Z[t
* FUNCTION  :Off modeAMCUX[vB
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_EnterPowerSaveDeep(void)
{
    //Set interrupt before sleep
    POW_BeforeEnterPowerSaveDeep();

#ifdef POWER_DEEPPOWERSAVE_ENABLE
    //Stop WDT
    WDT_A_hold(WDT_A_BASE);

    //ACLKRTCp̂ߕύXłȂ
    //SMCLKA/Dϊp̂ߕύXłȂ

    //SVS Low side is turned off
    PMM_disableSvsL(PMM_BASE);

    //Monitor low side is turned off
    PMM_disableSvmL(PMM_BASE);

    //Monitor high side is turned off
    PMM_disableSvmH(PMM_BASE);

    //SVS High side is turned on
    PMM_enableSvsH(PMM_BASE);

    //Enable POR on SVS Event
    PMM_enableSvsHReset(PMM_BASE);

    //SVS high side Full perf mode,
    PMM_SvsHEnabledInLPMFullPerf(PMM_BASE);

    //stays on in LPM3,enhanced protect
    //Wait until high side, low side settled
    while ( 0 == PMM_getInterruptStatus(PMM_BASE,
                                        SVSMLDLYIFG + SVSMHDLYIFG )
            ) ;

    PMM_clearPMMIFGS(PMM_BASE);

    //Enter LPM3, enable interrupts
    __bis_SR_register(LPM3_bits + GIE);

    //For debugger
    __no_operation();
#endif
}

/*
* *************************************************************************
* MODULE    :POW_BeforeEnterPowerSaveDeep
* ABSTRACT  :p[Z[t
* FUNCTION  :Off modeAMCUX[vB
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void POW_BeforeEnterPowerSaveDeep(void)
{
#ifdef POWER_DEEPPOWERSAVE_ENABLE
	//Set mode SW as interrupt
    //Enable P1.7 internal resistance as pull-Up resistance
    GPIO_setAsInputPinWithPullUpresistor(
            GPIO_PORT_P1,
            GPIO_PIN7
            );
    //P1.7 interrupt enabled
    GPIO_enableInterrupt(
            GPIO_PORT_P1,
            GPIO_PIN7
            );

    //P1.7 Hi/Lo edge
    GPIO_interruptEdgeSelect(
            GPIO_PORT_P1,
            GPIO_PIN7,
            GPIO_HIGH_TO_LOW_TRANSITION
            );


    //P1.7 IFG cleared
    GPIO_clearInterruptFlag(
            GPIO_PORT_P1,
            GPIO_PIN7
            );
#endif
}

/*
* *************************************************************************
* MODULE    :POW_ExitPowerSave
* ABSTRACT  :EFCNAbv
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void POW_ExitPowerSave(void)
{
#ifdef POWER_POWERSAVE_ENABLE

  //  __bic_SR_register_on_exit(LPM3_bits);   // Exit LPM0-3
  //  __no_operation();                       // Required for debugger

#endif
}
/*
* *************************************************************************
* MODULE    :POWER_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  :bto M mid bZ[WID
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void POWER_sendmessage(UINT16 bto, UINT16 mid)
{
	FRM_MSG msg = {0};

	msg.blk_from	= BLOCK_ID_POWSYS;
	msg.blk_to		= bto;
	msg.id			= mid;
	FRM_frm_sndmsg(msg);
}
//******************************************************************************
//
//This is the PORT1_VECTOR interrupt vector service routine
//
//******************************************************************************
#pragma vector=PORT1_VECTOR
__interrupt void Port_1(void)
{
#ifdef POWER_DEEPPOWERSAVE_ENABLE
        //P1.7 IFG cleared
        GPIO_clearInterruptFlag(
                GPIO_PORT_P1,
                GPIO_PIN7
                );
        //P1.7 interrupt disabled
        GPIO_disableInterrupt(
                GPIO_PORT_P1,
                GPIO_PIN7
                );
        //Integmang֑M
        POWER_sendmessage(BLOCK_ID_INTEG,MSGID_INTEG_WAKEUP);

        __bic_SR_register_on_exit(LPM3_bits);   // Exit LPM0-3
        __no_operation();                       // Required for debugger

#endif
}

#pragma vector=UNMI_VECTOR
__interrupt void NMI_ISR(void)
{
	uint16_t status;
        do {
                // If it still can't clear the oscillator fault flags after the timeout,
                // trap and wait here.
                status = UCS_clearAllOscFlagsWithTimeout(UCS_BASE,
                                                         1000
                                                         );
        } while (status != 0);
}
