/*
 * Recode.c
 *
 *  Created on: 2013/12/18
 *      Author: seagbri
 */
#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Recode.h>

uint8_t RECODE_STS;

void RECODE_Start(void);
void RECODE_Stop(void);
void RECODE_Timeout(void);
void RECODE_sendmessage(UINT16 bto, UINT16 mid, UINT16 cmd);

/*
* *************************************************************************
* MODULE    :RECODE_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_root(FRM_MSG *msg)
{
	switch(msg->id){
				//Jn
		case	MSGID_RECODE_START:
				RECODE_Start();
				break;
				//^CAEg
		case	MSGID_RECODE_TIMEOUT:
				RECODE_Timeout();
				break;
				//~
		case	MSGID_RECODE_STOP:
				RECODE_Stop();
				break;
				//f[^擾
		case	MSGID_RECODE_DATAGETCOMPLETE:
				RECODE_Stop();
				break;
		default:
			break;
	}
}

/*
* *************************************************************************
* MODULE    :RECODE_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_Initial(void)
{
	RECODE_STS = RECODE_STS_POWEROFF;
}
/*
* *************************************************************************
* MODULE    :RECODE_Start
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_Start(void)
{
	//SD-cardsdI
	GPIO_setOutputHighOnPin(GPIO_PORT_P8,GPIO_PIN7);
	//500ms^C}Zbg
	SYS_SetTimer(TIMID_RECODE_500MS,SYSAPI_TIMER_MIDACCURACY);
	//ԂXV
	RECODE_STS = RECODE_STS_WAITPOWERON;
}

/*
* *************************************************************************
* MODULE    :RECODE_Timeout
* ABSTRACT  :^CIEg
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_Timeout(void)
{
	//ԂXV
	RECODE_STS = RECODE_STS_POWERON;
	//SD-cards
	//RTC玞Ԃ
	//t@C쐬
	//ECGf[^擾Jn
	//LED_
}

/*
* *************************************************************************
* MODULE    :RECODE_Stop
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_Stop(void)
{
	//ԂXV
	if(	RECODE_STS != RECODE_STS_POWERON)
	{
		//500ms^C}NA
		SYS_ClearTimer(TIMID_RECODE_500MS,SYSAPI_TIMER_MIDACCURACY);
	}
	RECODE_STS = RECODE_STS_POWEROFF;
	//t@CN[X
	//SD-cardsdIt
	//LED
}

/*
* *************************************************************************
* MODULE    :RECODE_sendmessage
* ABSTRACT  :MessageM
* FUNCTION  :
* ARGUMENT  : bto M mid bZ[WIDAcmd@R}h
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void RECODE_sendmessage(UINT16 bto, UINT16 mid, UINT16 cmd)
{
	FRM_MSG msg ={0};

	msg.blk_from	= BLOCK_ID_RECODE;
	msg.blk_to		= bto;
	msg.id			= mid;
	msg.cmd			= cmd;
	FRM_frm_sndmsg(msg);
}
