/*
 * BtDrv.h
 *
 *  Created on: 2014/02/17
 *      Author: seagbri
 */

#ifndef BTDRV_H_
#define BTDRV_H_

/** ʐMhCo */
typedef enum {
	BTDRV_COMMSTS_STOP,										/** ~ */
	BTDRV_COMMSTS_IDLE,										/** ACh */
	BTDRV_COMMSTS_SEND,										/** M */
	BTDRV_COMMSTS_MAX										/** ʐMhCoԍől */
}BTDRV_COMMSTS;

/**ʐMx` */
#define DBTC_BTD_BAUD1152		(uint8_t)(0)				/** ʐMxi115200bpsj */
#define DBTC_BTD_BAUD2304		(uint8_t)(1)				/** ʐMxi230400bpsj */
#define DBTC_BTD_BAUD4608		(uint8_t)(2)				/** ʐMxi460800bpsj */

/** RTS|[g` */
#define BTDRV_RTS_PORT			GPIO_PORT_P4
#define BTDRV_RTS_PIN			GPIO_PIN7
#define BTDRV_CTS_PORT			GPIO_PORT_P8
#define BTDRV_CTS_PIN			GPIO_PIN1
#define BTDRV_UART_PORT			GPIO_PORT_P8
#define BTDRV_UART_SEND_PIN		GPIO_PIN2
#define BTDRV_UART_RECEIVE_PIN	GPIO_PIN3

/** f[^` */
#define BTDRV_RCVRES_COMMFORMAT_N			"\n"
#define BTDRV_RCVRES_COMMFORMAT_R			"\r"
#define BTDRV_RCVRES_COMMFORMAT_NUM			(uint8_t)(2)	/** Mf[^TCY */
#define BTDRV_RCVRES_SSPFORMAT_NUM			(uint8_t)(20)	/** SPPMf[^TCY */

/** f[^tH[}bg*/
#define BTDRV_RCVRES_FORMAT_UNKNOWN			(uint8_t)(0)	/** Unknown */
#define BTDRV_RCVRES_FORMAT_COMM			(uint8_t)(1)	/** Command */
#define BTDRV_RCVRES_FORMAT_SPP				(uint8_t)(2)	/** SPP */

/** Mobt@ */
#define BTDRV_SENDDATA_SIZE			(uint8_t)(44)			/** Mf[^TCY */
#define BTDRV_SSPSENDDATA_SIZE		(uint16_t)(1200)		/** Mf[^TCY */
#define BTDRV_ROWRECVDATA_SIZE		(uint8_t)(170)			/** HOMf[^TCY */
#define BTDRV_DATANUM				(uint8_t)(3)			/** f[^ */

/** [h */
#define BTDRV_MODE_SPP				(uint8_t)(0)			/** SSP Mode */
#define BTDRV_MODE_CMD				(uint8_t)(1)			/** Command Mode */


/** Mʒm_M */
#define BTDRV_SNDRCVSTS_OK			(uint8_t)(0x01)			/** M */
#define BTDRV_SNDRCVSTS_ERR_RTS		(uint8_t)(0x10)			/** RTSt[G[ */
#define BTDRV_SNDRCVSTS_ERR_OVER	(uint8_t)(0x11)			/** Mobt@I[o[t[ */


/** ߂l */
typedef int8_t						BTDRV_RET;
#define BTDRV_RET_OK				(int8_t)(1)			/** 폈 */
#define BTDRV_RET_WORK				(int8_t)(2)			/**  */
#define BTDRV_RET_FULL				(int8_t)(3)			/** t */

#define BTDRV_RET_NG				(int8_t)(-1)		/** s */
#define BTDRV_RET_PARAM_ERR			(int8_t)(-2)		/** p[^s */

/** ^Ul */
typedef int8_t						BTDRV_BOOL;
#define BTDRV_TRUE					(int8_t)(1)			/** ^ */
#define BTDRV_FALSE					(int8_t)(0)			/** U */

/** oE_TCY */
#define BTDRV_DUMMY_2				(uint8_t)(2)			/** TCY2 */
#define BTDRV_DUMMY_3				(uint8_t)(3)			/** TCY3 */

/** RTSMmF */
#define BTDRV_RTS_NUM				(uint8_t)(6)			/**  3(10ms*6=60ms) */

/*-----------------------------------------------------------------------------
 * Struct
 */

/** Mf[^ */
typedef struct {
	uint8_t				ucData[BTDRV_DATANUM][BTDRV_SENDDATA_SIZE];	/** Mf[^i[̈ */
	uint8_t				ucDataSize[BTDRV_DATANUM];					/** Mf[^TCY */
	uint8_t				ucDataCnt;									/** Mf[^JE^ */
	uint8_t				ucDataNum;									/** Mf[^ */
	uint8_t				ucWriteIndex;								/** Cg|C^ */
	uint8_t				ucReadIndex;								/** [h|C^ */
}BTDRV_COMMSEND_INFO;

/** Mf[^ */
typedef struct {
	uint8_t*			ucData[BTDRV_DATANUM];						/** Mf[^AhX */
	uint16_t			ucDataSize[BTDRV_DATANUM];					/** Mf[^TCY */
	uint16_t			ucDataCnt;									/** Mf[^JE^ */
	uint8_t				ucDataNum;									/** Mf[^ */
	uint8_t				ucWriteIndex;								/** Cg|C^ */
	uint8_t				ucReadIndex;								/** [h|C^ */
}BTDRV_SPPSEND_INFO;

/** Mf[^ */
typedef struct {
	uint8_t				ucData[BTDRV_ROWRECVDATA_SIZE];				/** Mf[^i[̈ */
	uint8_t				ucDataSize;									/** Mf[^TCY */
	uint8_t				ucEventFlg;									/** CxgtO */
	uint8_t				ucEventSize;								/** Cxgf[^TCY*/
	uint8_t				ucMode;										/** ʐM[h */
}BTDRV_RECV_INFO;


/** UARTǗe[u */
typedef struct {
	BTDRV_COMMSTS		ucSts;										/** ʐMhCo */
	uint8_t				ucMode;										/** ʐM[h */
	uint8_t				TryCnt;										/** gC */
	uint8_t				dummy;										/** oE_ */
	BTDRV_COMMSEND_INFO	tCommSendInfo;								/** Mf[^(command) */
	BTDRV_SPPSEND_INFO	tSppSendInfo;								/** Mf[^ (Spp)*/
	BTDRV_RECV_INFO		tRecvInfo;									/** Mf[^ */
}BTDRV_UARTCTRL;

extern void BtDrvD_initialize(void);
extern int8_t BtDrvD_start(uint8_t baudrate);
extern void BtDrvD_stop(void);
extern void BtDrvD_Com_initRam(void);
extern void BtDrvD_timeoutRts(void);
extern BTDRV_UARTCTRL* BtDrvD_Com_getMng(void);
extern uint8_t BtDrvD_Com_getCOMMNextData(void);
extern uint8_t BtDrvD_Com_Sppstock(uint8_t *pData, uint16_t size);
extern uint8_t BtDrvD_Com_Commstock(uint8_t *pData, uint16_t size);
extern uint8_t BtDrvD_Com_getSSPNextData(void);
extern int8_t BtDrvD_Com_retryRts(void);
extern void BtDrvD_Com_sendmessage(uint16_t bfrom,uint16_t bto, uint16_t mid);
extern void BtDrvD_RegAccess_send(uint8_t data);
extern uint8_t BtDrvD_RegAccess_recv(void);
extern uint8_t BtDrvD_Com_Sppsend(uint8_t *pData, uint16_t size);
extern uint8_t BtDrvD_Com_Commsend(uint8_t *pData, uint16_t size);
extern uint8_t BtDrvD_Com_Commsend(uint8_t *pData, uint16_t size);
#endif /* BTDRV_H_ */
