/*
 * HostDrvD.h
 *
 *  Created on: 2014/02/27
 *      Author: seagbri
 */

#ifndef HOSTDRVD_H_
#define HOSTDRVD_H_

/** ʐMhCo */
typedef enum {
	HOSTDRV_COMMSTS_STOP,										/** ~ */
	HOSTDRV_COMMSTS_IDLE,										/** ACh */
	HOSTDRV_COMMSTS_SEND,										/** M */
	HOSTDRV_COMMSTS_MAX											/** ʐMhCoԍől */
}HOSTDRV_COMMSTS;

/**ʐMx` */
#define DBTC_HOSTD_BAUD1152		(uint8_t)(0)				/** ʐMxi115200bpsj */
#define DBTC_HOSTD_BAUD2304		(uint8_t)(1)				/** ʐMxi230400bpsj */
#define DBTC_HOSTD_BAUD4608		(uint8_t)(2)				/** ʐMxi460800bpsj */

/** |[g` */
#define HOSTDRV_UART_PORT			GPIO_PORT_P2
#define HOSTDRV_UART_SEND_PIN		GPIO_PIN4
#define HOSTDRV_UART_RECEIVE_PIN	GPIO_PIN5

/** Mʒm_M */
#define HOSTDRV_SNDRCVSTS_OK			(uint8_t)(0x01)			/** M */
#define HOSTDRV_SNDRCVSTS_ERR_OVER		(uint8_t)(0x11)			/** Mobt@I[o[t[ */


/** ߂l */
typedef int8_t						BTDRV_RET;
#define HOSTDRV_RET_OK				(int8_t)(1)			/** 폈 */
#define HOSTDRV_RET_WORK			(int8_t)(2)			/**  */
#define HOSTDRV_RET_FULL			(int8_t)(3)			/** t */

#define HOSTDRV_RET_NG				(int8_t)(-1)		/** s */
#define HOSTDRV_RET_PARAM_ERR		(int8_t)(-2)		/** p[^s */

/** ^Ul */
typedef int8_t						HOSTDRV_BOOL;
#define HOSTDRV_TRUE				(int8_t)(1)			/** ^ */
#define HOSTDRV_FALSE				(int8_t)(0)			/** U */


/** Mobt@ */
#define HOSTDRV_DATANUM				(uint8_t)(3)					/** f[^ */
#define HOSTIF_DATA_SIZE			(uint8_t)(40)					/**   */
#define HOSTIF_MESSAGEDATA_SIZE		(uint8_t)(HOSTIF_DATA_SIZE + 4)	/** Mf[^TCY */

/** Head` */
#define HOSTIF_DATFRM_HEAD_HBM2			(uint8_t)(0x01)			/** 01:HBM2 */
#define HOSTIF_DATFRM_HEAD_PC			(uint8_t)(0x20)			/** 20:PC */



/*-----------------------------------------------------------------------------
 * Struct
 */

/** HostIF Data */
typedef struct {
	uint8_t				from;						/** M */
	uint8_t				to;							/** M */
	uint8_t				kind;						/** f[^ */
	uint8_t				size;						/** f[^ */
	uint8_t				data[HOSTIF_DATA_SIZE];		/** f[^ */
} T_HOSTIF_FORMAT_MNGTBL;

/** Mf[^ */
typedef struct {
	uint8_t				ucData[HOSTDRV_DATANUM][HOSTIF_MESSAGEDATA_SIZE];	/** Mf[^i[̈ */
	uint8_t				ucDataSize[HOSTDRV_DATANUM];					/** Mf[^TCY */
	uint8_t				ucDataCnt;									/** Mf[^JE^ */
	uint8_t				ucDataNum;									/** Mf[^ */
	uint8_t				ucWriteIndex;								/** Cg|C^ */
	uint8_t				ucReadIndex;								/** [h|C^ */
}HOSTDRV_SEND_INFO;

/** Mf[^ */
typedef struct {
	uint8_t				ucData[HOSTIF_MESSAGEDATA_SIZE];			/** Mf[^i[̈ */
	uint8_t				ucDataSize;									/** Mf[^TCY */
	uint8_t				ucEventFlg;									/** CxgtO */
	uint8_t				ucEventSize;								/** Cxgf[^TCY*/
	uint8_t				ucMode;										/** ʐM[h */
}HOSTDRV_RECV_INFO;


/** UARTǗe[u */
typedef struct {
	HOSTDRV_COMMSTS		ucSts;										/** ʐMhCo */
	uint8_t				ucMode;										/** ʐM[h */
	uint8_t				TryCnt;										/** gC */
	uint8_t				dummy;										/** oE_ */
	HOSTDRV_SEND_INFO	tSendInfo;									/** Mf[^ */
	HOSTDRV_RECV_INFO	tRecvInfo;									/** Mf[^ */
}HOSTDRV_UARTCTRL;


extern void HostDrvD_initialize(void);
extern int8_t HostDrvD_start(uint8_t baudrate);
extern void HostDrvD_stop(void);
extern void HostDrvD_Com_initRam(void);
extern uint8_t HostDrvD_Com_Send(uint8_t *pData, uint16_t size);
extern uint8_t HostDrvD_Com_Stock(uint8_t *pData, uint16_t size);
extern uint8_t HostDrvD_Com_getNextData(void);
extern void HostDrvD_Com_sendmessage(uint16_t bfrom,uint16_t bto, uint16_t mid);
extern HOSTDRV_UARTCTRL* HostDrvD_Com_getMng(void);


#endif /* HOSTDRVD_H_ */
