/*
 * Power.h
 *
 *  Created on: 2013/12/19
 *      Author: seagbri
 */

#ifndef POWER_H_
#define POWER_H_

#define MCLK_FREQUENCY  12000000	//12Mhz

/* Desired use DCO */
#define POWER_USEDCO_ENABLE
/* Desired use powersave */
#define POWER_POWERSAVE_ENABLE
#define POWER_DEEPPOWERSAVE_ENABLE

/* Desired system timer  */
#define POWER_TIMERUSE_10MS		1





/* Define Power save */
#define POWER_SLEEP		0
#define POWER_WAKEUP	1

//*****************************************************************************
//
//Desired Timeout for XT1 initialization
//
//*****************************************************************************
#define UCS_XT1_TIMEOUT 50000

//*****************************************************************************
//
//Desired Timeout for XT2 initialization
//
//*****************************************************************************
#define UCS_XT2_TIMEOUT 50000

//*****************************************************************************
//
//XT1 Crystal Frequency being used
//
//*****************************************************************************
#define UCS_XT1_CRYSTAL_FREQUENCY    32768

//*****************************************************************************
//
//XT2 Crystal Frequency being used
//
//*****************************************************************************
#define UCS_XT2_CRYSTAL_FREQUENCY   12000000

extern void POW_Initialize(void);
extern void POW_initRtc(void);
extern void POW_initPort(void);
extern void POW_initTimer(void);
extern void POW_initClocks(DWORD mclkFreq);
extern void POW_EnterPowerSave(void);
extern void POW_ExitPowerSave(void);
extern void POW_ContinueTimer(void);
extern void POW_EnterPowerSaveDeep(void);
#endif /* POWER_H_ */
