/* --COPYRIGHT--,BSD
 * Copyright (c) 2013, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#if 1
#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Power.h>
#include <Integmang.h>
#else
#include "inc/hw_memmap.h"
#include "wdt_a.h"
#endif


uint16_t TTstatus =0;

//******************************************************************************
//!
//!   Empty Project that includes driverlib
//!
//******************************************************************************
void main(void)
{
	/* MCU */
		POW_Initialize();
	/* FRMs */
		FrmMain();

}

#if 1
// Timer0 A0 interrupt service routine
#pragma vector=TIMER0_A0_VECTOR
__interrupt void TIMER0_A0_ISR(void)
{
	UINT8	ret = POWER_SLEEP;

	POW_ContinueTimer();
#ifdef POWER_TIMERUSE_10MS
	ret = SYSAPI_Timer10mhdr();
#else
	ret = SYSAPI_Timer2mhdr();
#endif
	if(TTstatus <= 500)
	{
		TTstatus ++;
		GPIO_setOutputLowOnPin(GPIO_PORT_P3,GPIO_PIN1|GPIO_PIN2);
	}
	else if(TTstatus <= 1000)
	{
		TTstatus ++;
		GPIO_setOutputHighOnPin(GPIO_PORT_P3,GPIO_PIN1|GPIO_PIN2);
	}
	else
	{
		TTstatus =0;

	}
#ifdef POWER_POWERSAVE_ENABLE
	if(ret == POWER_WAKEUP)
	{
		POW_ExitPowerSave();
		__bic_SR_register_on_exit(LPM0_bits);   // Exit LPM0-0
		__no_operation();                       // Required for debugger
	}
#endif
}
#endif

