#include <msp430f5529.h>
#include "HAL_Dogs102x6.h"
#include "HAL_Buttons.h"

void lcd_init(void);
void show_init(void);
void time0_init(void);
void ADC_init(void);
void Port_init(void);

uint32_t TimeFullnum=0;//ʱÿһ0.1S
uint32_t Pulsenum=0;

uint32_t com1,com2=5000,flag=0,flag1=0;
uint32_t power;

void main( void )
{
	WDTCTL = WDTPW + WDTHOLD;

	time0_init();
	lcd_init();

    Buttons_init(BUTTON_ALL);                    //ʼ
    Buttons_interruptEnable(BUTTON_ALL);         //ʹаж
    show_init();
	ADC_init();
    P1DIR |= (0x01<<0);
    P8DIR |= (0x01<<2);

   while(1)
    {

	   if(buttonsPressed&BUTTON_S2)
	   {
		   ADC12IE = 0x02;                           // Enable ADC12IFG.1
		   TA1CCTL0 = CCIE;    // CCR0 interrupt enabled
		   flag=1;
		   buttonsPressed = 0;                          //ֵ
	   }

	    ADC12CTL0 |= ADC12SC;

			  ADC12CTL0 |= ADC12SC;
			  __delay_cycles(5000);
				   ADC12IE = ~0x02;                           // Enable ADC12IFG.1
				   TA1CCTL0 = ~CCIE;                          // CCR0 interrupt enabled
		  }

    }





void ADC_init(void)
{

	  ADC12CTL0 = ADC12ON+ADC12SHT0_8+ADC12MSC;

	  ADC12CTL1 = ADC12SHP+ADC12CONSEQ_1;       // Use sampling timer,  sequence

	  ADC12MCTL0 = ADC12SREF_0+ADC12INCH_6;                 // ref+=AVcc, channel = A6
	  ADC12MCTL1 = ADC12SREF_0+ADC12INCH_7+ADC12EOS;       // ref+=AVcc, channel = A7

	 							// Enable A/D channel inputs
      P6SEL |=BIT6;
      P6SEL |=BIT7;

//	  ADC12IE = 0x02;                           // Enable ADC12IFG.1
	  //__delay_cycles(75);                       // 75us delay to allow Ref to settle
	  ADC12CTL0 |= ADC12ENC;                    // Enable conversions
}


void lcd_init(void)
{
	//Board_init();                                              // GPIO initialization
	Dogs102x6_init();                                          // initialize LCD
	Dogs102x6_backlightInit();
	 Dogs102x6_setBacklight(11);          //
	 Dogs102x6_setContrast(11);             //óʼԱȶֵ
	Dogs102x6_clearScreen();                                   // clear screen of LCD
	//Dogs102x6_backlightInit();                                 // initialize the backlight of LCD
	//Dogs102x6_setBacklight(20);                                // set up the backlight of LCD
	__enable_interrupt();//enable globle interrupt
}
void show_init()
{
    buttonsPressed = 0;                          //ֵ
    Dogs102x6_stringDraw(1, 0, "   Welcome to    ", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_stringDraw(2, 0, " MSP-EXP430F5529 ", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_stringDraw(5, 0, "Press S1|S2 Enter", DOGS102x6_DRAW_INVERT);
    while (!buttonsPressed)                    //ȴ
    Dogs102x6_clearScreen();
	Dogs102x6_stringDraw(0,0," ==Pulse  Text== ", DOGS102x6_DRAW_NORMAL);
}
void time0_init(void)
{
	//TA0CCTL1=CCIE;		//Ƚ1CCIFGλж
	TA0CCR1=3276;			//ҪȽϵֵ3276/32768=0.1S
	TA0CTL|=TACLR+TAIE;		//жϲ
	TA0CTL|=TASSEL_1+MC_0+TAIE;//ѡSCLK32.768KHZΪʱӣرնʱ

}

void Port_init(void)
{
	P1DIR&=~BIT0;			//P2Ϊ롣ΪҪⲿж
	P1IFG&=~BIT0;			//P2ڵжϱ־
	//P2IE|=BIT0;			//P2.0ж
	P1IES|=BIT0;		//P2.0Ϊ½ش
	P1IN|=BIT0; 		//P2.0ߣ˿رպʱͲ½أжϣ
	P1OUT|=BIT0;
	P1REN|=BIT0;		//½ش裨ҪǣҾ-_ش
}


#pragma vector=PORT1_VECTOR     //жϷ
__interrupt void IO_interrupt(void)
{
	P1IFG&=0x00;			//־λ
}
//ʱ0жϺ
#pragma vector=TIMER0_A1_VECTOR
__interrupt void TIMER1_A0_ISR(void)
{
	TimeFullnum++;
}


#pragma vector=ADC12_VECTOR
__interrupt void ADC12ISR (void)
{
    float factor=0.80566;//3300/4095
    switch(__even_in_range(ADC12IV,34))
  {
  case  0: break;                           // Vector  0:  No interrupt
  case  2: break;                           // Vector  2:  ADC overflow
  case  4: break;                           // Vector  4:  ADC timing overflow
  case  6: break;                           // Vector  6:  ADC12IFG0
  case  8:                          	    // Vector  8:  ADC12IFG1
	  com1=ADC12MEM0;
	  com1=com1*factor/2;
	  com2=ADC12MEM1;
	  com2=com2*factor*2;// Move results, IFG is cleared
	  	    		      // Move results, IFG is cleared

  	    break;
  case 10: break;                           // Vector 10:  ADC12IFG2
  case 12:break;                            // Vector 12:  ADC12IFG3
  case 14: break;                           // Vector 14:  ADC12IFG4
  case 16: break;                           // Vector 16:  ADC12IFG5
  case 18: break;                           // Vector 18:  ADC12IFG6
  case 20: break;                           // Vector 20:  ADC12IFG7
  case 22: break;                           // Vector 22:  ADC12IFG8
  case 24: break;                           // Vector 24:  ADC12IFG9
  case 26: break;                           // Vector 26:  ADC12IFG10
  case 28: break;                           // Vector 28:  ADC12IFG11
  case 30: break;                           // Vector 30:  ADC12IFG12
  case 32: break;                           // Vector 32:  ADC12IFG13
  case 34: break;                           // Vector 34:  ADC12IFG14
  default: break;
  }
}



