

#include"msp430x44x.h"
#define uint unsigned int 
#define uchar unsigned char
int index=0;
long int cur_sample=0,prev_sample=0;  
uchar *flash_ptr; 
uchar sb,flag;
int delta;


uchar flag=0;
uchar code ;
int index_adjust[8]={-1,-1,-1,-1,2,4,6,8};
int step_table[89]={7,8,9,10,11,12,13,14,16,17,19,21,23,25,28,31,34,37,41,45,50,55,60,66,73,80,88,97,107,118,130,143,157,190,209,230,253,279,307,337,371,408,449,494,544,598,658,724,796,876,963,1060,1166,1282,1411,1552,1707,1878,2066,2272,2499,2749,3024,3327,3660,4026,4428,4871,5358,5894,6484,7132,7845,8630,9493,10442,11487,12635,13899,15289,16818,18500,20350,22385,24623,27086,29794,32727};


void delay10ms()                                        
{          
unsigned char i,j,k;          
for(i=5;i>0;i--)          
for(j=4;j>0;j--)           
for(k=248;k>0;k--); 
}

void mclk()                                            
{
SCFI0|=FN_4;           
SCFQCTL=121;                                              
FLL_CTL0=DCOPLUS+OSCCAP_1;
}

void ADC12()              
{                              
ADC12CTL0=ADC12ON+ SHT0_0+REFON+ REF2_5V+MSC;                   
ADC12CTL1=SHP+ADC12SSEL_2+CONSEQ_2;                               
ADC12CTL0 |= ENC + ADC12SC;                                                      
}   
  
void timer_A()                                                
{
TACTL=TASSEL_2+TACLR;
 CCTL0=CCIE;
CCR0=1400;                                                      
TACTL|=MC_1;                                                 
}

void compress(uint address)                                //ѹ
{
cur_sample=ADC12MEM0;         //cur_sample  16λ
delta=cur_sample-prev_sample;     // delta 16λ
if(delta<0)delta=-delta,sb=8;    //sb 8λ
else sb=0;                                           
code=4*delta/step_table[index];  //code 8λ
if (code>7)code=7;                          
index+=index_adjust[code];           //index 0~88
if(index<0)index=0;                          
else if(index>88)index=88;
prev_sample=cur_sample;             // prev_sample 16λ
flash_ptr=(uchar*)address;                                                       
while(FCTL3&BUSY);                                                                  
FCTL3=FWKEY;                                                                           
FCTL1=FWKEY+WRT;   
code=(code|sb);
code=(code|0xf0);
*flash_ptr=code;	 
}

void compress2(uint address)                            
{
cur_sample=ADC12MEM0;         
delta=cur_sample-prev_sample;     
if(delta<0)delta=-delta,sb=8;
else sb=0;                                           
code=4*delta/step_table[index];  
if (code>7)code=7;                           
index+=index_adjust[code];           
if(index<0)index=0;                          
else if(index>88)index=88;
prev_sample=cur_sample;
flash_ptr=(uchar*)address;                                                       
while(FCTL3&BUSY);                                                                  
FCTL3=FWKEY;                                                                           
FCTL1=FWKEY+WRT;
code=(code|sb);
code=((4<<code)|0x0f);
*flash_ptr=code;	 
}

void unpack(uint address)                                          
{                                                           
flash_ptr=(uchar *)address;                
code=*flash_ptr; 
code=(code&0x0f);  
if ( ( code&8 )!=0)sb=1;
else sb=0;
code&=7;                                          //codeݺͷ
delta=(step_table[index]*code)/4+step_table[index]/8;//ӵһΪ˼
if(sb==1)delta=-delta;  
cur_sample+=delta;                                //ǰĲ        
if(cur_sample>32767)cur_sample=32768;
else if(cur_sample<-32767)cur_sample=-32768;
P1OUT=cur_sample;
index+=index_adjust[code];
if(index<0) index=0;
if(index>88) index=88;
}

void unpack2(uint address)                                          //ѹ 
{                                                           
flash_ptr=(uchar *)address;                
code=*flash_ptr; 
code=(code>>4);  
if ( ( code&8 )!=0) sb=1;
else sb=0;
code&=7;                                          //codeݺͷ
delta=(step_table[index]*code)/4+step_table[index]/8; //ӵһΪ˼
if(sb==1)delta=-delta;  
cur_sample+=delta;                       //ǰĲ        
if(cur_sample>32767)cur_sample=32768;
else if(cur_sample<-32767)cur_sample=-32768;
P1OUT=cur_sample;
//output_sample(cur_sample);
index+=index_adjust[code];
if(index<0) index=0;
if(index>88) index=88;
}

void flash_erase(uint address)                       
{
FCTL2=FWKEY+FSSEL_1+FN0;                     
uchar *flash_ptr;                                           
flash_ptr=(uchar*)address;                            
while(FCTL3&BUSY);                                      
FCTL3=FWKEY;                                            
FCTL1=FWKEY+ERASE;                                
*flash_ptr=0;                                                
FCTL1=FWKEY;                                              
FCTL3=FWKEY+LOCK;                                  
while(FCTL3&BUSY);                                     
}






void main()
{
WDTCTL = WDTPW + WDTHOLD;


//long int data;                              
uint adc_data,i;
long int readkey;
 

P1DIR=0xff;                                        
P6SEL|BIT0;                                       
mclk();                                                  
ADC12();                                              
timer_A();                                               
_EINT();                                               
for(;;)                                                        
{
adc_data=ADC12MEM0;                      
P1OUT=(adc_data>>4);                        
readkey=P3IN;                                      
if(readkey!=0x03)                                  
{
delay10ms();                                          
readkey=P3IN;                                                            
if(readkey==0x01)                                  
{                                                                   
for(i=0;i<115;i++)                                      
flash_erase(0x1B12+512*i);                     



for(i=0x1B12;i<=0xfdff;i++)                        
{
while(flag==0);                                          
flag=0;                                                       
 compress(i);                 
                                                              
}
for(i=0x1B12;i<=0xfdff;i++)                        
{
while(flag==0);                                          
flag=0;                                                       
 compress2(i);                 
                                                              
}

}
if(readkey==0x02)                                    
{
for(i=0x1912;i<=0xfdff;i++)                         
{
while(flag==0);   
flag=0;                                                        
unpack(i);                              
}
for(i=0x1912;i<=0xfdff;i++)                         
{
while(flag==0);                                             
flag=0;                                                        
unpack2(i);
}
}
}
}
}



#pragma vector=TIMERA0_VECTOR        
__interrupt void time_A_interrupt()
{
flag=1;
}
