//***************************************************************************//
//                                                                           //
//                         MSP-EXP430F5529 LAB CODE                          //
//                                                                           //
//                               lab1 - CLOCK                                //
//                                                                           //
//***************************************************************************//
/*******************************************************************************
 *
 *  Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/
#include <stdint.h>
#include "msp430.h"
#include "HAL_Buttons.h"
#include "HAL_Board.h"
#include "HAL_Dogs102x6.h"
#include "HAL_Menu.h"
#include "HAL_Wheel.h"
#include "lab1.h"


// This image has been created by ImageDog using 'small_sunglasses.png'
static const uint8_t sunglasses[] =
{
    0x30,    // Image width in pixels
    0x06,    // Image height in rows (1 row = 8 pixels)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x01, 0x03, 0x03, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x1e, 0x1f, 0x3f, 0x7f,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x1f, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x03, 0x03, 0x0f, 0x1e, 0x1c, 0x38, 0x30, 0x70, 0xf8, 0xfc, 0x0e, 0x07, 0xf3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0e, 0x1c, 0x3f, 0x7f, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x1f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0,
    0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x20, 0xf0, 0xf8, 0xf8, 0x3c, 0x0e, 0x07, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
// This image has been created by ImageDog using 'lightbulb_outline_inverted_mini.png'
static const uint8_t lightbulb[] =
{
    0x20,    // Image width in pixels
    0x06,    // Image height in rows (1 row = 8 pixels)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x0c, 0x18, 0x10, 0x10, 0x10, 0x30, 0x00,
    0x00, 0x00, 0x30, 0x11, 0x11, 0x11, 0x18, 0x0c, 0x04, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x40, 0xe0, 0x30, 0x9d, 0xcf, 0x7f, 0x1e, 0x00, 0x80, 0xfe, 0x1c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x80, 0x01, 0x03, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x78, 0x09, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x79, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x5f, 0x00, 0x24, 0x25, 0x25,
    0x25, 0x2d, 0x2d, 0x6d, 0x00, 0x09, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x30, 0x38, 0xa8, 0x2c,
    0x2c, 0x2c, 0x2c, 0x28, 0x30, 0x20, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


/**************************************************************************************************
 *еȫֱ
 *ѹֵͲƵǲø
 *
 *
**************************************************************************************************/
uint16_t timeoutCounter;
uint32_t results[10];
uint32_t sum=0,com,acom,flag=0;
uint32_t cap,newdata,olddata,data;
uint32_t num;
uint8_t RTCExitSec = 0;



static const char *const clockMenuText[] = {
    "===SDDZ 12XX====",
          "-.-",
    "1. Start ",
    "2. Contrast ",
    "3. Backlight "

};

// Forward declared functions
void ContrastSetting(void);
void BacklightSetting(void);
void celiang(void);
void display1();
void display2();

/***************************************************************************//**
 * @brief  The menu of lab1.
 * @param  None
 * @return none
 ******************************************************************************/

void lab1(void)
{
	   uint8_t selection = 0;
	    buttonsPressed = 0;
	    Dogs102x6_clearScreen();                         //
	    Dogs102x6_stringDraw(7, 0, "*S1=Enter S2=Esc*", DOGS102x6_DRAW_NORMAL);
	    selection = Menu_active((char **)clockMenuText, 5);   //ʾ˵ز˵ѡ
	    if (buttonsPressed & BUTTON_S2);
	    else
	       switch (selection)
	        {
           	   	case 2: celiang(); break;         //ʱӳ
	            case 3: ContrastSetting(); break;             //Աȶó
	            case 4: BacklightSetting(); break;            //ó
	            default: break;
	        }
}
/***************************************************************************//**
ģ麯
 ******************************************************************************/
void celiang(void)
{

	Dogs102x6_clearScreen();
	Board_ledOff(LED_ALL);
	ADC12CTL0 |= ADC12SC;
	_EINT();

	cap=0;
	acom=0;
	com=0;

	P1DIR |= BIT3;
	P2SEL |= BIT0;           //TA1.1
    while (1)
     {
    	buttonsPressed = 0;
    	Dogs102x6_clearScreen();
    	 while (!(buttonsPressed & BUTTON_S1))
    	{
    		//ADC12IE = 0x01;
     	    Board_ledOn(LED4);

     	    TA1CCTL1=CM_1+SCS+CCIS_0+CAP+CCIE;
     	    TA1CTL=TASSEL_2+MC_2+TACLR+TAIE;

     	    display2();
    	}
    	 buttonsPressed = 0;
    	 Dogs102x6_clearScreen();
    	 __delay_cycles(2000);
    	 Board_ledOff(LED_ALL);


    	 while (!(buttonsPressed & BUTTON_S2))
    	 {
    	    ADC12IE = 0x01;
    	    Board_ledOn(LED6);
    	    display1();
    	 }
    	 Dogs102x6_clearScreen();
    	 __delay_cycles(2000);
    	 Board_ledOff(LED_ALL);
    	 ADC12IE = 0x00;
    	 ADC12CTL0 &= ~ADC12SC;
   }
}
/**************************************************************************************************
 *ֱѹתʾ
 *
 *
 *
**************************************************************************************************/
void display1()
{
	 if(flag==1)
	    {
	               char string[20];
	               string[0]=com/1000+48;
	               string[1]=46;
	               string[2]=com/100%10+48;
	               string[3]=com/10%10+48;
	               string[4]=com%10+48;
	               string[5]='\0';

	               Dogs102x6_stringDraw(1, 0, "*==DC voltage==*", DOGS102x6_DRAW_NORMAL);
	               Dogs102x6_stringDraw(3, 0, "value=", DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(3, 40, string, DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(3, 70, "(V)", DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(7, 0, " *== good job==*", DOGS102x6_DRAW_NORMAL);

	          	   for (timeoutCounter = 0; timeoutCounter < 0x02FF; timeoutCounter++)
	          	        {
	          	            __delay_cycles(1000);
	          	        }
	          	   flag=0;
	   }
}
/**************************************************************************************************
 *ѹתʾ
 *Ƶʲʾ
 *
 *
**************************************************************************************************/
void display2()
{
	               char str1[20],str3[20];

	               cap=40000000/num;

	               str1[0]=acom/1000+48;
	               str1[1]=46;
	               str1[2]=acom/100%10+48;
	               str1[3]=acom/10%10+48;
	               str1[4]=acom%10+48;
	               str1[5]='\0';


	           	   str3[0]=cap/10000000+'0';
	           	   str3[1]=cap/1000000%10+'0';
	           	   str3[2]=cap/100000%10+'0';
	           	   str3[3]=cap/10000%10+'0';
	           	   str3[4]=cap/1000%10+'0';
	           	   str3[5]=cap/100%10+'0';
	           	   str3[6]=cap/10%10+'0';
	           	   str3[7]=46;
	           	   str3[8]=cap%10+'0';
	           	   str3[9]='\0';

	                   Dogs102x6_stringDraw(1, 0, "*==AC voltage==*", DOGS102x6_DRAW_NORMAL);

	          	   Dogs102x6_stringDraw(3, 0, "value=", DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(3, 40, str1, DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(3, 75, "(V)", DOGS102x6_DRAW_NORMAL);




	          	   Dogs102x6_stringDraw(5, 1, "F =", DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(5, 30, str3, DOGS102x6_DRAW_NORMAL);
	          	   Dogs102x6_stringDraw(5, 90, "HZ", DOGS102x6_DRAW_NORMAL);

	          	   Dogs102x6_stringDraw(7, 0, " *== good job==*", DOGS102x6_DRAW_NORMAL);

}


/***************************************************************************//**
 * @brief  Allows the user to adjust the contrast
 * @param  none
 * @return none
 ******************************************************************************/

void ContrastSetting(void)
{
    uint8_t contrast = *((unsigned char *)contrastSetpointAddress);

    buttonsPressed = 0;
    Dogs102x6_clearScreen();
    Dogs102x6_stringDraw(0, 0, " Adjust contrast ", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_stringDraw(1, 0, "by turning wheel.", DOGS102x6_DRAW_NORMAL);

    Dogs102x6_imageDraw(sunglasses, 2, 27);                //ʾ̫ͼ
    __delay_cycles(10000000); //delay for user to read directions

    while (!buttonsPressed)
    {
        contrast = Wheel_getValue() / 130;                 //ֵͨλƲõõĶԱȶֵ
        Dogs102x6_setContrast(contrast);                   //öԱȶ
    }

    WriteFlashSettings(contrast, contrastSetpointAddress); //¶ԱȶֵдFLASHַ   

    buttonsPressed = 0;
    Dogs102x6_clearScreen();
}

/***************************************************************************//**
 * @brief  Allows the user to adjust the backlight brightness
 * @param  none
 * @return none
 ******************************************************************************/

void BacklightSetting(void)
{
    uint8_t brightness = *((unsigned char *)brightnessSetpointAddress);

    buttonsPressed = 0;
    Dogs102x6_clearScreen();
    Dogs102x6_stringDraw(0, 0, "Adjust brightness", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_stringDraw(1, 0, "by turning wheel.", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_imageDraw(lightbulb, 2, 35);                   //ʾͼ

    while (!buttonsPressed)
    {
        brightness = Wheel_getValue() / 340;                 //ֵͨλƲõõı
        if (brightness > 12)
            brightness = 12;                                 //Ϊ12
        Dogs102x6_setBacklight(brightness);                  //ñֵ
    }

    WriteFlashSettings(brightness, brightnessSetpointAddress); //±ֵдFLASHַ

    buttonsPressed = 0;
    Dogs102x6_clearScreen();
}


/***************************************************************************//**
 * @brief  Initializes the RTC calendar.
 * Initial values are January 01, 2010, 12:30:05
 * @param  none
 * @return none
 ******************************************************************************/

void SetupRTC(void)
{
    RTCCTL01 = RTCMODE + RTCBCD + RTCHOLD + RTCTEV_1;

    RTCHOUR = 0x04;
    RTCMIN = 0x30;
    RTCSEC = 0x00;
    RTCDAY = 0x01;
    RTCMON = 0x01;
    RTCYEAR = 0x2011;

    RTCCTL01 &= ~RTCHOLD;

   // RTCPS1CTL = RT1IP_5;                    // Interrupt freq: 2Hz
    //RTCPS0CTL = RT0IP_7;                    // Interrupt freq: 128hz

    RTCCTL0 |= RTCRDYIE + RTCTEVIE;         // Enable interrupt
}

/***************************************************************************//**
 * @brief  RTC Interrupt Service Routine. Handles time events.
 * @param  none
 * @return none
 ******************************************************************************/

#pragma vector=RTC_VECTOR
__interrupt void RTC_ISR(void)
{
    switch (__even_in_range(RTCIV, RTC_RT1PSIFG))
    {
        // Vector RTC_NONE: No Interrupt pending
        case RTC_NONE:
            break;

        // Vector RTC_RTCRDYIFG: RTC ready
        case RTC_RTCRDYIFG:
            if (RTCExitSec == 1)
                __bic_SR_register_on_exit(LPM3_bits);
            break;

        // Vector RTC_RTCTEVIFG: RTC interval timer
        case RTC_RTCTEVIFG:
            break;

        // Vector RTC_RTCAIFG: RTC user alarm
        case RTC_RTCAIFG:
            break;

        // Vector RTC_RT0PSIFG: RTC prescaler 0
        case RTC_RT0PSIFG:
            break;

        // Vector RTC_RT1PSIFG: RTC prescaler 1
        case RTC_RT1PSIFG:
            break;

        // Default case
        default:
            break;
    }
    __no_operation();
}

/***************************************************************************//**
 * @brief  Writes the settings to flash
 * @param  Data to be written, and offset
 * @return none
 ******************************************************************************/

void WriteFlashSettings(uint16_t Data, uint16_t Address)
{
    uint16_t * Flash_ptr;                   // Initialize Flash pointer
    uint16_t Flash_Contents[16];            // Store Contents of Flash before Programming
    uint8_t i;

    Flash_ptr = (uint16_t *)(0x1880);       // Info C

    for (i = 0; i < 16; i++)                // We know that we will only use > 8 variables in Info C
    {
        Flash_Contents[i] = *Flash_ptr;     // Read a word from flash
        if (Flash_ptr == (uint16_t *)Address)
            Flash_Contents[i] = Data;
        *Flash_ptr++;
    }


    Flash_ptr = (uint16_t *)(0x1880);       // Info C
    FCTL3 = FWKEY;                          // Clear Lock bit
    FCTL1 = FWKEY + ERASE;                  // Set Erase bit
    *Flash_ptr = 0;                         // Dummy write to erase Flash seg
    FCTL1 = FWKEY + WRT;                    // Set WRT bit for write operation

    for (i = 0; i < 16; i++)
    {
        *Flash_ptr++ = Flash_Contents[i];   // Write a word to flash
    }

    FCTL1 = FWKEY;                          // Clear WRT bit
    FCTL3 = FWKEY + LOCK;                   // Set LOCK bit
}


/**************************************************************************************************
 *ADC12жϺ
 *
 *
 *
**************************************************************************************************/
#pragma vector=ADC12_VECTOR
__interrupt void ADC12ISR (void)
{
	  switch(__even_in_range(ADC12IV,34))
	  {
	  case  0: break;                           // Vector  0:  No interrupt
	  case  2: break;                           // Vector  2:  ADC overflow
	  case  4: break;                           // Vector  4:  ADC timing overflow
	  case  6:                           		// Vector  6:  ADC12IFG0
	  {
	  static unsigned int m,count = 0;
	  float factor=0.80566;
	  results[count]=ADC12MEM0;
	  count++;
	  for(m=0;m<10;m++)
	  {
		  sum+=results[m];
	  }
	  sum/=10;
	  sum=sum*factor;
	  com=sum;
	  if (count == 10)
	        {
	          count = 0;
	          flag=1;
	          ADC12IE = 0x00;
	        }
	  }
	  case  8: break;                           // Vector  8:  ADC12IFG1
	  case 10: break;                           // Vector 10:  ADC12IFG2
	  case 12: break;                           // Vector 12:  ADC12IFG3
	  case 14: break;                           // Vector 14:  ADC12IFG4
	  case 16: break;                           // Vector 16:  ADC12IFG5
	  case 18: break;                           // Vector 18:  ADC12IFG6
	  case 20: break;                           // Vector 20:  ADC12IFG7
	  case 22: break;                           // Vector 22:  ADC12IFG8
	  case 24: break;                           // Vector 24:  ADC12IFG9
	  case 26: break;                           // Vector 26:  ADC12IFG10
	  case 28: break;                           // Vector 28:  ADC12IFG11
	  case 30: break;                           // Vector 30:  ADC12IFG12
	  case 32: break;                           // Vector 32:  ADC12IFG13
	  case 34: break;                           // Vector 34:  ADC12IFG14
	  default: break;
	  }
}
/**************************************************************************************************
 *TA1жϺ
 *
 *
 *
**************************************************************************************************/
#pragma vector=TIMER1_A1_VECTOR
__interrupt void TIMER1_A1_ISR(void)
{
  switch(__even_in_range(TA1IV,14))
  {
    case  0: break;                          // No interrupt
    case  2:
    	 if(TA1CCTL1&CM0)
         {
    	   newdata=TA1R;
    	   if(newdata<olddata)
    	   {
    		   data=65536+newdata-olddata;
    	   }
    	   else
    	   {
    		   data=newdata-olddata;
    	   }
    	   olddata=newdata;
    	   num=data;
         }
    	   P1OUT ^= BIT3;
    	   break;   	                           // CCR1 not used
    case  4: break;   	                         // CCR2 not used
    case  6: break;           // reserved
    case  8: break;           // reserved
    case 10: break;           // reserved
    case 12: break;           // reserved
    case 14: break;           // overflow
    default: break;
  }
}
