#include "io430.h"
#include "LCD22.h"
#include "SYSTEM.h"
#include "FONT.c"

unsigned BACK_COLOR, POINT_COLOR;   //ɫɫ

/*SPI*/
/*ӲSPI߲ٶȿ*/
void LCD_Writ_Bus(uchar dat)
{
  UCB0TXBUF = dat;
}

void LCD_WR_DATA8(uchar da)
{
  LCD_DC1;
  LCD_Writ_Bus(da);
} 
 void LCD_WR_DATA(unsigned da)
{
  LCD_DC1;
  LCD_Writ_Bus(da>>8);
  LCD_Writ_Bus(da);
}	  
void LCD_WR_REG(uchar da)	 
{
  LCD_DC0;
  LCD_Writ_Bus(da);
}
 void LCD_WR_REG_DATA(unsigned reg,unsigned da)
{
  LCD_WR_REG(reg);
  LCD_WR_DATA(da);
}
void Address_set(unsigned x1,unsigned y1,unsigned x2,unsigned y2)
{
  LCD_WR_REG(0x2a);
  LCD_WR_DATA8(x1>>8);
  LCD_WR_DATA8(x1);
  LCD_WR_DATA8(x2>>8);
  LCD_WR_DATA8(x2);
  
  LCD_WR_REG(0x2b);
  LCD_WR_DATA8(y1>>8);
  LCD_WR_DATA8(y1);
  LCD_WR_DATA8(y2>>8);
  LCD_WR_DATA8(y2);

  LCD_WR_REG(0x2C);
}

/*ʼSPI*/
void SPIB_Init(void)
{
  UCB0CTL1 = UCSWRST;  //ȸλ
  //IO
  P3SEL |= BIT1 + BIT3;

  UCB0CTL0 = UCCKPH + UCMSB + UCMST;  //λʼģʽ
  UCB0CTL1 = UCSSEL_2;  //λʱΪSMCLK
}

/*ʼ*/
void Lcd_Init(void)
{
  //ҪSPIģ
  SPIB_Init();
  LCD_REST1;
  _delay_ms(1);
  LCD_REST0;
  _delay_ms(10);
  LCD_REST1;
  _delay_ms(120);
  
  LCD_WR_REG(0x11);
  LCD_WR_REG(0x29);
  LCD_WR_REG(0x2c);
  
  LCD_WR_REG(0xCB);
  LCD_WR_DATA8(0x39); 
  LCD_WR_DATA8(0x2C); 
  LCD_WR_DATA8(0x00); 
  LCD_WR_DATA8(0x34); 
  LCD_WR_DATA8(0x02);
  
  LCD_WR_REG(0xCF);
  LCD_WR_DATA8(0x00);
  LCD_WR_DATA8(0XC1);
  LCD_WR_DATA8(0X30);
  
  LCD_WR_REG(0xE8);
  LCD_WR_DATA8(0x85);
  LCD_WR_DATA8(0x00);
  LCD_WR_DATA8(0x78);
  
  LCD_WR_REG(0xEA);
  LCD_WR_DATA8(0x00);
  LCD_WR_DATA8(0x00);
  
  LCD_WR_REG(0xED);
  LCD_WR_DATA8(0x64);
  LCD_WR_DATA8(0x03);
  LCD_WR_DATA8(0X12);
  LCD_WR_DATA8(0X81);
  
  LCD_WR_REG(0xF7);
  LCD_WR_DATA8(0x20);
  
  LCD_WR_REG(0xC0);    //Power control
  LCD_WR_DATA8(0x23);   //VRH[5:0] 
  
  LCD_WR_REG(0xC1);    //Power control 
  LCD_WR_DATA8(0x10);   //SAP[2:0];BT[3:0]
  
  LCD_WR_REG(0xC5);    //VCM control 
  LCD_WR_DATA8(0x3e); //???̡?
  LCD_WR_DATA8(0x28); 
  
  LCD_WR_REG(0xC7);    //VCM control2 
  LCD_WR_DATA8(0x86);  //--
  
  LCD_WR_REG(0x36);    // Memory Access Control 
  LCD_WR_DATA8(0x48); //C8	   //48 68?//28 E8 o?
  
  LCD_WR_REG(0x3A);
  LCD_WR_DATA8(0x55); 
  
  LCD_WR_REG(0xB1);
  LCD_WR_DATA8(0x00);
  LCD_WR_DATA8(0x18);
  
  LCD_WR_REG(0xB6);    // Display Function Control
  LCD_WR_DATA8(0x08);
  LCD_WR_DATA8(0x82);
  LCD_WR_DATA8(0x27);
  
  LCD_WR_REG(0xF2);    // 3Gamma Function Disable 
  LCD_WR_DATA8(0x00); 

  LCD_WR_REG(0x26);    //Gamma curve selected 
  LCD_WR_DATA8(0x01);
  
  LCD_WR_REG(0xE0);    //Set Gamma
  LCD_WR_DATA8(0x0F); 
  LCD_WR_DATA8(0x31);
  LCD_WR_DATA8(0x2B);
  LCD_WR_DATA8(0x0C);
  LCD_WR_DATA8(0x0E);
  LCD_WR_DATA8(0x08);
  LCD_WR_DATA8(0x4E);
  LCD_WR_DATA8(0xF1);
  LCD_WR_DATA8(0x37);
  LCD_WR_DATA8(0x07);
  LCD_WR_DATA8(0x10);
  LCD_WR_DATA8(0x03);
  LCD_WR_DATA8(0x0E);
  LCD_WR_DATA8(0x09);
  LCD_WR_DATA8(0x00);
  
  LCD_WR_REG(0XE1);    //Set Gamma
  LCD_WR_DATA8(0x00);
  LCD_WR_DATA8(0x0E);
  LCD_WR_DATA8(0x14);
  LCD_WR_DATA8(0x03);
  LCD_WR_DATA8(0x11);
  LCD_WR_DATA8(0x07);
  LCD_WR_DATA8(0x31);
  LCD_WR_DATA8(0xC1);
  LCD_WR_DATA8(0x48);
  LCD_WR_DATA8(0x08);
  LCD_WR_DATA8(0x0F);
  LCD_WR_DATA8(0x0C);
  LCD_WR_DATA8(0x31);
  LCD_WR_DATA8(0x36);
  LCD_WR_DATA8(0x0F);
  
  LCD_WR_REG(0x11);    //Exit Sleep
  LCD_WR_REG(0x29);    //Display on
  LCD_WR_REG(0x2c); 
}

void LCD_Clear(unsigned Color)
{
  uchar VH,VL;
  unsigned i,j;
  VH=Color>>8;
  VL=Color;
  Address_set(0,0,239,319);
  for(i=0;i<240;i++)
  {
    for (j=0;j<320;j++)
    {
      LCD_WR_DATA8(VH);
      LCD_WR_DATA8(VL);
    }
  }
}

//ָλʾһ1616ĺ
void showhanzi1616(unsigned int x,unsigned int y,const unsigned char *index,unsigned int POINT_COLOR,unsigned int BACK_COLOR)	
{
  uchar i,j;
  Address_set(x,y,x+15,y+15);
  for(j=0;j<32;j++)
  {
    for(i=0;i<8;i++)
    {
      if((*index&(1<<i))!=0)
        LCD_WR_DATA(POINT_COLOR);
      else
        LCD_WR_DATA(BACK_COLOR);
    }
    index++;
  }
}

//ָλʾһ3216
void showshuzi3216(unsigned int x,unsigned int y,const unsigned char index,unsigned int POINT_COLOR,unsigned int BACK_COLOR)	
{
  uchar i,j;
  const unsigned char *temp=shuzi3216;
  Address_set(x,y,x+15,y+31);
  temp+=index*64;
  for(j=0;j<64;j++)
  {
    for(i=0;i<8;i++)
    {
      if((*temp&(1<<i))!=0)
        LCD_WR_DATA(POINT_COLOR);
      else
        LCD_WR_DATA(BACK_COLOR);
    }
    temp++;
  }
}


//ָλʾ3232ĺ
void showhanzi3232(unsigned int x,unsigned int y,unsigned char index,unsigned int POINT_COLOR,unsigned int BACK_COLOR)	
{
  unsigned char i,j;
  const unsigned char *temp=hanzi3232;
  Address_set(x,y,x+31,y+31);
  temp+=index*128;
  for(j=0;j<128;j++)
  {
    for(i=0;i<8;i++)
    {
      if((*temp&(1<<i))!=0)
        LCD_WR_DATA(POINT_COLOR);
      else
        LCD_WR_DATA(BACK_COLOR);
    }
    temp++;
  }
}

//
//POINT_COLOR:˵ɫ
void LCD_DrawPoint(unsigned x,unsigned y,unsigned int POINT_COLOR)
{
  Address_set(x,y,x,y);
  LCD_WR_DATA(POINT_COLOR); 	    
} 
//ĳ
void LCD_Fill(unsigned xsta,unsigned ysta,unsigned xend,unsigned yend,unsigned color)
{
  unsigned i,j;
  Address_set(xsta,ysta,xend,yend);
  for(i=ysta;i<=yend;i++)
    for(j=xsta;j<=xend;j++)LCD_WR_DATA(color);					  	    
} 
//һĵ
void LCD_DrawPoint_big(unsigned x,unsigned y,unsigned int POINT_COLOR)
{
  LCD_Fill(x-2,y-2,x+2,y+2,POINT_COLOR);
} 

//
//x1,y1:
//x2,y2:յ
void LCD_DrawLine(unsigned x1, unsigned y1, unsigned x2, unsigned y2,unsigned int POINT_COLOR)
{
  unsigned t;
  int xerr=0,yerr=0,delta_x,delta_y,distance;
  int incx,incy,uRow,uCol;
  
  delta_x=x2-x1; //????????
  delta_y=y2-y1;
  uRow=x1;
  uCol=y1;
  if(delta_x>0)incx=1; //??̣2??? 
  else if(delta_x==0)incx=0;//1??? 
  else {incx=-1;delta_x=-delta_x;}
  if(delta_y>0)incy=1;
  else if(delta_y==0)incy=0;//??????
  else{incy=-1;delta_y=-delta_y;} 
  if( delta_x>delta_y)distance=delta_x; //?????????? 
  else distance=delta_y;
  for(t=0;t<=distance+1;t++ )//?-???3? 
  {
    LCD_DrawPoint(uRow,uCol,POINT_COLOR);//?-? 
    xerr+=delta_x ;
    yerr+=delta_y ;
    if(xerr>distance)
    {
      xerr-=distance;
      uRow+=incx;
    }
    if(yerr>distance)
    {
      yerr-=distance;
      uCol+=incy;
    }
  }  
} 
//
//x1,y1:
//x2,y2:յ
void LCD_ClearLine(unsigned x1, unsigned y1, unsigned x2, unsigned y2,unsigned int POINT_COLOR)
{
  unsigned t;
  int xerr=0,yerr=0,delta_x,delta_y,distance;
  int incx,incy,uRow,uCol;
  
  delta_x=x2-x1; //????????
  delta_y=y2-y1;
  uRow=x1;
  uCol=y1;
  if(delta_x>0)incx=1; //??̣2??? 
  else if(delta_x==0)incx=0;//1??? 
  else {incx=-1;delta_x=-delta_x;} 
  if(delta_y>0)incy=1;
  else if(delta_y==0)incy=0;//??????
  else{incy=-1;delta_y=-delta_y;}
  if( delta_x>delta_y)distance=delta_x; //??????????
  else distance=delta_y;
  for(t=0;t<=distance+1;t++ )//?-???3?
  {
    LCD_DrawPoint(uRow,uCol,POINT_COLOR);//?-?
    xerr+=delta_x;
    yerr+=delta_y;
    if(xerr>distance)
    {
      xerr-=distance;
      uRow+=incx;
    }
    if(yerr>distance)
    {
      yerr-=distance;
      uCol+=incy;
    }
  }  
} 


//
void LCD_DrawRectangle(unsigned x1, unsigned y1, unsigned x2, unsigned y2,unsigned int POINT_COLOR)
{
  LCD_DrawLine(x1,y1,x2,y1,POINT_COLOR);
  LCD_DrawLine(x1,y1,x1,y2,POINT_COLOR);
  LCD_DrawLine(x1,y2,x2,y2,POINT_COLOR);
  LCD_DrawLine(x2,y1,x2,y2,POINT_COLOR);
}

//ָλûԲ
//(x,y):Բλ
//r    :뾶
void Draw_Circle(unsigned x0,unsigned y0,uchar r,unsigned int POINT_COLOR)
{
  int a,b;
  int di;
  a=0;b=r;
  di=3-(r<<1);
  //di=5/4-r;
  while(a<=b)
  {
    LCD_DrawPoint(x0-b,y0-a,POINT_COLOR);             //3
    LCD_DrawPoint(x0+b,y0-a,POINT_COLOR);             //0
    LCD_DrawPoint(x0-a,y0+b,POINT_COLOR);             //1
    LCD_DrawPoint(x0-b,y0-a,POINT_COLOR);             //7
    LCD_DrawPoint(x0-a,y0-b,POINT_COLOR);             //2
    LCD_DrawPoint(x0+b,y0+a,POINT_COLOR);             //4
    LCD_DrawPoint(x0+a,y0-b,POINT_COLOR);             //5
    LCD_DrawPoint(x0+a,y0+b,POINT_COLOR);             //6
    LCD_DrawPoint(x0-b,y0+a,POINT_COLOR);
    a++;
    //1?Bresenham???-?2
    if(di<0)di +=4*a+6;
    else
    {
      di+=10+4*(a-b);
      b--;
    }
    LCD_DrawPoint(x0+a,y0+b,POINT_COLOR);
  }
} 

/*
void Draw_Circle(unsigned Ox,unsigned Oy,uchar Rx)
{
	unsigned xx,rr,xt,yt,rs,col,row;
	yt=Rx;
	rr=Rx*Rx+1;			//213 1 DT?y?D?
	rs=(yt+(yt>>1))>>1;		//(*0.75)??a1/8?2???-
	for (xt=0;xt<=rs;xt++)
	{
		xx=xt*xt;
		while ((yt*yt)>(rr-xx))yt--;
		col=Ox+xt;		//̨???T
		row=Oy-yt;
		LCD_DrawPoint(col,row);
		col=Ox-xt;		//̨?t??T
		LCD_DrawPoint(col,row);
		row=Oy+yt;		//̨y??T
		LCD_DrawPoint(col,row);
		col=Ox+xt;		//̨????T
		LCD_DrawPoint(col,row);
                
		col=Ox+yt;		//̨???T
		row=Oy-xt;
		LCD_DrawPoint(col,row);
		col=Ox-yt;		//̨?t??T
		LCD_DrawPoint(col,row);
		row=Oy+xt;		//̨y??T
		LCD_DrawPoint(col,row);
		col=Ox+yt;		//̨????T
		LCD_DrawPoint(col,row);
	}
}
*/
/*
void LCD_ShowChar(unsigned int x,unsigned int y,const unsigned char *index)	
{  
	uchar i,j;  
        Address_set(x,y,x+7,y+15);     	
	for(j=0;j<16;j++)
	{
		for(i=0;i<8;i++)
		{ 		     
		 	if((*index&(1<<i))!=0)
			{
				LCD_WR_DATA(POINT_COLOR);
			} 
			else
			{
				LCD_WR_DATA(BACK_COLOR);
			}   
		}
		index++;
	 }
}
*/
void LCD_ShowChar(unsigned x,unsigned y,uchar num,unsigned POINT_COLOR,unsigned BACK_COLOR)
{
  uchar temp;
  uchar pos,t;
  unsigned x0=x;
  if(x>LCD_W-16||y>LCD_H-16)return;
  num=num-' ';
  Address_set(x,y,x+7,y+15);
  for(pos=0;pos<16;pos++)
  {
    temp=asc2_1608[(unsigned)num*16+pos];
    for(t=0;t<8;t++)
    {
      if(temp&0x01)POINT_COLOR=POINT_COLOR;
      else POINT_COLOR=BACK_COLOR;
      LCD_WR_DATA(POINT_COLOR);
      temp>>=1;
      x++;
    }
    x=x0;
    y++;
  }		    	   	 	  
}   

void LCD_ShowString(unsigned x,unsigned y,const uchar *p,unsigned int POINT_COLOR,unsigned int BACK_COLOR)
{
  while(*p!='\0')
  {
    if(x>LCD_W-16){x=0;y+=16;}
    if(y>LCD_H-16){y=x=0;}
    LCD_ShowChar(x,y,*p,POINT_COLOR,BACK_COLOR);
    x+=8;
    p++;
  }  
}

