//******************************************************************************
//   MSP430AFE25x Demo - 16x16 Signed Multiply
//
//   Description: Hardware multiplier is used to multiply two numbers.
//   The calculation is automatically initiated after the second operand is
//   loaded. Results are stored in RESLO, RESHI and SUMEXT = FFFF if result is
//   negative, SUMEXT = 0 otherwise.
//
//   ACLK = n/a, MCLK = SMCLK = default DCO
//
//                MSP430AFE25x
//             -----------------
//         /|\|                 |
//          | |                 |
//          --|RST              |
//            |                 |
//            |                 |
//
//  Naveen Kala
//  Texas Instruments, Inc
//  March 2011
//  Built with IAR Embedded Workbench Version: 5.20.1
//******************************************************************************
#include <msp430afe253.h>

void main(void)
{
  WDTCTL = WDTPW+WDTHOLD;                   // Stop WDT
  MPYS = 0x01234;                           // Load first operand -signed mult
  OP2 = 0x05678;                            // Load second operand
  _BIS_SR(LPM4_bits + GIE);                 // LPM4
}
