#include <msp430.h> 
#include "driverlib.h"
#include "DAC.h"
#include "Template_Driver.h"
#include "grlib.h"

#include "hal_ucs.h"
#include "hal_pmm.h"

#include "adc12_a.h"
#include "timer_a.h"

#include "CTS_Layer.h"
#include "structure.h"

#define SYSSMCLK	25000000
#define PWM_FRE		SYSSMCLK/50000

#define MAX_DAC_DIV8		(4096>>3)

unsigned int Key = 0;

extern void KeyScan();
extern void Buck_Init();
extern void Boost_Init();
extern void SysClk_init(void);

extern void GrStringNumberCentered(const tContext *pContext, int16_t Number,uint8_t ui8Dot,uint8_t ui8X, uint8_t ui8Y);
tContext g_sContext;
extern uint16_t ADC12_SingleSample(void);
extern void GrStringNumberCentered(const tContext *pContext, int16_t Number,uint8_t ui8Dot,uint8_t ui8X, uint8_t ui8Y);

const uint16_t WavData[12]={MAX_DAC_DIV8,MAX_DAC_DIV8*2,MAX_DAC_DIV8*3,MAX_DAC_DIV8*4,MAX_DAC_DIV8*5,MAX_DAC_DIV8*6,MAX_DAC_DIV8*7,
							MAX_DAC_DIV8*6,MAX_DAC_DIV8*5,MAX_DAC_DIV8*4,MAX_DAC_DIV8*3,MAX_DAC_DIV8*2};



/*
 * main.c
 */
int s=0;    //sʾ

int num =0; //numʾLEDֵ

int main(void) {
    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer
   // P1DIR=0xff;   //P1ȫ

    //  P1OUT=0x00;        //LEDʼȫͣʼ

      P2DIR=0x00;        //P2ȫΪ롣ΪҪⲿж

      P2IFG=0x00;        //P2ڵжϱ־

      P2IE=0x48;         //P2.3 P2.6ж

      P2IES=0xff;     //P2Ϊ½ش

      P2IN=0x48; //P2.3 P2,6ߣ˿رպʱͲ½أжϣ

      P2OUT=0xff;

      P2REN=0xff;     //ΪʱһҪ裨ҪǣҾ-_




      // رհ׹LED
      	P2DIR |= BIT0;
      	P2OUT |= BIT0;

      	//򿪱LED
      	P3DIR |= BIT4;
      	P3OUT |= BIT4;

      	SysClk_init();							//25M

      	Template_DriverInit();       //cog12864 ʼ
      	GrContextInit(&g_sContext, &g_sTemplate_Driver);
		GrContextForegroundSet(&g_sContext, ClrWhite);
		GrContextBackgroundSet(&g_sContext, ClrBlack);
		GrContextFontSet(&g_sContext, &g_sFontCm16b);
		GrClearDisplay(&g_sContext);

		GrStringDraw(&g_sContext, "=MSP430F5529LP=", AUTO_STRING_LENGTH, 0,0, OPAQUE_TEXT);



      _enable_interrupts(); //ж










    /*  while(1)

     {

           num=s%3;

           switch(num){

              case 0:P1OUT=0x00;break;

              case 1:P1OUT=0x00;break;

              case 2:P1OUT=BIT0;break;

              }
     }*/
}


#pragma vector=PORT2_VECTOR     //̶ʽжַ

__interrupt void Port2_ISR(void)  {//жӳ

      unsigned int temp;    //ֲ

      int i;

      for(i=0;i<12000;i++); // ʱ

      if((P2IN&0xff)!=0xff){   //м

         temp=P2IFG;        //ȡжϱ־

         P2IFG=0x00;        //־λ

         if(temp==0x08)     //P2.3ж

            s++;
         if(temp==0x40)     //P2.6ж

            s++;


      }} //һʵм仰ܶ࣬ҪΪÿ˿жϵ֪ʶ






void SysClk_init(void)
{
	SetVCore(PMMCOREV_3);			// ù20MhzVcore 1.8V

	P5SEL |= BIT5 + BIT4;			// P5.4/P5.5ΪXT1ܽţϵĬΪIOģʽ
	//P5SEL |= BIT2 + BIT3;			// P5.2/P5.3ΪXT2ܽţϵĬΪIOģʽ

	LFXT_Start(XT1DRIVE_3);			// ⲿXT1_LƵʱԴ
	//XT2_Start(XT1DRIVE_3);		// ⲿƵXT2ʱԴ

	SELECT_FLLREF(SELREF__XT1CLK);	// ѡFLLʱԴ
    // Use 32.768kHz XTAL as reference
	Init_FLL_Settle(25000,762);		// ñƵϵ  20000,610 25000 762

	SELECT_ACLK(SELA__XT1CLK);		// ѡACLKʱԴ
//	SELECT_MCLK(SELM__XT1CLK);		// ѡMCLKʱԴ
//	SELECT_SMCLK(SELS__XT2CLK);		// ѡSMCLKʱԴ

//	  P1DIR |= BIT0;                // ACLK set out to pins
//	  P1SEL |= BIT0;
//	  P2DIR |= BIT2;                // SMCLK set out to pins
//	  P2SEL |= BIT2;
//	  P7DIR |= BIT7;                // MCLK set out to pins
//	  P7SEL |= BIT7;
}


