//******************************************************************************
//  RC_PAIR_TA0 example
//
// 4 elements configured as a 64 point slider.  
//
// This file contains the structure names and the variable assingments.
//
//******************************************************************************


#include "structure.h"
//#include "stdint.h"
//#pragma location="INFOB"

// P2.3 input, P2.6 reference
const struct Element Left = {
              .inputPxoutRegister = (uint8_t *)&P2OUT,
              .inputPxinRegister = (uint8_t *)&P2IN,
              .inputPxdirRegister = (uint8_t *)&P2DIR,
              .referencePxoutRegister= (uint8_t *)&P2OUT,
              .referencePxdirRegister = (uint8_t *)&P2DIR,
              .referenceBits = BIT3,
              .inputBits =  BIT6,
              .maxResponse = 250,
              .threshold = 80
};
// P2.6 input, P2.3 reference
const struct Element Right = {

			  .inputPxoutRegister = (uint8_t *)&P2OUT,
              .inputPxinRegister = (uint8_t *)&P2IN,
              .inputPxdirRegister = (uint8_t *)&P2DIR,
              .referencePxoutRegister= (uint8_t *)&P2OUT,
              .referencePxdirRegister = (uint8_t *)&P2DIR,
              .referenceBits = BIT6,
              .inputBits =  BIT3,
              .maxResponse = 250,
              .threshold = 80,
};

//*** Sensor *******************************************************/
// This defines the grouping of sensors, the method to measure change in
// capacitance, and the function of the group

const struct Sensor buttons =
{ 
                  .halDefinition = RC_PAIR_TA0,
                  .numElements = 2,
                  .baseOffset = 0,
                  .points = 10,
                  .sensorThreshold = 50,
                  // Pointer to elements
                  .arrayPtr[0] = &Left,  // point to first element
                  .arrayPtr[1] = &Right,
                  // Timer Information
                  //.measGateSource= TIMER_TxCLK,   // TxCLK
                  //.measGateSource= TIMER_ACLK,    // ACLK
                  .measGateSource= TIMER_SMCLK,     // SMCLK
				  //.sourceScale = TIMER_SOURCE_DIV_0,
				  //.sourceScale = TIMER_SOURCE_DIV_1,
				  //.sourceScale = TIMER_SOURCE_DIV_2,
				  //.sourceScale = TIMER_SOURCE_DIV_3,
                  .accumulationCycles = 10
};
