/* =================================================================================
File name:      COS_TAB.H                     
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description: 
Header file containing 360 entries look-up table for cos(ang) in actual value 

=====================================================================================
 History:
-------------------------------------------------------------------------------------
 07-13-2011	Version 1.20a                                                  
------------------------------------------------------------------------------ */

#include "dmctype.h"

const float32 cos_tab[] =
{    	//Sine					Index	Angle   720/360=0.5
	1.000000000,	//	    0		0.000000000
	0.999961923,	//	    1		0.500000000
	0.999847695,	//	    2		1.000000000
	0.999657325,	//	    3		1.500000000
	0.999390827,	//	    4		2.000000000
	0.999048222,	//	    5		2.500000000
	0.998629535,	//	    6		3.000000000
	0.998134798,	//	    7		3.500000000
	0.997564050,	//	    8		4.000000000
	0.996917334,	//	    9		4.500000000
	0.996194698,	//	   10		5.000000000
	0.995396198,	//	   11		5.500000000
	0.994521895,	//	   12		6.000000000
	0.993571856,	//	   13		6.500000000
	0.992546152,	//	   14		7.000000000
	0.991444861,	//	   15		7.500000000
	0.990268069,	//	   16		8.000000000
	0.989015863,	//	   17		8.500000000
	0.987688341,	//	   18		9.000000000
	0.986285602,	//	   19		9.500000000
	0.984807753,	//	   20		10.000000000
	0.983254908,	//	   21		10.500000000
	0.981627183,	//	   22		11.000000000
	0.979924705,	//	   23		11.500000000
	0.978147601,	//	   24		12.000000000
	0.976296007,	//	   25		12.500000000
	0.974370065,	//	   26		13.000000000
	0.972369920,	//	   27		13.500000000
	0.970295726,	//	   28		14.000000000
	0.968147640,	//	   29		14.500000000
	0.965925826,	//	   30		15.000000000
	0.963630453,	//	   31		15.500000000
	0.961261696,	//	   32		16.000000000
	0.958819735,	//	   33		16.500000000
	0.956304756,	//	   34		17.000000000
	0.953716951,	//	   35		17.500000000
	0.951056516,	//	   36		18.000000000
	0.948323655,	//	   37		18.500000000
	0.945518576,	//	   38		19.000000000
	0.942641491,	//	   39		19.500000000
	0.939692621,	//	   40		20.000000000
	0.936672189,	//	   41		20.500000000
	0.933580426,	//	   42		21.000000000
	0.930417568,	//	   43		21.500000000
	0.927183855,	//	   44		22.000000000
	0.923879533,	//	   45		22.500000000
	0.920504853,	//	   46		23.000000000
	0.917060074,	//	   47		23.500000000
	0.913545458,	//	   48		24.000000000
	0.909961271,	//	   49		24.500000000
	0.906307787,	//	   50		25.000000000
	0.902585284,	//	   51		25.500000000
	0.898794046,	//	   52		26.000000000
	0.894934362,	//	   53		26.500000000
	0.891006524,	//	   54		27.000000000
	0.887010833,	//	   55		27.500000000
	0.882947593,	//	   56		28.000000000
	0.878817113,	//	   57		28.500000000
	0.874619707,	//	   58		29.000000000
	0.870355696,	//	   59		29.500000000
	0.866025404,	//	   60		30.000000000
	0.861629160,	//	   61		30.500000000
	0.857167301,	//	   62		31.000000000
	0.852640164,	//	   63		31.500000000
	0.848048096,	//	   64		32.000000000
	0.843391446,	//	   65		32.500000000
	0.838670568,	//	   66		33.000000000
	0.833885822,	//	   67		33.500000000
	0.829037573,	//	   68		34.000000000
	0.824126189,	//	   69		34.500000000
	0.819152044,	//	   70		35.000000000
	0.814115518,	//	   71		35.500000000
	0.809016994,	//	   72		36.000000000
	0.803856861,	//	   73		36.500000000
	0.798635510,	//	   74		37.000000000
	0.793353340,	//	   75		37.500000000
	0.788010754,	//	   76		38.000000000
	0.782608157,	//	   77		38.500000000
	0.777145961,	//	   78		39.000000000
	0.771624583,	//	   79		39.500000000
	0.766044443,	//	   80		40.000000000
	0.760405966,	//	   81		40.500000000
	0.754709580,	//	   82		41.000000000
	0.748955721,	//	   83		41.500000000
	0.743144825,	//	   84		42.000000000
	0.737277337,	//	   85		42.500000000
	0.731353702,	//	   86		43.000000000
	0.725374371,	//	   87		43.500000000
	0.719339800,	//	   88		44.000000000
	0.713250449,	//	   89		44.500000000
	0.707106781,	//	   90		45.000000000
	0.700909264,	//	   91		45.500000000
	0.694658370,	//	   92		46.000000000
	0.688354576,	//	   93		46.500000000
	0.681998360,	//	   94		47.000000000
	0.675590208,	//	   95		47.500000000
	0.669130606,	//	   96		48.000000000
	0.662620048,	//	   97		48.500000000
	0.656059029,	//	   98		49.000000000
	0.649448048,	//	   99		49.500000000
	0.642787610,	//	  100		50.000000000
	0.636078220,	//	  101		50.500000000
	0.629320391,	//	  102		51.000000000
	0.622514637,	//	  103		51.500000000
	0.615661475,	//	  104		52.000000000
	0.608761429,	//	  105		52.500000000
	0.601815023,	//	  106		53.000000000
	0.594822787,	//	  107		53.500000000
	0.587785252,	//	  108		54.000000000
	0.580702956,	//	  109		54.500000000
	0.573576436,	//	  110		55.000000000
	0.566406237,	//	  111		55.500000000
	0.559192903,	//	  112		56.000000000
	0.551936985,	//	  113		56.500000000
	0.544639035,	//	  114		57.000000000
	0.537299608,	//	  115		57.500000000
	0.529919264,	//	  116		58.000000000
	0.522498565,	//	  117		58.500000000
	0.515038075,	//	  118		59.000000000
	0.507538363,	//	  119		59.500000000
	0.500000000,	//	  120		60.000000000
	0.492423560,	//	  121		60.500000000
	0.484809620,	//	  122		61.000000000
	0.477158760,	//	  123		61.500000000
	0.469471563,	//	  124		62.000000000
	0.461748613,	//	  125		62.500000000
	0.453990500,	//	  126		63.000000000
	0.446197813,	//	  127		63.500000000
	0.438371147,	//	  128		64.000000000
	0.430511097,	//	  129		64.500000000
	0.422618262,	//	  130		65.000000000
	0.414693243,	//	  131		65.500000000
	0.406736643,	//	  132		66.000000000
	0.398749069,	//	  133		66.500000000
	0.390731128,	//	  134		67.000000000
	0.382683432,	//	  135		67.500000000
	0.374606593,	//	  136		68.000000000
	0.366501227,	//	  137		68.500000000
	0.358367950,	//	  138		69.000000000
	0.350207381,	//	  139		69.500000000
	0.342020143,	//	  140		70.000000000
	0.333806859,	//	  141		70.500000000
	0.325568154,	//	  142		71.000000000
	0.317304656,	//	  143		71.500000000
	0.309016994,	//	  144		72.000000000
	0.300705800,	//	  145		72.500000000
	0.292371705,	//	  146		73.000000000
	0.284015345,	//	  147		73.500000000
	0.275637356,	//	  148		74.000000000
	0.267238376,	//	  149		74.500000000
	0.258819045,	//	  150		75.000000000
	0.250380004,	//	  151		75.500000000
	0.241921896,	//	  152		76.000000000
	0.233445364,	//	  153		76.500000000
	0.224951054,	//	  154		77.000000000
	0.216439614,	//	  155		77.500000000
	0.207911691,	//	  156		78.000000000
	0.199367934,	//	  157		78.500000000
	0.190808995,	//	  158		79.000000000
	0.182235525,	//	  159		79.500000000
	0.173648178,	//	  160		80.000000000
	0.165047606,	//	  161		80.500000000
	0.156434465,	//	  162		81.000000000
	0.147809411,	//	  163		81.500000000
	0.139173101,	//	  164		82.000000000
	0.130526192,	//	  165		82.500000000
	0.121869343,	//	  166		83.000000000
	0.113203214,	//	  167		83.500000000
	0.104528463,	//	  168		84.000000000
	0.095845753,	//	  169		84.500000000
	0.087155743,	//	  170		85.000000000
	0.078459096,	//	  171		85.500000000
	0.069756474,	//	  172		86.000000000
	0.061048540,	//	  173		86.500000000
	0.052335956,	//	  174		87.000000000
	0.043619387,	//	  175		87.500000000
	0.034899497,	//	  176		88.000000000
	0.026176948,	//	  177		88.500000000
	0.017452406,	//	  178		89.000000000
	0.008726535,	//	  179		89.500000000
	0.000000000,	//	  180		90.000000000
	-0.008726535,	//	  181		90.500000000
	-0.017452406,	//	  182		91.000000000
	-0.026176948,	//	  183		91.500000000
	-0.034899497,	//	  184		92.000000000
	-0.043619387,	//	  185		92.500000000
	-0.052335956,	//	  186		93.000000000
	-0.061048540,	//	  187		93.500000000
	-0.069756474,	//	  188		94.000000000
	-0.078459096,	//	  189		94.500000000
	-0.087155743,	//	  190		95.000000000
	-0.095845753,	//	  191		95.500000000
	-0.104528463,	//	  192		96.000000000
	-0.113203214,	//	  193		96.500000000
	-0.121869343,	//	  194		97.000000000
	-0.130526192,	//	  195		97.500000000
	-0.139173101,	//	  196		98.000000000
	-0.147809411,	//	  197		98.500000000
	-0.156434465,	//	  198		99.000000000
	-0.165047606,	//	  199		99.500000000
	-0.173648178,	//	  200		100.000000000
	-0.182235525,	//	  201		100.500000000
	-0.190808995,	//	  202		101.000000000
	-0.199367934,	//	  203		101.500000000
	-0.207911691,	//	  204		102.000000000
	-0.216439614,	//	  205		102.500000000
	-0.224951054,	//	  206		103.000000000
	-0.233445364,	//	  207		103.500000000
	-0.241921896,	//	  208		104.000000000
	-0.250380004,	//	  209		104.500000000
	-0.258819045,	//	  210		105.000000000
	-0.267238376,	//	  211		105.500000000
	-0.275637356,	//	  212		106.000000000
	-0.284015345,	//	  213		106.500000000
	-0.292371705,	//	  214		107.000000000
	-0.300705800,	//	  215		107.500000000
	-0.309016994,	//	  216		108.000000000
	-0.317304656,	//	  217		108.500000000
	-0.325568154,	//	  218		109.000000000
	-0.333806859,	//	  219		109.500000000
	-0.342020143,	//	  220		110.000000000
	-0.350207381,	//	  221		110.500000000
	-0.358367950,	//	  222		111.000000000
	-0.366501227,	//	  223		111.500000000
	-0.374606593,	//	  224		112.000000000
	-0.382683432,	//	  225		112.500000000
	-0.390731128,	//	  226		113.000000000
	-0.398749069,	//	  227		113.500000000
	-0.406736643,	//	  228		114.000000000
	-0.414693243,	//	  229		114.500000000
	-0.422618262,	//	  230		115.000000000
	-0.430511097,	//	  231		115.500000000
	-0.438371147,	//	  232		116.000000000
	-0.446197813,	//	  233		116.500000000
	-0.453990500,	//	  234		117.000000000
	-0.461748613,	//	  235		117.500000000
	-0.469471563,	//	  236		118.000000000
	-0.477158760,	//	  237		118.500000000
	-0.484809620,	//	  238		119.000000000
	-0.492423560,	//	  239		119.500000000
	-0.500000000,	//	  240		120.000000000
	-0.507538363,	//	  241		120.500000000
	-0.515038075,	//	  242		121.000000000
	-0.522498565,	//	  243		121.500000000
	-0.529919264,	//	  244		122.000000000
	-0.537299608,	//	  245		122.500000000
	-0.544639035,	//	  246		123.000000000
	-0.551936985,	//	  247		123.500000000
	-0.559192903,	//	  248		124.000000000
	-0.566406237,	//	  249		124.500000000
	-0.573576436,	//	  250		125.000000000
	-0.580702956,	//	  251		125.500000000
	-0.587785252,	//	  252		126.000000000
	-0.594822787,	//	  253		126.500000000
	-0.601815023,	//	  254		127.000000000
	-0.608761429,	//	  255		127.500000000
	-0.615661475,	//	  256		128.000000000
	-0.622514637,	//	  257		128.500000000
	-0.629320391,	//	  258		129.000000000
	-0.636078220,	//	  259		129.500000000
	-0.642787610,	//	  260		130.000000000
	-0.649448048,	//	  261		130.500000000
	-0.656059029,	//	  262		131.000000000
	-0.662620048,	//	  263		131.500000000
	-0.669130606,	//	  264		132.000000000
	-0.675590208,	//	  265		132.500000000
	-0.681998360,	//	  266		133.000000000
	-0.688354576,	//	  267		133.500000000
	-0.694658370,	//	  268		134.000000000
	-0.700909264,	//	  269		134.500000000
	-0.707106781,	//	  270		135.000000000
	-0.713250449,	//	  271		135.500000000
	-0.719339800,	//	  272		136.000000000
	-0.725374371,	//	  273		136.500000000
	-0.731353702,	//	  274		137.000000000
	-0.737277337,	//	  275		137.500000000
	-0.743144825,	//	  276		138.000000000
	-0.748955721,	//	  277		138.500000000
	-0.754709580,	//	  278		139.000000000
	-0.760405966,	//	  279		139.500000000
	-0.766044443,	//	  280		140.000000000
	-0.771624583,	//	  281		140.500000000
	-0.777145961,	//	  282		141.000000000
	-0.782608157,	//	  283		141.500000000
	-0.788010754,	//	  284		142.000000000
	-0.793353340,	//	  285		142.500000000
	-0.798635510,	//	  286		143.000000000
	-0.803856861,	//	  287		143.500000000
	-0.809016994,	//	  288		144.000000000
	-0.814115518,	//	  289		144.500000000
	-0.819152044,	//	  290		145.000000000
	-0.824126189,	//	  291		145.500000000
	-0.829037573,	//	  292		146.000000000
	-0.833885822,	//	  293		146.500000000
	-0.838670568,	//	  294		147.000000000
	-0.843391446,	//	  295		147.500000000
	-0.848048096,	//	  296		148.000000000
	-0.852640164,	//	  297		148.500000000
	-0.857167301,	//	  298		149.000000000
	-0.861629160,	//	  299		149.500000000
	-0.866025404,	//	  300		150.000000000
	-0.870355696,	//	  301		150.500000000
	-0.874619707,	//	  302		151.000000000
	-0.878817113,	//	  303		151.500000000
	-0.882947593,	//	  304		152.000000000
	-0.887010833,	//	  305		152.500000000
	-0.891006524,	//	  306		153.000000000
	-0.894934362,	//	  307		153.500000000
	-0.898794046,	//	  308		154.000000000
	-0.902585284,	//	  309		154.500000000
	-0.906307787,	//	  310		155.000000000
	-0.909961271,	//	  311		155.500000000
	-0.913545458,	//	  312		156.000000000
	-0.917060074,	//	  313		156.500000000
	-0.920504853,	//	  314		157.000000000
	-0.923879533,	//	  315		157.500000000
	-0.927183855,	//	  316		158.000000000
	-0.930417568,	//	  317		158.500000000
	-0.933580426,	//	  318		159.000000000
	-0.936672189,	//	  319		159.500000000
	-0.939692621,	//	  320		160.000000000
	-0.942641491,	//	  321		160.500000000
	-0.945518576,	//	  322		161.000000000
	-0.948323655,	//	  323		161.500000000
	-0.951056516,	//	  324		162.000000000
	-0.953716951,	//	  325		162.500000000
	-0.956304756,	//	  326		163.000000000
	-0.958819735,	//	  327		163.500000000
	-0.961261696,	//	  328		164.000000000
	-0.963630453,	//	  329		164.500000000
	-0.965925826,	//	  330		165.000000000
	-0.968147640,	//	  331		165.500000000
	-0.970295726,	//	  332		166.000000000
	-0.972369920,	//	  333		166.500000000
	-0.974370065,	//	  334		167.000000000
	-0.976296007,	//	  335		167.500000000
	-0.978147601,	//	  336		168.000000000
	-0.979924705,	//	  337		168.500000000
	-0.981627183,	//	  338		169.000000000
	-0.983254908,	//	  339		169.500000000
	-0.984807753,	//	  340		170.000000000
	-0.986285602,	//	  341		170.500000000
	-0.987688341,	//	  342		171.000000000
	-0.989015863,	//	  343		171.500000000
	-0.990268069,	//	  344		172.000000000
	-0.991444861,	//	  345		172.500000000
	-0.992546152,	//	  346		173.000000000
	-0.993571856,	//	  347		173.500000000
	-0.994521895,	//	  348		174.000000000
	-0.995396198,	//	  349		174.500000000
	-0.996194698,	//	  350		175.000000000
	-0.996917334,	//	  351		175.500000000
	-0.997564050,	//	  352		176.000000000
	-0.998134798,	//	  353		176.500000000
	-0.998629535,	//	  354		177.000000000
	-0.999048222,	//	  355		177.500000000
	-0.999390827,	//	  356		178.000000000
	-0.999657325,	//	  357		178.500000000
	-0.999847695,	//	  358		179.000000000
	-0.999961923,	//	  359		179.500000000
	-1.000000000,	//	  360		180.000000000
	-0.999961923,	//	  361		180.500000000
	-0.999847695,	//	  362		181.000000000
	-0.999657325,	//	  363		181.500000000
	-0.999390827,	//	  364		182.000000000
	-0.999048222,	//	  365		182.500000000
	-0.998629535,	//	  366		183.000000000
	-0.998134798,	//	  367		183.500000000
	-0.997564050,	//	  368		184.000000000
	-0.996917334,	//	  369		184.500000000
	-0.996194698,	//	  370		185.000000000
	-0.995396198,	//	  371		185.500000000
	-0.994521895,	//	  372		186.000000000
	-0.993571856,	//	  373		186.500000000
	-0.992546152,	//	  374		187.000000000
	-0.991444861,	//	  375		187.500000000
	-0.990268069,	//	  376		188.000000000
	-0.989015863,	//	  377		188.500000000
	-0.987688341,	//	  378		189.000000000
	-0.986285602,	//	  379		189.500000000
	-0.984807753,	//	  380		190.000000000
	-0.983254908,	//	  381		190.500000000
	-0.981627183,	//	  382		191.000000000
	-0.979924705,	//	  383		191.500000000
	-0.978147601,	//	  384		192.000000000
	-0.976296007,	//	  385		192.500000000
	-0.974370065,	//	  386		193.000000000
	-0.972369920,	//	  387		193.500000000
	-0.970295726,	//	  388		194.000000000
	-0.968147640,	//	  389		194.500000000
	-0.965925826,	//	  390		195.000000000
	-0.963630453,	//	  391		195.500000000
	-0.961261696,	//	  392		196.000000000
	-0.958819735,	//	  393		196.500000000
	-0.956304756,	//	  394		197.000000000
	-0.953716951,	//	  395		197.500000000
	-0.951056516,	//	  396		198.000000000
	-0.948323655,	//	  397		198.500000000
	-0.945518576,	//	  398		199.000000000
	-0.942641491,	//	  399		199.500000000
	-0.939692621,	//	  400		200.000000000
	-0.936672189,	//	  401		200.500000000
	-0.933580426,	//	  402		201.000000000
	-0.930417568,	//	  403		201.500000000
	-0.927183855,	//	  404		202.000000000
	-0.923879533,	//	  405		202.500000000
	-0.920504853,	//	  406		203.000000000
	-0.917060074,	//	  407		203.500000000
	-0.913545458,	//	  408		204.000000000
	-0.909961271,	//	  409		204.500000000
	-0.906307787,	//	  410		205.000000000
	-0.902585284,	//	  411		205.500000000
	-0.898794046,	//	  412		206.000000000
	-0.894934362,	//	  413		206.500000000
	-0.891006524,	//	  414		207.000000000
	-0.887010833,	//	  415		207.500000000
	-0.882947593,	//	  416		208.000000000
	-0.878817113,	//	  417		208.500000000
	-0.874619707,	//	  418		209.000000000
	-0.870355696,	//	  419		209.500000000
	-0.866025404,	//	  420		210.000000000
	-0.861629160,	//	  421		210.500000000
	-0.857167301,	//	  422		211.000000000
	-0.852640164,	//	  423		211.500000000
	-0.848048096,	//	  424		212.000000000
	-0.843391446,	//	  425		212.500000000
	-0.838670568,	//	  426		213.000000000
	-0.833885822,	//	  427		213.500000000
	-0.829037573,	//	  428		214.000000000
	-0.824126189,	//	  429		214.500000000
	-0.819152044,	//	  430		215.000000000
	-0.814115518,	//	  431		215.500000000
	-0.809016994,	//	  432		216.000000000
	-0.803856861,	//	  433		216.500000000
	-0.798635510,	//	  434		217.000000000
	-0.793353340,	//	  435		217.500000000
	-0.788010754,	//	  436		218.000000000
	-0.782608157,	//	  437		218.500000000
	-0.777145961,	//	  438		219.000000000
	-0.771624583,	//	  439		219.500000000
	-0.766044443,	//	  440		220.000000000
	-0.760405966,	//	  441		220.500000000
	-0.754709580,	//	  442		221.000000000
	-0.748955721,	//	  443		221.500000000
	-0.743144825,	//	  444		222.000000000
	-0.737277337,	//	  445		222.500000000
	-0.731353702,	//	  446		223.000000000
	-0.725374371,	//	  447		223.500000000
	-0.719339800,	//	  448		224.000000000
	-0.713250449,	//	  449		224.500000000
	-0.707106781,	//	  450		225.000000000
	-0.700909264,	//	  451		225.500000000
	-0.694658370,	//	  452		226.000000000
	-0.688354576,	//	  453		226.500000000
	-0.681998360,	//	  454		227.000000000
	-0.675590208,	//	  455		227.500000000
	-0.669130606,	//	  456		228.000000000
	-0.662620048,	//	  457		228.500000000
	-0.656059029,	//	  458		229.000000000
	-0.649448048,	//	  459		229.500000000
	-0.642787610,	//	  460		230.000000000
	-0.636078220,	//	  461		230.500000000
	-0.629320391,	//	  462		231.000000000
	-0.622514637,	//	  463		231.500000000
	-0.615661475,	//	  464		232.000000000
	-0.608761429,	//	  465		232.500000000
	-0.601815023,	//	  466		233.000000000
	-0.594822787,	//	  467		233.500000000
	-0.587785252,	//	  468		234.000000000
	-0.580702956,	//	  469		234.500000000
	-0.573576436,	//	  470		235.000000000
	-0.566406237,	//	  471		235.500000000
	-0.559192903,	//	  472		236.000000000
	-0.551936985,	//	  473		236.500000000
	-0.544639035,	//	  474		237.000000000
	-0.537299608,	//	  475		237.500000000
	-0.529919264,	//	  476		238.000000000
	-0.522498565,	//	  477		238.500000000
	-0.515038075,	//	  478		239.000000000
	-0.507538363,	//	  479		239.500000000
	-0.500000000,	//	  480		240.000000000
	-0.492423560,	//	  481		240.500000000
	-0.484809620,	//	  482		241.000000000
	-0.477158760,	//	  483		241.500000000
	-0.469471563,	//	  484		242.000000000
	-0.461748613,	//	  485		242.500000000
	-0.453990500,	//	  486		243.000000000
	-0.446197813,	//	  487		243.500000000
	-0.438371147,	//	  488		244.000000000
	-0.430511097,	//	  489		244.500000000
	-0.422618262,	//	  490		245.000000000
	-0.414693243,	//	  491		245.500000000
	-0.406736643,	//	  492		246.000000000
	-0.398749069,	//	  493		246.500000000
	-0.390731128,	//	  494		247.000000000
	-0.382683432,	//	  495		247.500000000
	-0.374606593,	//	  496		248.000000000
	-0.366501227,	//	  497		248.500000000
	-0.358367950,	//	  498		249.000000000
	-0.350207381,	//	  499		249.500000000
	-0.342020143,	//	  500		250.000000000
	-0.333806859,	//	  501		250.500000000
	-0.325568154,	//	  502		251.000000000
	-0.317304656,	//	  503		251.500000000
	-0.309016994,	//	  504		252.000000000
	-0.300705800,	//	  505		252.500000000
	-0.292371705,	//	  506		253.000000000
	-0.284015345,	//	  507		253.500000000
	-0.275637356,	//	  508		254.000000000
	-0.267238376,	//	  509		254.500000000
	-0.258819045,	//	  510		255.000000000
	-0.250380004,	//	  511		255.500000000
	-0.241921896,	//	  512		256.000000000
	-0.233445364,	//	  513		256.500000000
	-0.224951054,	//	  514		257.000000000
	-0.216439614,	//	  515		257.500000000
	-0.207911691,	//	  516		258.000000000
	-0.199367934,	//	  517		258.500000000
	-0.190808995,	//	  518		259.000000000
	-0.182235525,	//	  519		259.500000000
	-0.173648178,	//	  520		260.000000000
	-0.165047606,	//	  521		260.500000000
	-0.156434465,	//	  522		261.000000000
	-0.147809411,	//	  523		261.500000000
	-0.139173101,	//	  524		262.000000000
	-0.130526192,	//	  525		262.500000000
	-0.121869343,	//	  526		263.000000000
	-0.113203214,	//	  527		263.500000000
	-0.104528463,	//	  528		264.000000000
	-0.095845753,	//	  529		264.500000000
	-0.087155743,	//	  530		265.000000000
	-0.078459096,	//	  531		265.500000000
	-0.069756474,	//	  532		266.000000000
	-0.061048540,	//	  533		266.500000000
	-0.052335956,	//	  534		267.000000000
	-0.043619387,	//	  535		267.500000000
	-0.034899497,	//	  536		268.000000000
	-0.026176948,	//	  537		268.500000000
	-0.017452406,	//	  538		269.000000000
	-0.008726535,	//	  539		269.500000000
	-0.000000000,	//	  540		270.000000000
	0.008726535,	//	  541		270.500000000
	0.017452406,	//	  542		271.000000000
	0.026176948,	//	  543		271.500000000
	0.034899497,	//	  544		272.000000000
	0.043619387,	//	  545		272.500000000
	0.052335956,	//	  546		273.000000000
	0.061048540,	//	  547		273.500000000
	0.069756474,	//	  548		274.000000000
	0.078459096,	//	  549		274.500000000
	0.087155743,	//	  550		275.000000000
	0.095845753,	//	  551		275.500000000
	0.104528463,	//	  552		276.000000000
	0.113203214,	//	  553		276.500000000
	0.121869343,	//	  554		277.000000000
	0.130526192,	//	  555		277.500000000
	0.139173101,	//	  556		278.000000000
	0.147809411,	//	  557		278.500000000
	0.156434465,	//	  558		279.000000000
	0.165047606,	//	  559		279.500000000
	0.173648178,	//	  560		280.000000000
	0.182235525,	//	  561		280.500000000
	0.190808995,	//	  562		281.000000000
	0.199367934,	//	  563		281.500000000
	0.207911691,	//	  564		282.000000000
	0.216439614,	//	  565		282.500000000
	0.224951054,	//	  566		283.000000000
	0.233445364,	//	  567		283.500000000
	0.241921896,	//	  568		284.000000000
	0.250380004,	//	  569		284.500000000
	0.258819045,	//	  570		285.000000000
	0.267238376,	//	  571		285.500000000
	0.275637356,	//	  572		286.000000000
	0.284015345,	//	  573		286.500000000
	0.292371705,	//	  574		287.000000000
	0.300705800,	//	  575		287.500000000
	0.309016994,	//	  576		288.000000000
	0.317304656,	//	  577		288.500000000
	0.325568154,	//	  578		289.000000000
	0.333806859,	//	  579		289.500000000
	0.342020143,	//	  580		290.000000000
	0.350207381,	//	  581		290.500000000
	0.358367950,	//	  582		291.000000000
	0.366501227,	//	  583		291.500000000
	0.374606593,	//	  584		292.000000000
	0.382683432,	//	  585		292.500000000
	0.390731128,	//	  586		293.000000000
	0.398749069,	//	  587		293.500000000
	0.406736643,	//	  588		294.000000000
	0.414693243,	//	  589		294.500000000
	0.422618262,	//	  590		295.000000000
	0.430511097,	//	  591		295.500000000
	0.438371147,	//	  592		296.000000000
	0.446197813,	//	  593		296.500000000
	0.453990500,	//	  594		297.000000000
	0.461748613,	//	  595		297.500000000
	0.469471563,	//	  596		298.000000000
	0.477158760,	//	  597		298.500000000
	0.484809620,	//	  598		299.000000000
	0.492423560,	//	  599		299.500000000
	0.500000000,	//	  600		300.000000000
	0.507538363,	//	  601		300.500000000
	0.515038075,	//	  602		301.000000000
	0.522498565,	//	  603		301.500000000
	0.529919264,	//	  604		302.000000000
	0.537299608,	//	  605		302.500000000
	0.544639035,	//	  606		303.000000000
	0.551936985,	//	  607		303.500000000
	0.559192903,	//	  608		304.000000000
	0.566406237,	//	  609		304.500000000
	0.573576436,	//	  610		305.000000000
	0.580702956,	//	  611		305.500000000
	0.587785252,	//	  612		306.000000000
	0.594822787,	//	  613		306.500000000
	0.601815023,	//	  614		307.000000000
	0.608761429,	//	  615		307.500000000
	0.615661475,	//	  616		308.000000000
	0.622514637,	//	  617		308.500000000
	0.629320391,	//	  618		309.000000000
	0.636078220,	//	  619		309.500000000
	0.642787610,	//	  620		310.000000000
	0.649448048,	//	  621		310.500000000
	0.656059029,	//	  622		311.000000000
	0.662620048,	//	  623		311.500000000
	0.669130606,	//	  624		312.000000000
	0.675590208,	//	  625		312.500000000
	0.681998360,	//	  626		313.000000000
	0.688354576,	//	  627		313.500000000
	0.694658370,	//	  628		314.000000000
	0.700909264,	//	  629		314.500000000
	0.707106781,	//	  630		315.000000000
	0.713250449,	//	  631		315.500000000
	0.719339800,	//	  632		316.000000000
	0.725374371,	//	  633		316.500000000
	0.731353702,	//	  634		317.000000000
	0.737277337,	//	  635		317.500000000
	0.743144825,	//	  636		318.000000000
	0.748955721,	//	  637		318.500000000
	0.754709580,	//	  638		319.000000000
	0.760405966,	//	  639		319.500000000
	0.766044443,	//	  640		320.000000000
	0.771624583,	//	  641		320.500000000
	0.777145961,	//	  642		321.000000000
	0.782608157,	//	  643		321.500000000
	0.788010754,	//	  644		322.000000000
	0.793353340,	//	  645		322.500000000
	0.798635510,	//	  646		323.000000000
	0.803856861,	//	  647		323.500000000
	0.809016994,	//	  648		324.000000000
	0.814115518,	//	  649		324.500000000
	0.819152044,	//	  650		325.000000000
	0.824126189,	//	  651		325.500000000
	0.829037573,	//	  652		326.000000000
	0.833885822,	//	  653		326.500000000
	0.838670568,	//	  654		327.000000000
	0.843391446,	//	  655		327.500000000
	0.848048096,	//	  656		328.000000000
	0.852640164,	//	  657		328.500000000
	0.857167301,	//	  658		329.000000000
	0.861629160,	//	  659		329.500000000
	0.866025404,	//	  660		330.000000000
	0.870355696,	//	  661		330.500000000
	0.874619707,	//	  662		331.000000000
	0.878817113,	//	  663		331.500000000
	0.882947593,	//	  664		332.000000000
	0.887010833,	//	  665		332.500000000
	0.891006524,	//	  666		333.000000000
	0.894934362,	//	  667		333.500000000
	0.898794046,	//	  668		334.000000000
	0.902585284,	//	  669		334.500000000
	0.906307787,	//	  670		335.000000000
	0.909961271,	//	  671		335.500000000
	0.913545458,	//	  672		336.000000000
	0.917060074,	//	  673		336.500000000
	0.920504853,	//	  674		337.000000000
	0.923879533,	//	  675		337.500000000
	0.927183855,	//	  676		338.000000000
	0.930417568,	//	  677		338.500000000
	0.933580426,	//	  678		339.000000000
	0.936672189,	//	  679		339.500000000
	0.939692621,	//	  680		340.000000000
	0.942641491,	//	  681		340.500000000
	0.945518576,	//	  682		341.000000000
	0.948323655,	//	  683		341.500000000
	0.951056516,	//	  684		342.000000000
	0.953716951,	//	  685		342.500000000
	0.956304756,	//	  686		343.000000000
	0.958819735,	//	  687		343.500000000
	0.961261696,	//	  688		344.000000000
	0.963630453,	//	  689		344.500000000
	0.965925826,	//	  690		345.000000000
	0.968147640,	//	  691		345.500000000
	0.970295726,	//	  692		346.000000000
	0.972369920,	//	  693		346.500000000
	0.974370065,	//	  694		347.000000000
	0.976296007,	//	  695		347.500000000
	0.978147601,	//	  696		348.000000000
	0.979924705,	//	  697		348.500000000
	0.981627183,	//	  698		349.000000000
	0.983254908,	//	  699		349.500000000
	0.984807753,	//	  700		350.000000000
	0.986285602,	//	  701		350.499999999
	0.987688341,	//	  702		350.999999999
	0.989015863,	//	  703		351.499999999
	0.990268069,	//	  704		351.999999999
	0.991444861,	//	  705		352.499999999
	0.992546152,	//	  706		352.999999999
	0.993571856,	//	  707		353.499999999
	0.994521895,	//	  708		353.999999999
	0.995396198,	//	  709		354.499999999
	0.996194698,	//	  710		354.999999999
	0.996917334,	//	  711		355.499999999
	0.997564050,	//	  712		355.999999999
	0.998134798,	//	  713		356.499999999
	0.998629535,	//	  714		356.999999999
	0.999048222,	//	  715		357.499999999
	0.999390827,	//	  716		357.999999999
	0.999657325,	//	  717		358.499999999
	0.999847695,	//	  718		358.999999999
	0.999961923,	//	  719		359.499999999
	1.000000000,	//	  720		359.999999999 
};

