/* =================================================================================
File name:      SIN_TAB.H                     
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description: 
Header file containing 360 entries look-up table for sin(ang) in actual value 

=====================================================================================
 History:
-------------------------------------------------------------------------------------
 07-13-2011	Version 1.20a                                                  
------------------------------------------------------------------------------ */

#include "dmctype.h"

const float32 sin_tab[] =
{   	//Sine					Index	Angle   360/720=0.5
	0.000000000,	//	    0		0.000000000
	0.008726535,	//	    1		0.500000000
	0.017452406,	//	    2		1.000000000
	0.026176948,	//	    3		1.500000000
	0.034899497,	//	    4		2.000000000
	0.043619387,	//	    5		2.500000000
	0.052335956,	//	    6		3.000000000
	0.061048540,	//	    7		3.500000000
	0.069756474,	//	    8		4.000000000
	0.078459096,	//	    9		4.500000000
	0.087155743,	//	   10		5.000000000
	0.095845753,	//	   11		5.500000000
	0.104528463,	//	   12		6.000000000
	0.113203214,	//	   13		6.500000000
	0.121869343,	//	   14		7.000000000
	0.130526192,	//	   15		7.500000000
	0.139173101,	//	   16		8.000000000
	0.147809411,	//	   17		8.500000000
	0.156434465,	//	   18		9.000000000
	0.165047606,	//	   19		9.500000000
	0.173648178,	//	   20		10.000000000
	0.182235525,	//	   21		10.500000000
	0.190808995,	//	   22		11.000000000
	0.199367934,	//	   23		11.500000000
	0.207911691,	//	   24		12.000000000
	0.216439614,	//	   25		12.500000000
	0.224951054,	//	   26		13.000000000
	0.233445364,	//	   27		13.500000000
	0.241921896,	//	   28		14.000000000
	0.250380004,	//	   29		14.500000000
	0.258819045,	//	   30		15.000000000
	0.267238376,	//	   31		15.500000000
	0.275637356,	//	   32		16.000000000
	0.284015345,	//	   33		16.500000000
	0.292371705,	//	   34		17.000000000
	0.300705800,	//	   35		17.500000000
	0.309016994,	//	   36		18.000000000
	0.317304656,	//	   37		18.500000000
	0.325568154,	//	   38		19.000000000
	0.333806859,	//	   39		19.500000000
	0.342020143,	//	   40		20.000000000
	0.350207381,	//	   41		20.500000000
	0.358367950,	//	   42		21.000000000
	0.366501227,	//	   43		21.500000000
	0.374606593,	//	   44		22.000000000
	0.382683432,	//	   45		22.500000000
	0.390731128,	//	   46		23.000000000
	0.398749069,	//	   47		23.500000000
	0.406736643,	//	   48		24.000000000
	0.414693243,	//	   49		24.500000000
	0.422618262,	//	   50		25.000000000
	0.430511097,	//	   51		25.500000000
	0.438371147,	//	   52		26.000000000
	0.446197813,	//	   53		26.500000000
	0.453990500,	//	   54		27.000000000
	0.461748613,	//	   55		27.500000000
	0.469471563,	//	   56		28.000000000
	0.477158760,	//	   57		28.500000000
	0.484809620,	//	   58		29.000000000
	0.492423560,	//	   59		29.500000000
	0.500000000,	//	   60		30.000000000
	0.507538363,	//	   61		30.500000000
	0.515038075,	//	   62		31.000000000
	0.522498565,	//	   63		31.500000000
	0.529919264,	//	   64		32.000000000
	0.537299608,	//	   65		32.500000000
	0.544639035,	//	   66		33.000000000
	0.551936985,	//	   67		33.500000000
	0.559192903,	//	   68		34.000000000
	0.566406237,	//	   69		34.500000000
	0.573576436,	//	   70		35.000000000
	0.580702956,	//	   71		35.500000000
	0.587785252,	//	   72		36.000000000
	0.594822787,	//	   73		36.500000000
	0.601815023,	//	   74		37.000000000
	0.608761429,	//	   75		37.500000000
	0.615661475,	//	   76		38.000000000
	0.622514637,	//	   77		38.500000000
	0.629320391,	//	   78		39.000000000
	0.636078220,	//	   79		39.500000000
	0.642787610,	//	   80		40.000000000
	0.649448048,	//	   81		40.500000000
	0.656059029,	//	   82		41.000000000
	0.662620048,	//	   83		41.500000000
	0.669130606,	//	   84		42.000000000
	0.675590208,	//	   85		42.500000000
	0.681998360,	//	   86		43.000000000
	0.688354576,	//	   87		43.500000000
	0.694658370,	//	   88		44.000000000
	0.700909264,	//	   89		44.500000000
	0.707106781,	//	   90		45.000000000
	0.713250449,	//	   91		45.500000000
	0.719339800,	//	   92		46.000000000
	0.725374371,	//	   93		46.500000000
	0.731353702,	//	   94		47.000000000
	0.737277337,	//	   95		47.500000000
	0.743144825,	//	   96		48.000000000
	0.748955721,	//	   97		48.500000000
	0.754709580,	//	   98		49.000000000
	0.760405966,	//	   99		49.500000000
	0.766044443,	//	  100		50.000000000
	0.771624583,	//	  101		50.500000000
	0.777145961,	//	  102		51.000000000
	0.782608157,	//	  103		51.500000000
	0.788010754,	//	  104		52.000000000
	0.793353340,	//	  105		52.500000000
	0.798635510,	//	  106		53.000000000
	0.803856861,	//	  107		53.500000000
	0.809016994,	//	  108		54.000000000
	0.814115518,	//	  109		54.500000000
	0.819152044,	//	  110		55.000000000
	0.824126189,	//	  111		55.500000000
	0.829037573,	//	  112		56.000000000
	0.833885822,	//	  113		56.500000000
	0.838670568,	//	  114		57.000000000
	0.843391446,	//	  115		57.500000000
	0.848048096,	//	  116		58.000000000
	0.852640164,	//	  117		58.500000000
	0.857167301,	//	  118		59.000000000
	0.861629160,	//	  119		59.500000000
	0.866025404,	//	  120		60.000000000
	0.870355696,	//	  121		60.500000000
	0.874619707,	//	  122		61.000000000
	0.878817113,	//	  123		61.500000000
	0.882947593,	//	  124		62.000000000
	0.887010833,	//	  125		62.500000000
	0.891006524,	//	  126		63.000000000
	0.894934362,	//	  127		63.500000000
	0.898794046,	//	  128		64.000000000
	0.902585284,	//	  129		64.500000000
	0.906307787,	//	  130		65.000000000
	0.909961271,	//	  131		65.500000000
	0.913545458,	//	  132		66.000000000
	0.917060074,	//	  133		66.500000000
	0.920504853,	//	  134		67.000000000
	0.923879533,	//	  135		67.500000000
	0.927183855,	//	  136		68.000000000
	0.930417568,	//	  137		68.500000000
	0.933580426,	//	  138		69.000000000
	0.936672189,	//	  139		69.500000000
	0.939692621,	//	  140		70.000000000
	0.942641491,	//	  141		70.500000000
	0.945518576,	//	  142		71.000000000
	0.948323655,	//	  143		71.500000000
	0.951056516,	//	  144		72.000000000
	0.953716951,	//	  145		72.500000000
	0.956304756,	//	  146		73.000000000
	0.958819735,	//	  147		73.500000000
	0.961261696,	//	  148		74.000000000
	0.963630453,	//	  149		74.500000000
	0.965925826,	//	  150		75.000000000
	0.968147640,	//	  151		75.500000000
	0.970295726,	//	  152		76.000000000
	0.972369920,	//	  153		76.500000000
	0.974370065,	//	  154		77.000000000
	0.976296007,	//	  155		77.500000000
	0.978147601,	//	  156		78.000000000
	0.979924705,	//	  157		78.500000000
	0.981627183,	//	  158		79.000000000
	0.983254908,	//	  159		79.500000000
	0.984807753,	//	  160		80.000000000
	0.986285602,	//	  161		80.500000000
	0.987688341,	//	  162		81.000000000
	0.989015863,	//	  163		81.500000000
	0.990268069,	//	  164		82.000000000
	0.991444861,	//	  165		82.500000000
	0.992546152,	//	  166		83.000000000
	0.993571856,	//	  167		83.500000000
	0.994521895,	//	  168		84.000000000
	0.995396198,	//	  169		84.500000000
	0.996194698,	//	  170		85.000000000
	0.996917334,	//	  171		85.500000000
	0.997564050,	//	  172		86.000000000
	0.998134798,	//	  173		86.500000000
	0.998629535,	//	  174		87.000000000
	0.999048222,	//	  175		87.500000000
	0.999390827,	//	  176		88.000000000
	0.999657325,	//	  177		88.500000000
	0.999847695,	//	  178		89.000000000
	0.999961923,	//	  179		89.500000000
	1.000000000,	//	  180		90.000000000
	0.999961923,	//	  181		90.500000000
	0.999847695,	//	  182		91.000000000
	0.999657325,	//	  183		91.500000000
	0.999390827,	//	  184		92.000000000
	0.999048222,	//	  185		92.500000000
	0.998629535,	//	  186		93.000000000
	0.998134798,	//	  187		93.500000000
	0.997564050,	//	  188		94.000000000
	0.996917334,	//	  189		94.500000000
	0.996194698,	//	  190		95.000000000
	0.995396198,	//	  191		95.500000000
	0.994521895,	//	  192		96.000000000
	0.993571856,	//	  193		96.500000000
	0.992546152,	//	  194		97.000000000
	0.991444861,	//	  195		97.500000000
	0.990268069,	//	  196		98.000000000
	0.989015863,	//	  197		98.500000000
	0.987688341,	//	  198		99.000000000
	0.986285602,	//	  199		99.500000000
	0.984807753,	//	  200		100.000000000
	0.983254908,	//	  201		100.500000000
	0.981627183,	//	  202		101.000000000
	0.979924705,	//	  203		101.500000000
	0.978147601,	//	  204		102.000000000
	0.976296007,	//	  205		102.500000000
	0.974370065,	//	  206		103.000000000
	0.972369920,	//	  207		103.500000000
	0.970295726,	//	  208		104.000000000
	0.968147640,	//	  209		104.500000000
	0.965925826,	//	  210		105.000000000
	0.963630453,	//	  211		105.500000000
	0.961261696,	//	  212		106.000000000
	0.958819735,	//	  213		106.500000000
	0.956304756,	//	  214		107.000000000
	0.953716951,	//	  215		107.500000000
	0.951056516,	//	  216		108.000000000
	0.948323655,	//	  217		108.500000000
	0.945518576,	//	  218		109.000000000
	0.942641491,	//	  219		109.500000000
	0.939692621,	//	  220		110.000000000
	0.936672189,	//	  221		110.500000000
	0.933580426,	//	  222		111.000000000
	0.930417568,	//	  223		111.500000000
	0.927183855,	//	  224		112.000000000
	0.923879533,	//	  225		112.500000000
	0.920504853,	//	  226		113.000000000
	0.917060074,	//	  227		113.500000000
	0.913545458,	//	  228		114.000000000
	0.909961271,	//	  229		114.500000000
	0.906307787,	//	  230		115.000000000
	0.902585284,	//	  231		115.500000000
	0.898794046,	//	  232		116.000000000
	0.894934362,	//	  233		116.500000000
	0.891006524,	//	  234		117.000000000
	0.887010833,	//	  235		117.500000000
	0.882947593,	//	  236		118.000000000
	0.878817113,	//	  237		118.500000000
	0.874619707,	//	  238		119.000000000
	0.870355696,	//	  239		119.500000000
	0.866025404,	//	  240		120.000000000
	0.861629160,	//	  241		120.500000000
	0.857167301,	//	  242		121.000000000
	0.852640164,	//	  243		121.500000000
	0.848048096,	//	  244		122.000000000
	0.843391446,	//	  245		122.500000000
	0.838670568,	//	  246		123.000000000
	0.833885822,	//	  247		123.500000000
	0.829037573,	//	  248		124.000000000
	0.824126189,	//	  249		124.500000000
	0.819152044,	//	  250		125.000000000
	0.814115518,	//	  251		125.500000000
	0.809016994,	//	  252		126.000000000
	0.803856861,	//	  253		126.500000000
	0.798635510,	//	  254		127.000000000
	0.793353340,	//	  255		127.500000000
	0.788010754,	//	  256		128.000000000
	0.782608157,	//	  257		128.500000000
	0.777145961,	//	  258		129.000000000
	0.771624583,	//	  259		129.500000000
	0.766044443,	//	  260		130.000000000
	0.760405966,	//	  261		130.500000000
	0.754709580,	//	  262		131.000000000
	0.748955721,	//	  263		131.500000000
	0.743144825,	//	  264		132.000000000
	0.737277337,	//	  265		132.500000000
	0.731353702,	//	  266		133.000000000
	0.725374371,	//	  267		133.500000000
	0.719339800,	//	  268		134.000000000
	0.713250449,	//	  269		134.500000000
	0.707106781,	//	  270		135.000000000
	0.700909264,	//	  271		135.500000000
	0.694658370,	//	  272		136.000000000
	0.688354576,	//	  273		136.500000000
	0.681998360,	//	  274		137.000000000
	0.675590208,	//	  275		137.500000000
	0.669130606,	//	  276		138.000000000
	0.662620048,	//	  277		138.500000000
	0.656059029,	//	  278		139.000000000
	0.649448048,	//	  279		139.500000000
	0.642787610,	//	  280		140.000000000
	0.636078220,	//	  281		140.500000000
	0.629320391,	//	  282		141.000000000
	0.622514637,	//	  283		141.500000000
	0.615661475,	//	  284		142.000000000
	0.608761429,	//	  285		142.500000000
	0.601815023,	//	  286		143.000000000
	0.594822787,	//	  287		143.500000000
	0.587785252,	//	  288		144.000000000
	0.580702956,	//	  289		144.500000000
	0.573576436,	//	  290		145.000000000
	0.566406237,	//	  291		145.500000000
	0.559192903,	//	  292		146.000000000
	0.551936985,	//	  293		146.500000000
	0.544639035,	//	  294		147.000000000
	0.537299608,	//	  295		147.500000000
	0.529919264,	//	  296		148.000000000
	0.522498565,	//	  297		148.500000000
	0.515038075,	//	  298		149.000000000
	0.507538363,	//	  299		149.500000000
	0.500000000,	//	  300		150.000000000
	0.492423560,	//	  301		150.500000000
	0.484809620,	//	  302		151.000000000
	0.477158760,	//	  303		151.500000000
	0.469471563,	//	  304		152.000000000
	0.461748613,	//	  305		152.500000000
	0.453990500,	//	  306		153.000000000
	0.446197813,	//	  307		153.500000000
	0.438371147,	//	  308		154.000000000
	0.430511097,	//	  309		154.500000000
	0.422618262,	//	  310		155.000000000
	0.414693243,	//	  311		155.500000000
	0.406736643,	//	  312		156.000000000
	0.398749069,	//	  313		156.500000000
	0.390731128,	//	  314		157.000000000
	0.382683432,	//	  315		157.500000000
	0.374606593,	//	  316		158.000000000
	0.366501227,	//	  317		158.500000000
	0.358367950,	//	  318		159.000000000
	0.350207381,	//	  319		159.500000000
	0.342020143,	//	  320		160.000000000
	0.333806859,	//	  321		160.500000000
	0.325568154,	//	  322		161.000000000
	0.317304656,	//	  323		161.500000000
	0.309016994,	//	  324		162.000000000
	0.300705800,	//	  325		162.500000000
	0.292371705,	//	  326		163.000000000
	0.284015345,	//	  327		163.500000000
	0.275637356,	//	  328		164.000000000
	0.267238376,	//	  329		164.500000000
	0.258819045,	//	  330		165.000000000
	0.250380004,	//	  331		165.500000000
	0.241921896,	//	  332		166.000000000
	0.233445364,	//	  333		166.500000000
	0.224951054,	//	  334		167.000000000
	0.216439614,	//	  335		167.500000000
	0.207911691,	//	  336		168.000000000
	0.199367934,	//	  337		168.500000000
	0.190808995,	//	  338		169.000000000
	0.182235525,	//	  339		169.500000000
	0.173648178,	//	  340		170.000000000
	0.165047606,	//	  341		170.500000000
	0.156434465,	//	  342		171.000000000
	0.147809411,	//	  343		171.500000000
	0.139173101,	//	  344		172.000000000
	0.130526192,	//	  345		172.500000000
	0.121869343,	//	  346		173.000000000
	0.113203214,	//	  347		173.500000000
	0.104528463,	//	  348		174.000000000
	0.095845753,	//	  349		174.500000000
	0.087155743,	//	  350		175.000000000
	0.078459096,	//	  351		175.500000000
	0.069756474,	//	  352		176.000000000
	0.061048540,	//	  353		176.500000000
	0.052335956,	//	  354		177.000000000
	0.043619387,	//	  355		177.500000000
	0.034899497,	//	  356		178.000000000
	0.026176948,	//	  357		178.500000000
	0.017452406,	//	  358		179.000000000
	0.008726535,	//	  359		179.500000000
	0.000000000,	//	  360		180.000000000
	-0.008726535,	//	  361		180.500000000
	-0.017452406,	//	  362		181.000000000
	-0.026176948,	//	  363		181.500000000
	-0.034899497,	//	  364		182.000000000
	-0.043619387,	//	  365		182.500000000
	-0.052335956,	//	  366		183.000000000
	-0.061048540,	//	  367		183.500000000
	-0.069756474,	//	  368		184.000000000
	-0.078459096,	//	  369		184.500000000
	-0.087155743,	//	  370		185.000000000
	-0.095845753,	//	  371		185.500000000
	-0.104528463,	//	  372		186.000000000
	-0.113203214,	//	  373		186.500000000
	-0.121869343,	//	  374		187.000000000
	-0.130526192,	//	  375		187.500000000
	-0.139173101,	//	  376		188.000000000
	-0.147809411,	//	  377		188.500000000
	-0.156434465,	//	  378		189.000000000
	-0.165047606,	//	  379		189.500000000
	-0.173648178,	//	  380		190.000000000
	-0.182235525,	//	  381		190.500000000
	-0.190808995,	//	  382		191.000000000
	-0.199367934,	//	  383		191.500000000
	-0.207911691,	//	  384		192.000000000
	-0.216439614,	//	  385		192.500000000
	-0.224951054,	//	  386		193.000000000
	-0.233445364,	//	  387		193.500000000
	-0.241921896,	//	  388		194.000000000
	-0.250380004,	//	  389		194.500000000
	-0.258819045,	//	  390		195.000000000
	-0.267238376,	//	  391		195.500000000
	-0.275637356,	//	  392		196.000000000
	-0.284015345,	//	  393		196.500000000
	-0.292371705,	//	  394		197.000000000
	-0.300705800,	//	  395		197.500000000
	-0.309016994,	//	  396		198.000000000
	-0.317304656,	//	  397		198.500000000
	-0.325568154,	//	  398		199.000000000
	-0.333806859,	//	  399		199.500000000
	-0.342020143,	//	  400		200.000000000
	-0.350207381,	//	  401		200.500000000
	-0.358367950,	//	  402		201.000000000
	-0.366501227,	//	  403		201.500000000
	-0.374606593,	//	  404		202.000000000
	-0.382683432,	//	  405		202.500000000
	-0.390731128,	//	  406		203.000000000
	-0.398749069,	//	  407		203.500000000
	-0.406736643,	//	  408		204.000000000
	-0.414693243,	//	  409		204.500000000
	-0.422618262,	//	  410		205.000000000
	-0.430511097,	//	  411		205.500000000
	-0.438371147,	//	  412		206.000000000
	-0.446197813,	//	  413		206.500000000
	-0.453990500,	//	  414		207.000000000
	-0.461748613,	//	  415		207.500000000
	-0.469471563,	//	  416		208.000000000
	-0.477158760,	//	  417		208.500000000
	-0.484809620,	//	  418		209.000000000
	-0.492423560,	//	  419		209.500000000
	-0.500000000,	//	  420		210.000000000
	-0.507538363,	//	  421		210.500000000
	-0.515038075,	//	  422		211.000000000
	-0.522498565,	//	  423		211.500000000
	-0.529919264,	//	  424		212.000000000
	-0.537299608,	//	  425		212.500000000
	-0.544639035,	//	  426		213.000000000
	-0.551936985,	//	  427		213.500000000
	-0.559192903,	//	  428		214.000000000
	-0.566406237,	//	  429		214.500000000
	-0.573576436,	//	  430		215.000000000
	-0.580702956,	//	  431		215.500000000
	-0.587785252,	//	  432		216.000000000
	-0.594822787,	//	  433		216.500000000
	-0.601815023,	//	  434		217.000000000
	-0.608761429,	//	  435		217.500000000
	-0.615661475,	//	  436		218.000000000
	-0.622514637,	//	  437		218.500000000
	-0.629320391,	//	  438		219.000000000
	-0.636078220,	//	  439		219.500000000
	-0.642787610,	//	  440		220.000000000
	-0.649448048,	//	  441		220.500000000
	-0.656059029,	//	  442		221.000000000
	-0.662620048,	//	  443		221.500000000
	-0.669130606,	//	  444		222.000000000
	-0.675590208,	//	  445		222.500000000
	-0.681998360,	//	  446		223.000000000
	-0.688354576,	//	  447		223.500000000
	-0.694658370,	//	  448		224.000000000
	-0.700909264,	//	  449		224.500000000
	-0.707106781,	//	  450		225.000000000
	-0.713250449,	//	  451		225.500000000
	-0.719339800,	//	  452		226.000000000
	-0.725374371,	//	  453		226.500000000
	-0.731353702,	//	  454		227.000000000
	-0.737277337,	//	  455		227.500000000
	-0.743144825,	//	  456		228.000000000
	-0.748955721,	//	  457		228.500000000
	-0.754709580,	//	  458		229.000000000
	-0.760405966,	//	  459		229.500000000
	-0.766044443,	//	  460		230.000000000
	-0.771624583,	//	  461		230.500000000
	-0.777145961,	//	  462		231.000000000
	-0.782608157,	//	  463		231.500000000
	-0.788010754,	//	  464		232.000000000
	-0.793353340,	//	  465		232.500000000
	-0.798635510,	//	  466		233.000000000
	-0.803856861,	//	  467		233.500000000
	-0.809016994,	//	  468		234.000000000
	-0.814115518,	//	  469		234.500000000
	-0.819152044,	//	  470		235.000000000
	-0.824126189,	//	  471		235.500000000
	-0.829037573,	//	  472		236.000000000
	-0.833885822,	//	  473		236.500000000
	-0.838670568,	//	  474		237.000000000
	-0.843391446,	//	  475		237.500000000
	-0.848048096,	//	  476		238.000000000
	-0.852640164,	//	  477		238.500000000
	-0.857167301,	//	  478		239.000000000
	-0.861629160,	//	  479		239.500000000
	-0.866025404,	//	  480		240.000000000
	-0.870355696,	//	  481		240.500000000
	-0.874619707,	//	  482		241.000000000
	-0.878817113,	//	  483		241.500000000
	-0.882947593,	//	  484		242.000000000
	-0.887010833,	//	  485		242.500000000
	-0.891006524,	//	  486		243.000000000
	-0.894934362,	//	  487		243.500000000
	-0.898794046,	//	  488		244.000000000
	-0.902585284,	//	  489		244.500000000
	-0.906307787,	//	  490		245.000000000
	-0.909961271,	//	  491		245.500000000
	-0.913545458,	//	  492		246.000000000
	-0.917060074,	//	  493		246.500000000
	-0.920504853,	//	  494		247.000000000
	-0.923879533,	//	  495		247.500000000
	-0.927183855,	//	  496		248.000000000
	-0.930417568,	//	  497		248.500000000
	-0.933580426,	//	  498		249.000000000
	-0.936672189,	//	  499		249.500000000
	-0.939692621,	//	  500		250.000000000
	-0.942641491,	//	  501		250.500000000
	-0.945518576,	//	  502		251.000000000
	-0.948323655,	//	  503		251.500000000
	-0.951056516,	//	  504		252.000000000
	-0.953716951,	//	  505		252.500000000
	-0.956304756,	//	  506		253.000000000
	-0.958819735,	//	  507		253.500000000
	-0.961261696,	//	  508		254.000000000
	-0.963630453,	//	  509		254.500000000
	-0.965925826,	//	  510		255.000000000
	-0.968147640,	//	  511		255.500000000
	-0.970295726,	//	  512		256.000000000
	-0.972369920,	//	  513		256.500000000
	-0.974370065,	//	  514		257.000000000
	-0.976296007,	//	  515		257.500000000
	-0.978147601,	//	  516		258.000000000
	-0.979924705,	//	  517		258.500000000
	-0.981627183,	//	  518		259.000000000
	-0.983254908,	//	  519		259.500000000
	-0.984807753,	//	  520		260.000000000
	-0.986285602,	//	  521		260.500000000
	-0.987688341,	//	  522		261.000000000
	-0.989015863,	//	  523		261.500000000
	-0.990268069,	//	  524		262.000000000
	-0.991444861,	//	  525		262.500000000
	-0.992546152,	//	  526		263.000000000
	-0.993571856,	//	  527		263.500000000
	-0.994521895,	//	  528		264.000000000
	-0.995396198,	//	  529		264.500000000
	-0.996194698,	//	  530		265.000000000
	-0.996917334,	//	  531		265.500000000
	-0.997564050,	//	  532		266.000000000
	-0.998134798,	//	  533		266.500000000
	-0.998629535,	//	  534		267.000000000
	-0.999048222,	//	  535		267.500000000
	-0.999390827,	//	  536		268.000000000
	-0.999657325,	//	  537		268.500000000
	-0.999847695,	//	  538		269.000000000
	-0.999961923,	//	  539		269.500000000
	-1.000000000,	//	  540		270.000000000
	-0.999961923,	//	  541		270.500000000
	-0.999847695,	//	  542		271.000000000
	-0.999657325,	//	  543		271.500000000
	-0.999390827,	//	  544		272.000000000
	-0.999048222,	//	  545		272.500000000
	-0.998629535,	//	  546		273.000000000
	-0.998134798,	//	  547		273.500000000
	-0.997564050,	//	  548		274.000000000
	-0.996917334,	//	  549		274.500000000
	-0.996194698,	//	  550		275.000000000
	-0.995396198,	//	  551		275.500000000
	-0.994521895,	//	  552		276.000000000
	-0.993571856,	//	  553		276.500000000
	-0.992546152,	//	  554		277.000000000
	-0.991444861,	//	  555		277.500000000
	-0.990268069,	//	  556		278.000000000
	-0.989015863,	//	  557		278.500000000
	-0.987688341,	//	  558		279.000000000
	-0.986285602,	//	  559		279.500000000
	-0.984807753,	//	  560		280.000000000
	-0.983254908,	//	  561		280.500000000
	-0.981627183,	//	  562		281.000000000
	-0.979924705,	//	  563		281.500000000
	-0.978147601,	//	  564		282.000000000
	-0.976296007,	//	  565		282.500000000
	-0.974370065,	//	  566		283.000000000
	-0.972369920,	//	  567		283.500000000
	-0.970295726,	//	  568		284.000000000
	-0.968147640,	//	  569		284.500000000
	-0.965925826,	//	  570		285.000000000
	-0.963630453,	//	  571		285.500000000
	-0.961261696,	//	  572		286.000000000
	-0.958819735,	//	  573		286.500000000
	-0.956304756,	//	  574		287.000000000
	-0.953716951,	//	  575		287.500000000
	-0.951056516,	//	  576		288.000000000
	-0.948323655,	//	  577		288.500000000
	-0.945518576,	//	  578		289.000000000
	-0.942641491,	//	  579		289.500000000
	-0.939692621,	//	  580		290.000000000
	-0.936672189,	//	  581		290.500000000
	-0.933580426,	//	  582		291.000000000
	-0.930417568,	//	  583		291.500000000
	-0.927183855,	//	  584		292.000000000
	-0.923879533,	//	  585		292.500000000
	-0.920504853,	//	  586		293.000000000
	-0.917060074,	//	  587		293.500000000
	-0.913545458,	//	  588		294.000000000
	-0.909961271,	//	  589		294.500000000
	-0.906307787,	//	  590		295.000000000
	-0.902585284,	//	  591		295.500000000
	-0.898794046,	//	  592		296.000000000
	-0.894934362,	//	  593		296.500000000
	-0.891006524,	//	  594		297.000000000
	-0.887010833,	//	  595		297.500000000
	-0.882947593,	//	  596		298.000000000
	-0.878817113,	//	  597		298.500000000
	-0.874619707,	//	  598		299.000000000
	-0.870355696,	//	  599		299.500000000
	-0.866025404,	//	  600		300.000000000
	-0.861629160,	//	  601		300.500000000
	-0.857167301,	//	  602		301.000000000
	-0.852640164,	//	  603		301.500000000
	-0.848048096,	//	  604		302.000000000
	-0.843391446,	//	  605		302.500000000
	-0.838670568,	//	  606		303.000000000
	-0.833885822,	//	  607		303.500000000
	-0.829037573,	//	  608		304.000000000
	-0.824126189,	//	  609		304.500000000
	-0.819152044,	//	  610		305.000000000
	-0.814115518,	//	  611		305.500000000
	-0.809016994,	//	  612		306.000000000
	-0.803856861,	//	  613		306.500000000
	-0.798635510,	//	  614		307.000000000
	-0.793353340,	//	  615		307.500000000
	-0.788010754,	//	  616		308.000000000
	-0.782608157,	//	  617		308.500000000
	-0.777145961,	//	  618		309.000000000
	-0.771624583,	//	  619		309.500000000
	-0.766044443,	//	  620		310.000000000
	-0.760405966,	//	  621		310.500000000
	-0.754709580,	//	  622		311.000000000
	-0.748955721,	//	  623		311.500000000
	-0.743144825,	//	  624		312.000000000
	-0.737277337,	//	  625		312.500000000
	-0.731353702,	//	  626		313.000000000
	-0.725374371,	//	  627		313.500000000
	-0.719339800,	//	  628		314.000000000
	-0.713250449,	//	  629		314.500000000
	-0.707106781,	//	  630		315.000000000
	-0.700909264,	//	  631		315.500000000
	-0.694658370,	//	  632		316.000000000
	-0.688354576,	//	  633		316.500000000
	-0.681998360,	//	  634		317.000000000
	-0.675590208,	//	  635		317.500000000
	-0.669130606,	//	  636		318.000000000
	-0.662620048,	//	  637		318.500000000
	-0.656059029,	//	  638		319.000000000
	-0.649448048,	//	  639		319.500000000
	-0.642787610,	//	  640		320.000000000
	-0.636078220,	//	  641		320.500000000
	-0.629320391,	//	  642		321.000000000
	-0.622514637,	//	  643		321.500000000
	-0.615661475,	//	  644		322.000000000
	-0.608761429,	//	  645		322.500000000
	-0.601815023,	//	  646		323.000000000
	-0.594822787,	//	  647		323.500000000
	-0.587785252,	//	  648		324.000000000
	-0.580702956,	//	  649		324.500000000
	-0.573576436,	//	  650		325.000000000
	-0.566406237,	//	  651		325.500000000
	-0.559192903,	//	  652		326.000000000
	-0.551936985,	//	  653		326.500000000
	-0.544639035,	//	  654		327.000000000
	-0.537299608,	//	  655		327.500000000
	-0.529919264,	//	  656		328.000000000
	-0.522498565,	//	  657		328.500000000
	-0.515038075,	//	  658		329.000000000
	-0.507538363,	//	  659		329.500000000
	-0.500000000,	//	  660		330.000000000
	-0.492423560,	//	  661		330.500000000
	-0.484809620,	//	  662		331.000000000
	-0.477158760,	//	  663		331.500000000
	-0.469471563,	//	  664		332.000000000
	-0.461748613,	//	  665		332.500000000
	-0.453990500,	//	  666		333.000000000
	-0.446197813,	//	  667		333.500000000
	-0.438371147,	//	  668		334.000000000
	-0.430511097,	//	  669		334.500000000
	-0.422618262,	//	  670		335.000000000
	-0.414693243,	//	  671		335.500000000
	-0.406736643,	//	  672		336.000000000
	-0.398749069,	//	  673		336.500000000
	-0.390731128,	//	  674		337.000000000
	-0.382683432,	//	  675		337.500000000
	-0.374606593,	//	  676		338.000000000
	-0.366501227,	//	  677		338.500000000
	-0.358367950,	//	  678		339.000000000
	-0.350207381,	//	  679		339.500000000
	-0.342020143,	//	  680		340.000000000
	-0.333806859,	//	  681		340.500000000
	-0.325568154,	//	  682		341.000000000
	-0.317304656,	//	  683		341.500000000
	-0.309016994,	//	  684		342.000000000
	-0.300705800,	//	  685		342.500000000
	-0.292371705,	//	  686		343.000000000
	-0.284015345,	//	  687		343.500000000
	-0.275637356,	//	  688		344.000000000
	-0.267238376,	//	  689		344.500000000
	-0.258819045,	//	  690		345.000000000
	-0.250380004,	//	  691		345.500000000
	-0.241921896,	//	  692		346.000000000
	-0.233445364,	//	  693		346.500000000
	-0.224951054,	//	  694		347.000000000
	-0.216439614,	//	  695		347.500000000
	-0.207911691,	//	  696		348.000000000
	-0.199367934,	//	  697		348.500000000
	-0.190808995,	//	  698		349.000000000
	-0.182235525,	//	  699		349.500000000
	-0.173648178,	//	  700		350.000000000
	-0.165047606,	//	  701		350.499999999
	-0.156434465,	//	  702		350.999999999
	-0.147809411,	//	  703		351.499999999
	-0.139173101,	//	  704		351.999999999
	-0.130526192,	//	  705		352.499999999
	-0.121869343,	//	  706		352.999999999
	-0.113203214,	//	  707		353.499999999
	-0.104528463,	//	  708		353.999999999
	-0.095845753,	//	  709		354.499999999
	-0.087155743,	//	  710		354.999999999
	-0.078459096,	//	  711		355.499999999
	-0.069756474,	//	  712		355.999999999
	-0.061048540,	//	  713		356.499999999
	-0.052335956,	//	  714		356.999999999
	-0.043619387,	//	  715		357.499999999
	-0.034899497,	//	  716		357.999999999
	-0.026176948,	//	  717		358.499999999
	-0.017452406,	//	  718		358.999999999
	-0.008726535,	//	  719		359.499999999
	0.000000000,	//	  720		359.999999999 
};

