/**********************************************************************************************************
	: SVPWM_FrequencyChange_1_50Hz.c
˵: ΪƵSVPWM1Hz~10Hz!
ʱ: 2011-05-73 8:59
ʷ汾: Ver1.30a
ϵ: QQ2291407327
*************************************************************************************************************/

#include "DSP281x_Device.h" 
#include "math.h" 
#define CPU_CLOCK_SPEED      6.6667L   // for a 150MHz CPU clock speed
#define ADC_usDELAY 5000L
#define System_Operation_usDELAY 50000L
#define DELAY_US(A)  DSP28x_usDelay(((((long double) A * 1000.0L) / (long double)CPU_CLOCK_SPEED) - 9.0L) / 5.0L) 

extern void DSP28x_usDelay(unsigned long Count); 
interrupt void MainISR(void);

//======================================================================================================
//ȫֱ
//====================================================================================================== 
Uint16 i=0;
Uint16 j=0;
Uint16 k=0;
Uint16 l=0;

float32 ElecThetaAdd=1.0;
float32 ElecTheta = 0.0;    
float32 FrequencyGiven = 50.0;  

float32 Sine=0;
float32 Cosine=0;  

float32 UD = 1;
float32 UQ = 0; 
float32 UALFA = 0;
float32 UBETA = 0;
Uint16 Sector = 0; 
float32 B0 = 0;
float32 B1 = 0;
float32 B2 = 0;
float32 X = 0;
float32 Y = 0;
float32 Z = 0;
float32 t1 = 0;
float32 t2 = 0;
float32 Ta = 0;
float32 Tb = 0;
float32 Tc = 0;
float32 MfuncD1=0;
float32 MfuncD2=0;
float32 MfuncD3=0;  
float32 Modulation=0.85;   

Uint16 T1Period = 0; 
Uint32 IsrTicker=0;
Uint32 IsrTickerTX=0;
Uint32 IsrTickerRX=0; 
Uint32 BackTicker = 0; //ڴ 

//*****************************************************************************************************
//
//*****************************************************************************************************
void main(void)
{
//======================================================================================================
//Ƚϵͳʼ
//======================================================================================================
     InitSysCtrl();

	 EALLOW;
	 SysCtrlRegs.HISPCP.all=0x0000;
	 EDIS;

     EALLOW;
     GpioMuxRegs.GPAMUX.all = 0x003F; // EVA PWM 1-6  pins 
     EDIS;

	 DINT;
	 IER = 0x0000;
	 IFR = 0x0000;
//======================================================================================================
//PIEжϿʼ
//====================================================================================================== 
     InitPieCtrl();

//======================================================================================================
//PIEжʸʼ
//====================================================================================================== 
	 InitPieVectTable(); 

//======================================================================================================
//EVAʼ
//====================================================================================================== 
     EvaRegs.T1PR = 0x5161;  ////Ƶ3.6KHz((1/3.6KHz)/6.66667ns)/2=20833=0x5161
	 T1Period=EvaRegs.T1PR;         
     EvaRegs.T1CNT = 0x0000;
     EvaRegs.T1CON.all = 0x0840;    //0x0840=0000 1000 0100 0000 /ģʽ  ʱԤx/1ֹʱȽϲ 
                                    //ʹڲʱHSPLCKʹԼʹλֹͣ 
     EvaRegs.CMPR1 = 1000; 
     EvaRegs.CMPR2 = 1000; 
     EvaRegs.CMPR3 = 1000;        //ȫȽֵ 

	 EvaRegs.GPTCONA.bit.T1TOADC = 1;      		// EVAжϱ־

     EvaRegs.ACTRA.all = 0x0666;   //PWM1,3,5ЧPWM2,4,6Ч
//     EvaRegs.ACTRA.all = 0x0999;   //PWM1,3,5ЧPWM2,4,6Ч
     EvaRegs.DBTCONA.all = 0x0AF8; //0x0AE8=0000 1010 1111 1000 x/32=150MHz/32=4.6875MHz  Ϊ10
								   //ʱ=32*6.67*10=2134.4ns=2us
     EvaRegs.COMCONA.all =0xA600;  //0xA600=1010 0110 0000 0000 ʹܱȽȽϼĴCMPRXΪƥ
                                   //ֹӲռPWMģʽȫȽʹܣʽƼĴACTRAΪƥ
//======================================================================================================
//ϵͳʱӵʱ
//====================================================================================================== 
//	DELAY_US(System_Operation_usDELAY);  

//======================================================================================================
//ж
//====================================================================================================== 
	 EvaRegs.EVAIMRA.bit.T1UFINT = 1;
     EvaRegs.EVAIFRA.bit.T1UFINT = 1;//T1ж

 	 EALLOW;
     PieVectTable.T1UFINT = &MainISR;
     EDIS;

     PieCtrlRegs.PIEIER2.all = M_INT6;//PIEжϱ־ĴPIEIFRxжϼʱӦλ1жϱӦԶ㣬Ҫû
   	 IER = 0x002;	// //CPUжʹܼĴд1ӦλʹжINT2 

     EINT;  
     ERTM;
 
//======================================================================================================
//ѭ
//====================================================================================================== 
	for(;;) 
	{
		BackTicker++; //ѭ

	}
}

//*****************************************************************************************************
//жϷ
//***************************************************************************************************** 
interrupt void MainISR(void)
{
	IsrTicker++; //жϴ 
//======================================================================================================
//Ƕȼ
//====================================================================================================== 
	i++;
	if(i>=7200)
	{ 	
		i=0; 
		if(ElecThetaAdd<=FrequencyGiven) 
		{
		 	 ElecThetaAdd=ElecThetaAdd+1;
		} 
		else ElecThetaAdd=FrequencyGiven; 
	}

	ElecTheta=ElecTheta+ElecThetaAdd; 
	if(ElecTheta>=3600) 
	{
		ElecTheta=0;
	}
	
//======================================================================================================
//SineCosine
//====================================================================================================== 
	Sine = sin(ElecTheta*6.2831853/3600);
	Cosine = cos(ElecTheta*6.2831853/3600);

//======================================================================================================
//IPARK任UD,UQ==>UALFA,UBETA
//======================================================================================================  
	UALFA=Cosine*UD-Sine*UQ;
	UBETA=Sine*UD+Cosine*UQ; 

//======================================================================================================
//SVPWM㷨ʵ,ͨUALFA,UBETAȷSector
//====================================================================================================== 
	B0=UBETA;
	B1=0.8660254*UALFA-0.5*UBETA;
	B2=-0.8660254*UALFA-0.5*UBETA;

	Sector=0;
	if(B0>0) Sector =1;
	if(B1>0) Sector =Sector +2;
	if(B2>0) Sector =Sector +4; 

//======================================================================================================
//SectorTa,Tb,Tc
//======================================================================================================
	X=UBETA;
    Y=0.8660254*UALFA+0.5*UBETA;
    Z=-0.8660254*UALFA+0.5*UBETA; 

	if(Sector==0)
	{
		Ta=0.5;
		Tb=0.5;
		Tc=0.5;
	}
	else if(Sector==1)
	{
		t1=Z;
		t2=Y;

		Tb=(1-t1-t2)/2;
		Ta=Tb+t1;
		Tc=Ta+t2;
	}
	else if(Sector==2)
	{
		t1=Y;
		t2=-X;

		Ta=(1-t1-t2)/2;
		Tc=Ta+t1;
		Tb=Tc+t2;

 	} 
	else if(Sector==3)
    {
		t1=-Z;
		t2=X;

		Ta=(1-t1-t2)/2;
		Tb=Ta+t1;
		Tc=Tb+t2;		
	
    } 
    else if(Sector==4)
    {
		t1=-X;
		t2=Z;

		Tc=(1-t1-t2)/2;
		Tb=Tc+t1;
		Ta=Tb+t2;

    } 
    else if(Sector==5)
    {
		t1=X;
		t2=-Y;

		Tb=(1-t1-t2)/2;
		Tc=Tb+t1;
 		Ta=Tc+t2;

	}
	else if(Sector==6)
	{
		t1=-Y;
		t2=-Z;

		Tc=(1-t1-t2)/2;
		Ta=Tc+t1;
		Tb=Ta+t2;

	}   
	MfuncD1=(Ta-0.5)*2;
	MfuncD2=(Tb-0.5)*2;
	MfuncD3=(Tc-0.5)*2;  

//======================================================================================================
//ȫȽֵ
//======================================================================================================  
	EvaRegs.CMPR1 = (Uint16)(MfuncD1*Modulation*T1Period/2+T1Period/2);//Aռձȼ㣬ƱM=0.85
	EvaRegs.CMPR2 = (Uint16)(MfuncD2*Modulation*T1Period/2+T1Period/2);//Bռձȼ
	EvaRegs.CMPR3 = (Uint16)(MfuncD3*Modulation*T1Period/2+T1Period/2);//Bռձȼ 

//======================================================================================================
//жϷ
//====================================================================================================== 
	EvaRegs.EVAIMRA.bit.T1UFINT = 1;
	
	EvaRegs.EVAIFRA.all = BIT9;//CPUIFRCPUӦжϺԶ㣬ӦĴжϱ־λδ㣬û㡣
	
	PieCtrlRegs.PIEACK.all |= PIEACK_GROUP2;//д1Ӧжλλλ󵱸ж뵽ʱPIECPUжϡ

	IER = 0x102;   //ʹCPUжINT2INT9
   
	EINT;   
    
}

/*================================================================================================
The end!
=================================================================================================*/


























































