/*
 *
 *
 * ePWM1ePWM2·15KHzSPWM,ҵƲ벶ĵѹͬλ
 *  5.13    ûpi  û
 *
 *
 */
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include "math.h"
interrupt void epwm1_timer_isr(void);
interrupt void adc_isr(void);
void Adc_Config(void);
Uint16 filter(Uint16 abc);
void InitEPwm1Example(void);
float CPIControl(float Iin,float ref_i,float Emax_i,float Kp_i,float Ki_i);

#define SPWM_FC    15000          //ƲƵ
#define SPWM_F     50             //زƵ
#define PWM_TPBRD  1000            //60000000/(SPWM_FC * PWM_DIV)
#define PWM1_TPBRD 500           //60000000/(SPWM_FC * PWM_DIV*2 ) ǰ֮Ƚֵʡʱ
float SN = 300;                   //ز
float M = 0.80;                  // Ʊ
int SP_Sine;                     //ҵָ

float Vac_r = 0;
float Vac_i = 0 ;

float Vac_R;                      // ѹʵ
float Vac_r;                       // ѹλ
float Iac_R;                       // ʵ
float Iac_r;                        // λ


float Iref;                       //ڻοֵ
float Emax_i;                     //ڻ
float Kp_i,Ki_i;                  //ڻPIڲ
float Ei,control_i;               //PI
int AC_flag=1;

float sin_V[300];
float sin_R[300];
float Voltage1[10];
float Voltage2[10];

Uint16 ConversionCount;
Uint16 Voltage;      //˲֮ĵѹ
Uint16 VoltageAD; //δ˲ĵѹ
Uint16 Current;      //˲֮ĵ
Uint16 CurrentAD;//δ˲ĵ
Uint16 value;  //˲
Uint16 epwmcount;
#define FLASH 1                  // 0 룬1 
void main(void)
{

	#if FLASH                    //д
		MemCopy(&RamfuncsLoadStart,&RamfuncsLoadEnd,&RamfuncsRunStart);
		//	&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart
		InitFlash();
	#endif

	InitSysCtrl();                    //ϵͳʼ

	InitEPwm1Gpio();                  //GPIO ʼ

	DINT;                              //ж
	//InitCpuTimers();                   //ʼCPUʱ
	//ConfigCpuTimer(&CpuTimer0,60,1000000);      // ʱʱ1ms
	//CpuTimer0Regs.TCR.all = 0x4001;         //  CpuTimer0Regs.TCR.bit.TIE = 1;жʹ

	InitPieCtrl();                          //ʼPIEжϿƼĴ
	IER = 0x0000;
	IFR = 0x0000;
	InitPieVectTable();                     //ʼPIEж
	InitAdc();

	EALLOW;  // This is needed to write to EALLOW protected registers
	PieVectTable.EPWM1_INT = &epwm1_timer_isr;
	PieVectTable.ADCINT1 = &adc_isr;
	EDIS;    // This is needed to disable write to EALLOW protected registers

	EALLOW;
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;      // ֹʱ
	EDIS;

	InitEPwm1Example();
	Adc_Config();

	EALLOW;
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;         //ʱ
	EDIS;

	IER |= M_INT3;               //PIEж ePWM
	IER |= M_INT1;               //PIEһжϣCPUʱ

	PieCtrlRegs.PIEIER3.bit.INTx1 = 1;      //ʹPWM1
	PieCtrlRegs.PIEIER1.bit.INTx1 = 1;      //ʹADCж
	ConversionCount = 0;
	epwmcount = 0;

	EINT;   // ʹȫжINTM
	ERTM;   // ʹȫʵʱж DBGM
	while(1)
	{
		if(AC_flag==0)
				{
					Iref = Vac_r * 0.5;
					CPIControl(Iref,Iac_r,2,1,0);
					Ei = control_i;
					AC_flag=1;
				}
	}
}
void InitEPwm1Example()
{
	EPwm1Regs.TBPRD = PWM_TPBRD;        //
	EPwm1Regs.TBPHS.half.TBPHS = 0x0000;    // λΪ0
	EPwm1Regs.TBCTR = 0x0000;              //  

	EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;       // Ϊ
	EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;              //ֹλ
	EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE;
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV2;
	EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;                // ʱSYSCLKOUT/(1*2)

	EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;          //ֵΪʱ
	EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
	EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
	EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

	EPwm1Regs.CMPA.half.CMPA = 0;              // ʼȽֵ

	EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;         //޶
	EPwm1Regs.AQCTLA.bit.CAD = AQ_SET;

	EPwm1Regs.AQCTLB.bit.CAU = AQ_SET;
	EPwm1Regs.AQCTLB.bit.CAD = AQ_CLEAR;
/*********************************************************/
//Ϊepwm1aepwm1bͬʱغ½ؾʱʱΪ
//0x0010*4*sysclock
/********************************************************/

	EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;   //AʱBʱ
	EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;        //B
	EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;          //ѡ  ABǷ

	EPwm1Regs.DBRED = 0x0010;                        //ʱ
	EPwm1Regs.DBFED = 0x0010;                        //½ʱ

	EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;        //EPWM жѡ
	EPwm1Regs.ETSEL.bit.INTEN = 1;                   //жʹ
	EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;              //ѡٸ¼һж

	EPwm1Regs.ETSEL.bit.SOCAEN	= 1;		// Enable SOC on A group

	 EPwm1Regs.ETSEL.bit.SOCASEL= ET_CTR_PRD;		// Select SOC from from CPMA on upcount

	 EPwm1Regs.ETPS.bit.SOCAPRD = ET_3RD;		// Generate pulse on 1st event

		EPwm1Regs.ETSEL.bit.SOCBEN = 1;
		EPwm1Regs.ETSEL.bit.SOCBSEL = ET_CTR_PRD;	// Use PRD event as trigger as well
		EPwm1Regs.ETPS.bit.SOCBPRD = ET_1ST;        // Generate pulse on 1nd event


}

interrupt void epwm1_timer_isr(void)
{
	sin_V[epwmcount] = Vac_r;
	sin_R[epwmcount] = Iac_r;
	if (epwmcount>=300)
	{
		epwmcount = 0;
	}
	else epwmcount++;
	//EPwm1Regs.CMPA.half.CMPA = 500*(0.5*Vac_r);     //ȽֵֵCMPA
	EPwm1Regs.CMPA.half.CMPA = 500;
		//EPwm2Regs.CMPA.half.CMPA = PWM1_TPBRD*(1 - M * sine);   //ȽֵֵCMPA
	EPwm1Regs.ETCLR.bit.INT = 1;             //жϱ־λ
	PieCtrlRegs.PIEACK.bit.ACK3 = 1;          //ʹж
}


interrupt void  adc_isr(void)
{

	if(AC_flag == 1)
	{
		VoltageAD=(AdcResult.ADCRESULT1+AdcResult.ADCRESULT2+AdcResult.ADCRESULT3)/3;
		CurrentAD=(AdcResult.ADCRESULT4+AdcResult.ADCRESULT5+AdcResult.ADCRESULT6)/3;
		//Voltage = filter(VoltageAD);       //
		Current = filter(CurrentAD);
		Vac_r=(float)(VoltageAD*3.3*4/4096);
		Iac_r=(float)(Current*3.3*4/4096);
		//Voltage1[ConversionCount] = CurrentAD*3.3/4096;
		AC_flag = 0;
	}


	if(ConversionCount == 9)
	  {
	     ConversionCount = 0;
	  }
	  else ConversionCount++;
  // If 20 conversions have been logged, start over

  AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;		//Clear ADCINT1 flag reinitialize for next SOC
  //PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;   // Acknowledge interrupt to PIE
  PieCtrlRegs.PIEACK.bit.ACK1 = 1;          // Acknowledge interrupt to PIE
  return;
}
void Adc_Config(void)
{
		EALLOW;
		AdcRegs.ADCCTL1.bit.INTPULSEPOS	= 1;	//ADCINT1 trips after AdcResults latch
		//ADCCTL1:ADCƼĴ1
		AdcRegs.INTSEL1N2.bit.INT1E     = 1;	//Enabled ADCINT1
		AdcRegs.INTSEL1N2.bit.INT1CONT  = 0;	//Disable ADCINT1 Continuous mode
		AdcRegs.INTSEL1N2.bit.INT1SEL	= 0;	//setup EOC1 to trigger ADCINT1 to fire
		//INTSELxNy:ADCжԴѡĴ

		/*AdcRegs.ADCSOC0CTL.bit.CHSEL 	= 1;	//set SOC0 channel select to ADCINA1ѹ
		AdcRegs.ADCSOC1CTL.bit.CHSEL 	= 2;	//set SOC1 channel select to ADCINA2
		AdcRegs.ADCSOC2CTL.bit.CHSEL    = 3;    //

		AdcRegs.ADCSOC0CTL.bit.TRIGSEL 	= 5;	//set SOC0 start trigger on EPWM1A, due to round-robin SOC0 converts first then SOC1
		AdcRegs.ADCSOC1CTL.bit.TRIGSEL 	= 5;	//set SOC1 start trigger on EPWM1A, due to round-robin SOC0 converts first then SOC1
		AdcRegs.ADCSOC2CTL.bit.TRIGSEL  = 5 ;

		AdcRegs.ADCSOC0CTL.bit.ACQPS 	= 6;	//set SOC0 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC1CTL.bit.ACQPS 	= 6;	//set SOC1 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC2CTL.bit.ACQPS    = 6 ;*/
		AdcRegs.ADCSOC0CTL.bit.CHSEL 	= 1;	// SOC0ͨѡA3 ----Vdc
		AdcRegs.ADCSOC1CTL.bit.CHSEL 	= 3;	// SOC1ͨѡA1 ----Vac
		AdcRegs.ADCSOC2CTL.bit.CHSEL 	= 3;	// SOC2 ͨѡA1 ----Vac
		AdcRegs.ADCSOC3CTL.bit.CHSEL 	= 3;	// SOC3 ͨѡA1 ----Vac
		AdcRegs.ADCSOC4CTL.bit.CHSEL 	= 2;	// SOC4 ͨѡA2 ----Iac
		AdcRegs.ADCSOC5CTL.bit.CHSEL 	= 2;	// SOC5 ͨѡA2 ----Iac
		AdcRegs.ADCSOC6CTL.bit.CHSEL 	= 2;	// SOC6 ͨѡA2 ----Iac
		AdcRegs.ADCSOC0CTL.bit.TRIGSEL 	= 5;	//set SOC0 start trigger on ePWM1 SOCA,
		AdcRegs.ADCSOC1CTL.bit.TRIGSEL 	= 6;	//set SOC1 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC2CTL.bit.TRIGSEL 	= 6;	//set SOC2 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC3CTL.bit.TRIGSEL 	= 6;	//set SOC3 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC4CTL.bit.TRIGSEL 	= 6;	//set SOC4 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC5CTL.bit.TRIGSEL 	= 6;	//set SOC5 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC6CTL.bit.TRIGSEL 	= 6;	//set SOC6 start trigger on ePWM1 SOCB,
		AdcRegs.ADCSOC0CTL.bit.ACQPS 	= 6;	//set SOC0 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC1CTL.bit.ACQPS 	= 6;	//set SOC1 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC2CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC3CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC4CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC5CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
		AdcRegs.ADCSOC6CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)

		EDIS;

}

Uint16 filter(Uint16 abc)
{
	Uint16 new_value;
	new_value = abc;
	value= value*0.8 + new_value*0.2;
	return value;
}

float CPIControl(float Iin,float ref_i,float Emax_i,float Kp_i,float Ki_i)
{
	float error,P_error,PICon_P,PICon_I,last_control_i=0,last_error=0,I_error;

	error = ref_i - Iin;
	if(fabs(error)>Emax_i)
		error = Emax_i;

	P_error = error - last_error;
	I_error = error;
	PICon_P = Kp_i * P_error;
	PICon_I = Ki_i * I_error;
	control_i = PICon_P + PICon_I + last_control_i;

	if(control_i<=-1)
		control_i = -1;
	if(control_i>=1)
		control_i = 1;
	last_error = error;
	last_control_i = control_i;
	return(control_i);

}

