//###########################################################################
// Original Author H.J.
//
// $TI Release: 2803x C/C++ Header Files V1.21 $
// $Release Date: December 1, 2009 $
//###########################################################################

#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include "include_head_all.h"
#include "math.h"
#include "IQmathLib.h"


typedef struct {
		Uint32 IQarithmeticCNT;
		Uint32 matharithmeticCNT;
		_iq   iqBuf;
		float fBuf;
}IQ_Para; 

IQ_Para IQ={0,0,0,0};



void Delay(Uint32 N);
void IQtest(void);
void IQSatTest(void);
void IQSinPUTest(void);

unsigned int  *Ptr8000 = 	&(*((unsigned int  *) 0x8000) );
unsigned int  *BootRam  =(unsigned int  *)0x3F8000;

unsigned int  *Ramtest  =(unsigned int  *)0x3F8700;


#define Angle_A 1
#define PI 3.1415926535898

Uint16 TsetBuf[10];

#pragma DATA_SECTION(CAN_Parameter,"ConstParameter");
const Uint32 CAN_Parameter[]={0xABCD0011};

#pragma DATA_SECTION(IAP_Parameter,"BootParameter");
Uint16 IAP_Parameter[]={
0xFAFA,0xFBFB
};


Uint32 i = 0;
_iq iqBuf;

float input[4]={1,6,PI,0};


void main(void)
 {

// eCAN control registers require read/write access using 32-bits.  Thus we
// will create a set of shadow registers for this example.  These shadow
// registers will be used to make sure the access is 32-bits and not 16.
//   struct ECAN_REGS ECanaShadow;

// Step 1. Initialize System Control:b
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2803x_SysCtrl.c CAN_Node_IDfile.
   InitSysCtrl();

// Step 2. Initalize GPIO:
// This example function is found in the DSP2803x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
// InitGpio();  // Skipped for this example



// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
   DINT;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the DSP2803x_PieCtrl.c file.
   InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2803x_DefaultIsr.c.
// This function is found in DSP2803x_PieVect.c.
   InitPieVectTable();

// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP2803x_InitPeripherals.c
// InitPeripherals(); // Not required for this example

	PieCtrlRegs.PIECTRL.bit.ENPIE = 1;          // Enable the PIE block

  	SCI_Init(); 
	open_uart_debug();
	printf("\r\nDSP is Ready!");

//&(*((volatile unsigned long *) 0xE000ED00) )

//	&(*((unsigned int  *)0x8000)  ) = 0xA0A0;
	*BootRam = 0xA0A1;
	
	printf("\r\nPtr8000 is 0x%x",*Ptr8000);
	printf("\r\nIAPRam  is 0x%x", *BootRam);
	printf("\r\nConstCode is 0x%x 0x%x",IAP_Parameter[0],IAP_Parameter[1]);		

	Timer0_Init();

////////////////////////////////////////////////////////////////////////////	
	
	printf("\r\n---------------------HIKE Tech DSP28035 IQ------------------------");
	printf("\r\nCPU:TMS320F28035,60MHz,32bit,FixPoint\r\n\r\n");	

	EINT;  // Enable Global interrupt INTM
	ERTM;  	
    while(1) 
    {
		IQtest();
		//IQSatTest();
		//IQSinPUTest();
		for(;;); 

    }
}									


void Delay(Uint32 N)
{
	Uint16 j;
	while(N--)
	{
		for(j=0;j<0xFFFF;j++);	
	}
}


//ȽIQ  mathٶ
void IQtest()
{
	_iq input;
	_iq input1[3];
	float finput;
	
	printf("\r\n");
	printf("\r\n32Bit is 0x%lx",0xAAAABBBB); //printf32bitǷȷ
	
//δתΪIQʽ㣬ʧ	
	printf("\r\n");
	input = _IQdiv(3.2,2);					
	printf("\r\nIQdiv(3.2,2) Q24 is 0x%lx",input);
//תΪIQʽٲ	
	input = _IQdiv(_IQ(3.2),_IQ(2));
	printf("\r\n_IQdiv(_IQ(3.2),_IQ(2)) Q24 is 0x%lx",input);
	
//Q24 תΪQ14ʽֶλ	
	printf("\r\n1.6 Q24 is 0x%lx",_IQ(1.6));
	printf("\r\n1.6 manual shift Q24 to Q14 is 0x%lx",_IQ(1.6)>>10);	

//Q24ʽȽ0.5sin(PI/6)
	printf("\r\n");
	printf("\r\n0.5 Q24 is 0x%lx",_IQ(0.5));	
//				
	input1[0] = _IQdiv(_IQ(PI),_IQ(6));
	printf("\r\nIQDiv(IQ(PI),IQ(6)) sin() Q24 is 0x%lx \t0x%lx",input1[0],_IQsin(input1[0]));
	 

// ˷
	printf("\r\n");
	finput = PI * 0.16666667;
	input1[1] = _IQmpy(_IQ(PI),_IQdiv(_IQ(1),_IQ(6)));
	printf("\r\niq(0.5235987755983) sin() Q24 is 0x%lx \t0x%lx",_IQ(0.5235987755983),_IQsin(_IQ(0.5235987755983)));	
	printf("\r\nfloat_mpy           sin() Q24 is 0x%lx \t0x%lx",_IQ(finput),_IQsin(_IQ(finput)));
	printf("\r\nIQmpy()             sin() Q24 is 0x%lx \t0x%lx",input1[1],_IQsin(input1[1]));
	
//ʹ÷
	input1[2] = _IQ(PI)* _IQdiv(_IQ(1),_IQ(6));      
	printf("\r\nmanual mpy          sin() Q24 is 0x%lx \t0x%lx",input1[2],_IQsin(input1[2]));
	printf("\r\n");
	printf("\r\n");

	printf("\r\nȽ5ʱ,IQ׼ sin((1.0/6.0)*PI) Ĵ");
 	printf("\r\nȴ10......");

	while(Timer.Count_1ms <=10000)
	{
		if(Timer.Count_1ms<5000)
		{
			IQ.iqBuf = _IQsin(_IQmpy(_IQ(PI),_IQdiv(_IQ(1),_IQ(6))));
			IQ.IQarithmeticCNT++;	
		}
		else if(Timer.Count_1ms<10000)
		{
			IQ.fBuf = sin((1.0/6.0)*PI);
			IQ.matharithmeticCNT++;		
		}
		else
		{
			Timer.Count_1ms = 10001;
			printf("\r\n IQ   %ld   \t_IQsin(_IQmpy(_IQ(PI),_IQdiv(_IQ(1),_IQ(6))))Ϊ  \t%0.2f",IQ.IQarithmeticCNT, _IQtoF(IQ.iqBuf));
			printf("\r\n math %ld   \tsin((1.0/6.0)*PI)Ϊ  \t\t\t\t%0.2f",IQ.matharithmeticCNT,IQ.fBuf);
		}
		
	}

}

//IQSatģ
//ܣ޷
void IQSatTest()
{
	_iq Y, M, X, B;   // GLOBAL_Q = 24 (+/- 128 range) 

	_iq23 temp;     // IQ = 20 (+/- 2048 range) 

	_iq MAX_POS =  _IQ(50);
    _iq MIN_NEG =  _IQ(-50);
	

	M = _IQ(2.5);
	X = _IQ(10);
	B = _IQ(1.5);

//IQתֵΪ仯
	printf("\r\nIQ24 to IQ23 is %0.5f --> %0.5f",_IQtoF(M),_IQtoF(_IQtoIQ23(M)));
	//Y = M*X + B"
	temp = _IQ23mpy(_IQtoIQ23(M), _IQtoIQ23(X)) + 
	_IQtoIQ23(B); 
	printf("\r\nbefore Sat is %0.5f",_IQtoF(temp));

	printf("\r\nLimit Rang is %f to %f",_IQtoF(MAX_POS),_IQtoF(MIN_NEG));
	temp = _IQsat(temp, _IQtoIQ23(MAX_POS), _IQtoIQ23(MIN_NEG)); 
	printf("\r\nafter Sat is %0.5f",_IQtoF(temp));
	Y = _IQ23toIQ(temp); 
	printf("\r\nQ23 to Q24 is %0.5f",_IQtoF(Y));


//ıȡֵΧ
	MAX_POS =  _IQ(10);
    MIN_NEG =  _IQ(-10);
	printf("\r\nLimit Rang is %f to %f",_IQtoF(MAX_POS),_IQtoF(MIN_NEG));
	temp = _IQsat(temp, _IQtoIQ23(MAX_POS), _IQtoIQ23(MIN_NEG)); 
	printf("\r\nafter Sat is %0.5f",_IQtoF(temp));
	Y = _IQ23toIQ(temp); 
	printf("\r\nQ23 to Q24 is %0.5f",_IQtoF(Y));

}


void IQSinPUTest()
{
	_iq   in1, out1;
	_iq30 in2, out2;
	float i = 0.0;


// in1  = in2 =  (0.25 x PI)/(2PI) x 2^30
//    = (.25/2) x 2^30 = 0x08000000 or .125 
// out1 = out2 = sinPU(0.25/2) x 2^30 = 0x2D413CCC or .707

	for(i=0.0;i<1;i+=0.001)
	{
		in1  =_IQ(i*PI/PI); 
		out1 =_IQsinPU(in1);

		in2  =_IQ30(i*PI/PI);//0.25L
		out2 =_IQ30sinPU(in2);   			
	}


}

//===========================================================================
// No more.
//===========================================================================

 
