#include <stdio.h>
#include <file.h>
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File  
#include "printf_uart.h" 
#include "include_head_all.h"


/*
	union
	  {
	    Uint16 All;
	    struct{
	            Uint16  UartSendEableFlag     :1;  // ϴʹ
	            Uint16  CANRevFlag           :1;  //CAN  յݱ־
 
	          }Status_Bits;
	  }Mark_Para; 
	
	char *sendPtr;
*/

Uart_Msg UartDBG={0,0};


//#################################################
//-----------------------------------------------
//ڳʼ
//128000  8N1
//-----------------------------------------------
void SCI_Init()
{
	InitSciaGpio();
// Initalize the SCI FIFO
    SciaRegs.SCIFFTX.all=0xE040;
    SciaRegs.SCIFFRX.all=0x2044;
    SciaRegs.SCIFFCT.all=0x0;
	// Note: Clocks were turned on to the SCIA peripheral
    // in the InitSysCtrl() function

 	SciaRegs.SCICCR.all =0x0007;   // 1 stop bit,  No loopback
                                   // No parity,8 char bits,
                                   // async mode, idle-line protocol
	SciaRegs.SCICTL1.all =0x0003;  // enable TX, RX, internal SCICLK,
                                   // Disable RX ERR, SLEEP, TXWAKE
	SciaRegs.SCICTL2.all =0x0003;
	SciaRegs.SCICTL2.bit.TXINTENA =1;
	SciaRegs.SCICTL2.bit.RXBKINTENA =1;

// baud = LSPCLK/8/((BRR+1) 
// baud @LSPCLK = 15MHz (60 MHz SYSCLK)
	SciaRegs.SCIHBAUD    =0x0000;  // 0x30-->38400.
    SciaRegs.SCILBAUD    =14;      //0XC2 9600 ;14 128000

	SciaRegs.SCICTL1.all =0x0023;  // Relinquish SCI from Reset
}



//#################################################
//-----------------------------------------------
//FIFO ʼδ
//-----------------------------------------------
void scia_fifo_init()
{
    SciaRegs.SCIFFTX.all=0xE040;
    SciaRegs.SCIFFRX.all=0x204f;
    SciaRegs.SCIFFCT.all=0x0;

}


//#################################################
//-----------------------------------------------
//һֽ
//-----------------------------------------------
void scia_xmit(int a)
{
	Uint16 WaitTimer=0;
		
		while (SciaRegs.SCIFFTX.bit.TXFFST != 0)
	    {

			WaitTimer++;		
			if(WaitTimer > 80)
				{
					break;
				}
		}

		if(WaitTimer < 80)
			SciaRegs.SCITXBUF=a;

}


//#################################################
//-----------------------------------------------
//Printf 
//-----------------------------------------------
void open_uart_debug (void)
{
	int status;
	status = add_device("uart", _MSA, my_open, my_close, my_read, my_write, my_lseek, my_unlink, my_rename);
	if (status == 0) {
		freopen("uart:", "w", stdout);		// open uart and redirect stdout to UART
		setvbuf(stdout, NULL, _IONBF, 0); 	// disable buffering for stdout
	}
}

int my_open(const char *path, unsigned flags, int fno)
{
	//scia_fifo_init();
	//scia_echoback_init();
	path = path;
	flags = flags;
	fno = fno;
	return 0;
}

int my_close(int fno)
{
	fno =fno;
	return 0;
}

int my_read(int fno, char *buffer, unsigned count)
{
	fno = fno;
	buffer = buffer;
	count = count;
	return 0;
}

int my_write(int fno, const char *buffer, unsigned count)
{	
	int i=0;
	fno = fno;
	
	while(count-- > 0) {
		scia_xmit(buffer[i++]);
	}
	return count;
}

off_t my_lseek(int fno, off_t offset, int origin)
{
	fno = fno; offset = offset; origin = origin;
	return 0;
}

int my_unlink(const char *path)
{
	path = path;
	return 0;
}

int my_rename(const char *old_name, const char *new_name)
{
	old_name = old_name;
	new_name = new_name;
	return 0;
}


