
#include "DSP28x_Project.h"

#define LedPort            GPIO3
#define Key_TestPort       GPIO12
#define PwmAHPort          GPIO0
#define PwmALPort          GPIO1
#define PwmBHPort          GPIO2

#define CapPort            GPIO19

#define TzPort             GPIO16


#define I_Port             1
#define Temp_Port          3



#define Flag_fault         EPwm2Regs.TZFLG.bit.CBC | EPwm2Regs.TZFLG.bit.OST

#define Clr_Flag_fault     EALLOW;EPwm1Regs.TZCLR.bit.CBC =1;EPwm1Regs.TZCLR.bit.OST=1;EPwm2Regs.TZCLR.bit.CBC=1; EPwm2Regs.TZCLR.bit.OST=1;EDIS



#define EPwm1_T            EPwm1Regs.TBPRD
#define Pulse_Width        EPwm1Regs.CMPA.half.CMPA

#define Refresh_Epwm2      EPwm2Regs.TBPRD=EPwm1_T ; EPwm2Regs.CMPA.half.CMPA = EPwm1_T>>1; \
                           EPwm2Regs.CMPB= EPwm2Regs.CMPA.half.CMPA+Pulse_Width
#define Refresh_Epwm3      EPwm3Regs.TBPRD=EPwm1_T ; EPwm3Regs.CMPA.half.CMPA = Pulse_Width >>1

#define EPwm3_Pulse_Width  EPwm3Regs.CMPA.half.CMPA
#define EPwm3_T            EPwm3Regs.TBPRD


#define Key_TestIn      GpioDataRegs.GPADAT.bit.Key_TestPort
volatile Uint16 Key_Test;

#define LedOn           GpioDataRegs.GPADAT.bit.LedPort  =   0
#define LedOff          GpioDataRegs.GPADAT.bit.LedPort  =   1
#define LedCpl          GpioDataRegs.GPADAT.bit.LedPort ^=   1


#define MAXT          3500
#define MINT          2100
#define MAXDuty       50

Uint32   Duty=20;
Uint32   T=2200;
Uint16  F;
Uint32   cap2;
Uint32   cap[4];

Uint32  EPwm1TimerIntCount;
Uint32  EPwm2TimerIntCount;
Uint32  EPwm3TimerIntCount;
Uint16  EPwm1_DB_Direction;
Uint16  EPwm2_DB_Direction;
Uint16  EPwm3_DB_Direction;


Uint16 ConversionCount;
Uint16 Voltage1[10];
Uint16 Voltage2[10];


// Maximum Dead Band values
#define EPWM1_MAX_DB   0x03FF
#define EPWM2_MAX_DB   0x03FF
#define EPWM3_MAX_DB   0x03FF

#define EPWM1_MIN_DB   60                          // 1us


// To keep track of which way the Dead Band is moving
#define DB_UP   1
#define DB_DOWN 0

void InitECapture(void);
void Init_Gpio(void);
void delay_loop(void);
void ReadKey(void);
void Init_EPwm(void);
void Init_ADC_this(void);
interrupt void epwm1_isr(void);

interrupt void epwm3_isr(void);
interrupt void adc_isr(void);

interrupt void ecap1_isr(void);

interrupt void adc_isr(void)
{

	//LedOn;
	 //  LedOff;

	/*
	   Voltage1[ConversionCount] = AdcResult.ADCRESULT1;  //discard ADCRESULT0 as part of the workaround to the 1st sample errata for rev0
	    Voltage2[ConversionCount] = AdcResult.ADCRESULT2;

	    // If 20 conversions have been logged, start over
	    if(ConversionCount == 9)
	    {
	       ConversionCount = 0;
	    }
	    else ConversionCount++;

*/

	AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;		//Clear ADCINT1 flag reinitialize for next SOC
	  PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;   // Acknowledge interrupt to PIE

	//  return;
}



interrupt void epwm1_isr(void)
{

	    EPwm1Regs.ETCLR.bit.INT = 1;

	   // Acknowledge this interrupt to receive more interrupts from group 3
	   PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

}

interrupt void epwm3_isr(void)
{

	//  LedOn;
	 // LedOff;

      EPwm3Regs.ETCLR.bit.INT = 1;

		   // Acknowledge this interrupt to receive more interrupts from group 3
	  PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;


}


void Init_ADC_this()
{
/*
    EALLOW;

    AdcRegs.ADCCTL1.bit.INTPULSEPOS	= 1;	//ADCINT1 trips after AdcResults latch
    AdcRegs.INTSEL1N2.bit.INT1E     = 1;	//Enabled ADCINT1
    AdcRegs.INTSEL1N2.bit.INT1CONT  = 0;	//Disable ADCINT1 Continuous mode
    AdcRegs.INTSEL1N2.bit.INT1SEL	= 2;	//setup EOC2 to trigger ADCINT1 to fire

    AdcRegs.ADCSOC0CTL.bit.CHSEL 	= I_Port ;	//set SOC0 channel select to ADCINA4
    AdcRegs.ADCSOC1CTL.bit.CHSEL 	= I_Port ;	//set SOC1 channel select to ADCINA4
    AdcRegs.ADCSOC2CTL.bit.CHSEL 	= Temp_Port;	//set SOC1 channel select to ADCINA2

    AdcRegs.ADCSOC0CTL.bit.TRIGSEL 	= 9;	//set SOC0 start trigger on EPWM3A, due to round-robin SOC0 converts first then SOC1
    AdcRegs.ADCSOC1CTL.bit.TRIGSEL 	= 9;	//set SOC1 start trigger on EPWM3A, due to round-robin SOC0 converts first then SOC1
    AdcRegs.ADCSOC2CTL.bit.TRIGSEL 	= 9;	//set SOC2 start trigger on EPWM3A, due to round-robin SOC0 converts first then SOC1, then SOC2

    AdcRegs.ADCSOC0CTL.bit.ACQPS 	= 8;	//set SOC0 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
    AdcRegs.ADCSOC1CTL.bit.ACQPS 	= 8;	//set SOC1 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
    AdcRegs.ADCSOC2CTL.bit.ACQPS 	= 8;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
    EDIS;

*/

}



void InitECapture()
{

   ECap1Regs.ECEINT.all = 0x0000;             // Disable all capture interrupts
   ECap1Regs.ECCLR.all = 0xFFFF;              // Clear all CAP interrupt flags
   ECap1Regs.ECCTL1.bit.CAPLDEN = 0;          // Disable CAP1-CAP4 register loads
   ECap1Regs.ECCTL2.bit.TSCTRSTOP = 0;        // Make sure the counter is stopped

   // Configure peripheral registers
   ECap1Regs.ECCTL2.bit.CONT_ONESHT = 1;      // One-shot
   ECap1Regs.ECCTL2.bit.STOP_WRAP = 1;        // Stop at 4 events
   ECap1Regs.ECCTL1.bit.CAP1POL = 0;          // Falling edge
   ECap1Regs.ECCTL1.bit.CAP2POL = 1;          // Rising edge
   ECap1Regs.ECCTL1.bit.CAP3POL = 0;          // Falling edge
   ECap1Regs.ECCTL1.bit.CAP4POL = 1;          // Rising edge
   ECap1Regs.ECCTL1.bit.CTRRST1 = 1;          // Difference operation
   ECap1Regs.ECCTL1.bit.CTRRST2 = 1;          // Difference operation
   ECap1Regs.ECCTL1.bit.CTRRST3 = 1;          // Difference operation
   ECap1Regs.ECCTL1.bit.CTRRST4 = 1;          // Difference operation
   ECap1Regs.ECCTL2.bit.SYNCI_EN = 1;         // Enable sync in
   ECap1Regs.ECCTL2.bit.SYNCO_SEL = 0;        // Pass through
   ECap1Regs.ECCTL1.bit.CAPLDEN = 1;          // Enable capture units

   ECap1Regs.ECCTL2.bit.TSCTRSTOP = 1;        // Start Counter
   ECap1Regs.ECCTL2.bit.REARM = 1;            // arm one-shot
   ECap1Regs.ECCTL1.bit.CAPLDEN = 1;          // Enable CAP1-CAP4 register loads
   ECap1Regs.ECEINT.bit.CEVT2 = 1;            // 4 events = interrupt


}






interrupt void ecap1_isr(void)
{

   // Cap input is syc'ed to SYSCLKOUT so there may be
   // a +/- 1 cycle variation

LedOn;
 LedOff;

 cap[0]=ECap1Regs.CAP1;cap[1]=ECap1Regs.CAP2;cap[2]=ECap1Regs.CAP3;cap[3]=ECap1Regs.CAP4;


 cap2=ECap1Regs.CAP2;

 //ECap6Regs.ECCLR.bit.CEVT1 = 1;


 //ECap6Regs.ECCLR.bit.INT = 1;

   ECap1Regs.ECCLR.bit.CEVT2 = 1;
   ECap1Regs.ECCLR.bit.INT = 1;
   ECap1Regs.ECCTL2.bit.REARM = 1;

   // Acknowledge this interrupt to receive more interrupts from group 4
   PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;
}




















void main(void)
{
Uint16 temp;

	   InitSysCtrl();
       Init_Gpio();

       DINT;
       InitPieCtrl();
       IER = 0x0000;
       IFR = 0x0000;
       InitPieVectTable();

         EALLOW;
         PieVectTable.ADCINT1 = &adc_isr;
         PieVectTable.EPWM3_INT = &epwm3_isr;
         PieVectTable.ECAP1_INT = &ecap1_isr;
        EDIS;


          InitECapture();
          InitAdc();
          Init_ADC_this();
          LedOff;
      // Enable EPWM INTn in the PIE: Group 3 interrupt 1-3
          PieCtrlRegs.PIEIER1.bit.INTx1 = 1;	// Enable INT 1.1 in the PIE
     //   PieCtrlRegs.PIEIER3.bit.INTx1 = 1;
     //   PieCtrlRegs.PIEIER3.bit.INTx2 = 1;
     //    PieCtrlRegs.PIEIER3.bit.INTx3 = 1;


                // Enable eCAP INTn in the PIE: Group 3 interrupt 1-6
             PieCtrlRegs.PIEIER4.bit.INTx1 = 1;
             IER |= M_INT3;
             IER |= M_INT1;
             IER |= M_INT4;
             EINT;   // Enable Global interrupt INTM
             ERTM;   // Enable Global realtime interrupt DBGM

             EALLOW;
             SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;     //ֹTBʱ
             EDIS;
             Init_EPwm();
             EALLOW;
             SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;     //ʹTBʱ
             EDIS;


          Duty=10;

         for(;;)
         {//LedOn;
       //  Duty=30;
         Pulse_Width= Duty*T/100;


         EPwm1_T=T;
         Refresh_Epwm2 ;
         Refresh_Epwm3 ;


         Refresh_Epwm2 ;    //    ɾ   Ͳͣ       InitPieVectTable();
         Refresh_Epwm3 ;   //



         // LedOff;

         if(   Flag_fault   )
         {
        	Clr_Flag_fault;

         }


     }



          ReadKey();
          temp =Key_Test;

   for(;;)
   {
/*
		   ReadKey();
		   if(Key_Test!=temp)
		   {
			 temp =Key_Test;
			   //LedOn ;
			   LedCpl;
             if(temp==0)
             {
			  if(T>MAXT) T=MAXT;
			  else T=T+1;
			  Pulse_Width= Duty*(T+1)/100;
			  EPwm3_Pulse_Width  = Pulse_Width>>1;
			  EPwm3_T = T;
			  F=60*1000000/(T+1);

             }

		   }
*/
	}

}





void ReadKey( )
 {

	/*

   static volatile Uint16 cnt=0,state;
   Uint16 temp;
   temp=Key_TestIn;

   if(state == temp )
   {
       if(++cnt>10)
       {
           cnt=10;
          if(Key_TestIn==0) Key_Test = 1;
          else              Key_Test = 0;

       }

    }else  {   cnt=0;   state=temp;   }
*/
 }




void delay_loop()
{
    short      i;
    for (i = 0; i < 1000; i++) {}
}


void Init_Gpio(void)
{


    EALLOW;
	GpioCtrlRegs.GPAMUX1.all = 0x00000000;  // All GPIO
	GpioCtrlRegs.GPAMUX2.all = 0x00000000;  // All GPIO
	//GpioCtrlRegs.GPAMUX1.all = 0x00000000;  // All GPIO
   // GpioCtrlRegs.GPADIR.all = 0xFFFFFFFF;   // All outputs
   // GpioCtrlRegs.GPBDIR.all = 0x0000000F;   // All outputs

      GpioCtrlRegs.GPAPUD.bit.PwmAHPort = 1;    // Disable pull-up on GPIO0 (EPWM1A)
      GpioCtrlRegs.GPAPUD.bit.PwmALPort = 1;    // Disable pull-up on GPIO1 (EPWM1B)
      GpioCtrlRegs.GPAPUD.bit.PwmBHPort = 1;    // Disable pull-up on GPIO0 (EPWM1A)
  /* Configure EPwm-1 pins using GPIO regs*/
  // This specifies which of the possible GPIO pins will be EPWM1 functional pins.
  // Comment out other unwanted lines.

      GpioCtrlRegs.GPAMUX1.bit.PwmAHPort = 1;   // Configure GPIO0 as EPWM1A
      GpioCtrlRegs.GPAMUX1.bit.PwmALPort = 1;   // Configure GPIO1 as EPWM1B
      GpioCtrlRegs.GPADIR.bit.PwmAHPort = 1;
      GpioCtrlRegs.GPADIR.bit.PwmALPort = 1;
      GpioCtrlRegs.GPAMUX1.bit.PwmBHPort = 1;   // Configure GPIO3 as EPWM2B
      GpioCtrlRegs.GPADIR.bit.PwmBHPort = 1;

    GpioCtrlRegs.GPAPUD.bit.TzPort= 0;    // Enable pull-up on GPIO16 (TZ2)
    GpioCtrlRegs.GPAQSEL2.bit.TzPort = 3;  // Asynch input GPIO16 (TZ2)
    GpioCtrlRegs.GPAMUX2.bit. TzPort = 3;  // Configure GPIO16 as TZ2

    GpioCtrlRegs.GPAMUX1.bit.LedPort = 0;
    GpioCtrlRegs.GPADIR.bit.LedPort = 1;

    GpioCtrlRegs.GPADIR.bit.Key_TestPort = 0;
    GpioCtrlRegs.GPAMUX1.bit.Key_TestPort = 0;
    GpioCtrlRegs.GPAQSEL1.bit.Key_TestPort = 1;
    GpioCtrlRegs.GPACTRL.bit.QUALPRD0 = 8;


       GpioCtrlRegs.GPAPUD.bit.CapPort = 0;     // Enable pull-up on GPIO19 (CAP1)
       GpioCtrlRegs.GPAQSEL2.bit.CapPort  = 0;   // Synch to SYSCLKOUT GPIO19 (CAP1)
       GpioCtrlRegs.GPAMUX2.bit.CapPort  = 3;    // Configure GPIO19 as CAP1




    EDIS;

}

void Init_EPwm()
{

   EPwm1Regs.TBPRD = T ;                        // Set timer period
   EPwm1Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm1Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP	; // Count up
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
   EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;

   EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
   EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
   EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

   // Setup compare
   EPwm1Regs.CMPA.half.CMPA = 0;


        EPwm1Regs.AQCTLA.bit.ZRO = AQ_SET;             // Set PWM1A on Zero
        EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;
   //     EPwm1Regs.AQCTLB.bit.PRD = AQ_SET;          // Set PWM1A on Zero
     //   EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;


          EPwm2Regs.TBPRD = T ;                        // Set timer period
          EPwm2Regs.TBPHS.half.TBPHS =0;           // Phase is 0
          EPwm2Regs.TBCTR = 0x0000;                      // Clear counter

          // Setup TBCLK
          EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP	; // Count up
          EPwm2Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
          EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
          EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;

          EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
          EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
          EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
          EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

          // Setup compare
          EPwm2Regs.CMPA.half.CMPA =  T>>1;
          EPwm2Regs.CMPB= EPwm2Regs.CMPA.half.CMPA+EPwm1Regs.CMPA.half.CMPA;


          EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on Zero
          EPwm2Regs.AQCTLA.bit.CBU = AQ_CLEAR;
     //   EPwm1Regs.AQCTLB.bit.PRD = AQ_SET;          // Set PWM1A on Zero
     //   EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;


     EPwm3Regs.TBPRD = T ;                        // Set timer period
     EPwm3Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
     EPwm3Regs.TBCTR = 0x0000;                      // Clear counter

     // Setup TBCLK
     EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up
     EPwm3Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
     EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
     EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;

     EPwm3Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
     EPwm3Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
     EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
     EPwm3Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

     // Setup compare
      EPwm3Regs.CMPA.half.CMPA = EPwm1Regs.CMPA.half.CMPA>>1;

      EPwm3Regs.ETSEL.bit.INTSEL = ET_CTRU_CMPA;//   ET_CTR_ZERO;     // Select INT on Zero event
      EPwm3Regs.ETSEL.bit.INTEN = 1;                // Enable INT
      EPwm3Regs.ETPS.bit.INTPRD = ET_1ST	;//	ET_3RD;
/*
      EPwm3Regs.ETSEL.bit.SOCAEN	= 1;		// Enable SOC on A group
      EPwm3Regs.ETSEL.bit.SOCASEL	= 4;		// Select SOC from from CPMA on upcount
      EPwm3Regs.ETPS.bit.SOCAPRD 	= 1;		// Generate pulse on 1st event
*/


        EALLOW;
      //  EPwm1Regs.TZSEL.bit.OSHT1 = 1;
        EPwm1Regs.TZSEL.bit.OSHT2 = 1;

        // What do we want the TZ1 and TZ2 to do?
        EPwm1Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
        EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

        EPwm2Regs.TZSEL.bit.OSHT2 = 1;

               // What do we want the TZ1 and TZ2 to do?
         EPwm2Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
         EPwm2Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

        // Enable TZ interrupt
   //     EPwm1Regs.TZEINT.bit.OST = 1;
        EDIS;


}


#if(0)

void Init_EPwm()
{

   EPwm1Regs.TBPRD = 1500 ;                        // Set timer period
   EPwm1Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm1Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN	; // Count up
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
   EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;

   EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
   EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
   EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

   // Setup compare
   EPwm1Regs.CMPA.half.CMPA = 1400;
   EPwm1Regs.CMPB= EPwm1Regs.TBPRD -EPwm1Regs.CMPA.half.CMPA;


        EPwm1Regs.AQCTLA.bit.ZRO = AQ_SET;             // Set PWM1A on Zero
        EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;
        EPwm1Regs.AQCTLB.bit.PRD = AQ_SET;          // Set PWM1A on Zero
        EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;


/*

   // Active Low PWMs - Setup Deadband
   EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
   EPwm1Regs.DBCTL.bit.POLSEL = 1;  //DB_ACTV_LO;         //pwm 
   EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;
   EPwm1Regs.DBRED = EPWM1_MIN_DB;
   EPwm1Regs.DBFED = EPWM1_MIN_DB;
   EPwm1_DB_Direction = DB_UP;
   // Interrupt where we will change the Deadband
 //  EPwm1Regs.ETSEL.bit.INTSEL = ET_CTRU_CMPA;//   ET_CTR_ZERO;     // Select INT on Zero event
  // EPwm1Regs.ETSEL.bit.INTEN = 1;                // Enable INT
  // EPwm1Regs.ETPS.bit.INTPRD = 	ET_3RD;           // Generate INT on 3rd event

*/


     EPwm3Regs.TBPRD = 1500  ;                        // Set timer period
     EPwm3Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
     EPwm3Regs.TBCTR = 0x0000;                      // Clear counter

     // Setup TBCLK
     EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
     EPwm3Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
     EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
     EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;

     EPwm3Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
     EPwm3Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
     EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
     EPwm3Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

     // Setup compare
     EPwm3Regs.CMPA.half.CMPA = EPwm1Regs.CMPA.half.CMPA>>1;
     EPwm1Regs.CMPB= (EPwm1Regs.TBPRD -EPwm1Regs.CMPA.half.CMPA)>>1;


      EPwm3Regs.ETSEL.bit.INTSEL = ET_CTRU_CMPA;//   ET_CTR_ZERO;     // Select INT on Zero event
      EPwm3Regs.ETSEL.bit.INTEN = 1;                // Enable INT
      EPwm3Regs.ETPS.bit.INTPRD = ET_1ST	;//	ET_3RD;


}

#endif





