#include "../sys_include/F28x_Project.h"

//initialize DAC pointer
volatile struct DAC_REGS* DAC_PTR[4] = {0x0,&DacaRegs,&DacbRegs,&DaccRegs};

//definitions for selecting DAC reference
#define REFERENCE_VDAC		0
#define REFERENCE_VREF		1

//definitions for DAC number
#define DACA				1
#define DACB				2
#define DACC				3

//specify configuration
#define REFERENCE			REFERENCE_VDAC
#define DAC_NUM				DACA
Uint16 dacval = 2048;

//local functions
void configureDAC(Uint16 dac_num);
void delay(Uint16 num);
void main(void)
{
	InitSysCtrl();
	DINT;
	InitPieCtrl();

	IER = 0x0000;
	IFR = 0x0000;
	InitPieVectTable();

	EALLOW;
	GpioCtrlRegs.GPAPUD.bit.GPIO20 = 0;
	GpioCtrlRegs.GPAPUD.bit.GPIO21 = 0;
	GpioCtrlRegs.GPAQSEL2.bit.GPIO20 = 1;
	GpioCtrlRegs.GPAQSEL2.bit.GPIO21 = 1;
	GpioCtrlRegs.GPAMUX2.bit.GPIO20 = 0;
	GpioCtrlRegs.GPAMUX2.bit.GPIO21 = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO20 = 1;
	GpioCtrlRegs.GPADIR.bit.GPIO21 = 1;
	EDIS;

// Configure DAC
	configureDAC(DAC_NUM);

	while(1)
	{
//		GpioDataRegs.GPADAT.bit.GPIO20 = 1;
//		GpioDataRegs.GPADAT.bit.GPIO21 = 1;
		DAC_PTR[DAC_NUM]->DACVALS.all = dacval;
	//	DELAY_US(2);
		delay(10000);
//		GpioDataRegs.GPADAT.bit.GPIO20 = 0;
//		GpioDataRegs.GPADAT.bit.GPIO21 = 0;
		delay(10000);
	}
}

void configureDAC(Uint16 dac_num)
{
	EALLOW;
	DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;//VDAC/VSSAصѹ
	DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;//ʹDAC
	DAC_PTR[dac_num]->DACVALS.all = 0;
//	DELAY_US(10); // Delay for buffered DAC to power up
	delay(500);
	EDIS;
}

void delay(Uint16 num)
{
	Uint16 i = 0;
	for (i=0; i<num; i++)
		;
}
