/**********************************************************************
* File: F28335_example.h
* Device: TMS320F28335
* Author: David M. Alter, Texas Instruments Inc.
* Description: Include file for example project.  Include this file in
*   all C-source files.
* Notes:
*   1) The following constants may be defined in the CCS project build
*      options:
*        EXAMPLE_NONBIOS
*        EXAMPLE_BIOS
*        EXAMPLE_FLASH
*        EXAMPLE_RAM
* History:
*   03/15/08 - Added prototype for InitXintf() (D. Alter)
*   12/13/07 - original (D. Alter)
**********************************************************************/

#ifndef F28335_EXAMPLE_H
#define F28335_EXAMPLE_H


//---------------------------------------------------------------------------
// Constant Definitions
//
#define ADC_MODCLK 0x3                     //ADC CLK  150/(2*3)=25MHz 
#define BUF_SIZE 64*2
#define ADC_BUF_LEN			64				// ADC buffer length
#define ADC_SAMPLE_PERIOD	2999			// 2999 = 50 KHz sampling w/ 150 MHz SYSCLKOUT
#define PWM_HALF_PERIOD		37500			// period/2 for 2 kHz symmetric PWM
#define PWM_DUTY_CYCLE		28125			// 25% duty cycle
#define CPU_FRQ_150MHZ  1
#define CPU_FRQ_100MHZ  0
// FFT Parameters
#define CFFT_STAGES 6  //Ϊ64
#define CFFT_SIZE (1 << CFFT_STAGES)
#define START_FREQ 0x4AE5

//---------------------------------------------------------------------------
// Include Standard C Language Header Files
//
#include <string.h>
#include <FPU.h>

//---------------------------------------------------------------------------
// Include any other Header Files
//
#ifdef EXAMPLE_NONBIOS
	#include "DSP2833x_DefaultIsr.h"		// ISR definitions
#endif

#ifdef EXAMPLE_BIOS
	#ifdef EXAMPLE_FLASH
	    #include "F28335_example_BIOS_flashcfg.h"
	#endif

	#ifdef EXAMPLE_RAM
	    #include "F28335_example_BIOS_ramcfg.h"
	#endif
#endif


//---------------------------------------------------------------------------
// Function Prototypes
//
extern void DelayUs(Uint16);
extern void InitAdc(void);
//extern void InitECap(void);
//extern void InitEPwm(void);
extern void InitDma(void);
extern void StartDMACH1(void);
extern void InitMcbsp(void);
extern void gpio_cfg(void);
extern void led(int num);
extern void init_timer(void);
#ifdef EXAMPLE_FLASH
	extern void InitFlash(void);
#endif

extern void InitGpio(void);
extern void InitPieCtrl(void);
extern void InitSysCtrl(void);
extern void InitWatchdog(void);
extern void InitXintf(void);
extern void SetDBGIER(Uint16);

#ifdef EXAMPLE_BIOS
	extern void UserInit(void);
#endif


//---------------------------------------------------------------------------
// Global symbols defined in the linker command file
//
#ifdef EXAMPLE_BIOS
	extern Uint16 hwi_vec_loadstart;
	extern Uint16 hwi_vec_loadend;
	extern Uint16 hwi_vec_runstart;
	extern Uint16 trcdata_loadstart;
	extern Uint16 trcdata_loadend;
	extern Uint16 trcdata_runstart;
#endif

#ifdef EXAMPLE_FLASH
	extern Uint16 secureRamFuncs_loadstart;
	extern Uint16 secureRamFuncs_loadend;
	extern Uint16 secureRamFuncs_runstart;
#endif


//---------------------------------------------------------------------------
// Global Variable References
//
extern float  	CFFTin1Buff[CFFT_SIZE*2];                  //Output of FFT overwrites input if                                                //CFFT_STAGES is OD
extern float	CFFTin2Buff[CFFT_SIZE*2];               //Additional Buffer used in Magnitude calc
extern float	CFFToutBuff[CFFT_SIZE*2];               //Output of FFT here if CFFT_STAGES is EVEN
extern float	CFFTF32Coef[CFFT_SIZE];                 //Twiddle buffer

extern volatile Uint16 DMABuf1[BUF_SIZE];
extern Uint16 AdcBuf[ADC_BUF_LEN];			// ADC data buffer allocation
extern Uint32 PwmDuty;						// Measured PWM duty cycle
extern Uint32 PwmPeriod;					// Measured PWM period

#ifdef EXAMPLE_NONBIOS
	extern const struct PIE_VECT_TABLE PieVectTableInit;	// Pie vector table (non-BIOS only)
#endif


//---------------------------------------------------------------------------
// Macros
//
#define ADC_cal_func_ptr (void (*)(void))0x380080


//---------------------------------------------------------------------------
#endif  // end of F28335_EXAMPLE_H definition


//--- end of file -----------------------------------------------------
