/**********************************************************************
* File: Dma.c -- File for Labs 9, 10 and 12
* Devices: TMS320F2833x
* Author: Technical Training Organization (TTO), Texas Instruments
* History:
*   07/15/08 - original
**********************************************************************/

#include "DSP2833x_Device.h"			// Peripheral address definitions
#include "F28335_example.h"							// Main include file


/**********************************************************************
* Function: InitDma()
*
* Description: Initializes the DMA on the F2833x
**********************************************************************/
void InitDma(void)
{
	asm(" EALLOW");								// Enable EALLOW protected register access

//---------------------------------------------------------------------
//--- Overall DMA setup
//---------------------------------------------------------------------
	DmaRegs.DMACTRL.bit.HARDRESET = 1;			// Reset entire DMA module
	asm(" NOP");								// 1 cycle delay for HARDRESET to take effect

	DmaRegs.DEBUGCTRL.bit.FREE = 1;				// 1 = DMA unaffected by emulation halt
	DmaRegs.PRIORITYCTRL1.bit.CH1PRIORITY = 0;	// Not using CH1 Priority mode

//---------------------------------------------------------------------
//--- Configure DMA channel 1 to read the ADC results         
//---------------------------------------------------------------------
	DmaRegs.CH1.MODE.all = 0x8901;
// bit 15        1:      CHINTE, 0=interrupt disabled, 1=interrupt enabled
// bit 14        0:      DATASIZE, 0=16-bit, 1=32-bit
// bit 13        0:      SYNCSEL, sync select, don't care
// bit 12        0:      SYNCE, ADC sync enable, 0=disabled, 1=enabled
// bit 11        1:      CONTINUOUS, 0=stop, 1=re-init after transfer complete
// bit 10        0:      ONESHOT, 0=one burst on trigger, 1=all bursts on trigger
// bit 9         0:      CHINTMODE, 0=start of transfer, 1=end of transfer
// bit 8         1:      PERINTE, peripheral interrupt trigger enable, 0=disabled, 1=enabled
// bit 7         0:      OVRINTE, overflow interrupt enable, 0=disabled, 1=enabled
// bit 6-5       00:     reserved
// bit 4-0       00001:  PERINTSEL, 1=ADC SEQ1INT

// Set up BURST registers:
	DmaRegs.CH1.BURST_SIZE.all = 1;	                // Number of words(X-1) x-ferred in a burst
	DmaRegs.CH1.SRC_BURST_STEP = 1;			    // Increment source addr between each word x-ferred
	DmaRegs.CH1.DST_BURST_STEP = 64;              // Increment dest addr between each word x-ferred
//	DmaRegs.CH1.BURST_SIZE.bit.BURSTSIZE = 0;							// 0 means 1 word per burst
	DmaRegs.CH1.TRANSFER_SIZE = ADC_BUF_LEN-1;							// ADC_BUF_LEN bursts per transfer

	DmaRegs.CH1.SRC_TRANSFER_STEP = -1;	//1								// 1 means add 1 to pointer each burst in a transfer
	DmaRegs.CH1.SRC_WRAP_SIZE = 1000;//15;										// 15 means wrap after 16 bursts
	DmaRegs.CH1.SRC_WRAP_STEP = 1000; // 0;										// 0 means no change to wrap address on wrap
	DmaRegs.CH1.SRC_ADDR_SHADOW = (Uint32)&AdcMirror.ADCRESULT0;		// SRC start address
	DmaRegs.CH1.SRC_BEG_ADDR_SHADOW =(Uint32) &AdcMirror.ADCRESULT0;	// SRC wrap start address

	DmaRegs.CH1.DST_TRANSFER_STEP =-(ADC_BUF_LEN-1);// 1;									// 1 = add 1 to pointer each burst in a transfer
	DmaRegs.CH1.DST_WRAP_SIZE = 0xFFFF;									// make greater than TRANSFER_SIZE to not use wrap feature
	DmaRegs.CH1.DST_ADDR_SHADOW =(Uint32)DMABuf1;					// DST start address
	DmaRegs.CH1.DST_BEG_ADDR_SHADOW = (Uint32)DMABuf1;//DMABuf1;	    // Point to beginning of destination buffer
	DmaRegs.CH1.CONTROL.all = 0x00D0;
// bit 15        0:      reserved
// bit 14        0;      OVRFLG, overflow flag, read-only
// bit 13        0;      RUNSTS, run status, read-only
// bit 12        0;      BURSTSTS, burst status, read-only
// bit 11        0;      TRANSFERSTS, transfer status, read-only
// bit 10        0;      SYNCERR, sync error, read-only
// bit 9         0;      SYNCFLG, sync flag, read-only
// bit 8         0;      PERINTFLG, read-only
// bit 7         1;      ERRCLR, error clear, 0=no action, 1=clear SYNCERR bit
// bit 6         1;      SYNCCLR, sync clear, 0=no action, 1=clear SYNCFLG bit
// bit 5         0;      SYNCFRC, sync force, 0=no action, 1=force sync event
// bit 4         1;      PERINTCLR, periph event clear, 0=no action, 1=clear periph event
// bit 3         0;      PERINTFRC, periph event force, 0=no action, 1=force periph event
// bit 2         0;      SOFTRESET, 0=no action, 1=soft reset the channel
// bit 1         0;      HALT, 0=no action, 1=halt the channel
// bit 0         0;      RUN, 0=no action, 1=enable the channel

//--- Finish up
	asm(" EDIS");						// Disable EALLOW protected register access

//--- Enable the DMA interrupt
	PieCtrlRegs.PIEIER7.bit.INTx1 = 1;	// Enable DINTCH1 in PIE group 7
	IER |= 0x0040;						// Enable INT7 in IER to enable PIE group

} // end InitDma()

void StartDMACH1(void)
{
	EALLOW;
	DmaRegs.CH1.CONTROL.bit.RUN = 1;
	EDIS;
}
//*** end of file *****************************************************
