/**********************************************************************
* File: Main_BIOS.c
* Devices: TMS320F2833x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "DSP2833x_Device.h"			// Peripheral address definitions
#include "F28335_example.h"				// Main include file

//--- Global Variables
#pragma DATA_SECTION(CFFTin1Buff,"CFFTdata1");
float CFFTin1Buff[CFFT_SIZE*2];                  //Output of FFT overwrites input if 
                                                //CFFT_STAGES is ODD

#pragma	DATA_SECTION(CFFTin2Buff,"CFFTdata2");  
float	CFFTin2Buff[CFFT_SIZE*2];               //Additional Buffer used in Magnitude calc

#pragma	DATA_SECTION(CFFToutBuff,"CFFTdata3");	
float	CFFToutBuff[CFFT_SIZE*2];               //Output of FFT here if CFFT_STAGES is EVEN

#pragma	DATA_SECTION(CFFTF32Coef,"CFFTdata4"); 
float	CFFTF32Coef[CFFT_SIZE];                 //Twiddle buffer
CFFT_F32_STRUCT cfft;

#pragma DATA_SECTION(ADC,"secureRamFuncs");
volatile float ADC[BUF_SIZE];
#pragma DATA_SECTION(DMABuf1,"secureRamFuncs");
volatile Uint16 DMABuf1[BUF_SIZE];
Uint16 AdcBuf[ADC_BUF_LEN];				// ADC data buffer allocation
//Uint32 PwmDuty;							// Measured PWM duty cycle
//Uint32 PwmPeriod;						// Measured PWM period
float ADC_Result[BUF_SIZE]={0};
Uint32 freq;
Uint16 freq_mark,conside_tag,alarm_flag=0;
Uint32 int1_count=0;
Uint32 int2_count=0;
Uint16 count=0;
Uint16 sample_count1,flag,freq_num;
void mcbspb_xmit(int a, int b);
void mcbspa_AGC(int a);
void dds_init4();
void delayxms(Uint32 xms);
/**********************************************************************
* Function: main()
*
* Description: Main function for F280x example.
**********************************************************************/
void main(void)
{
    Uint16 i;
    conside_tag=0;
    freq=0x4AE5;
	flag=0;
	freq_num=0;
    sample_count1=0;
//--- CPU Initialization
	InitSysCtrl();						// Initialize the CPU
	EALLOW;
    SysCtrlRegs.HISPCP.all = ADC_MODCLK;	// HSPCLK = SYSCLKOUT/ADC_MODCLK
    EDIS;
	InitPieCtrl();						// Initialize and enable the PIE
	InitWatchdog();						// Initialize the Watchdog Timer
	InitGpio();							// Initialize the shared GPIO pins
	InitXintf();						// Initialize the external memory interface
    InitMcbsp();
	gpio_cfg();
#ifdef EXAMPLE_FLASH					// EXAMPLE_FLASH, if defined, is in CCS project options

//--- Copy all Flash sections that need to run from RAM (use memcpy() from RTS library)

// Section secureRamFuncs contains user defined code that runs from CSM secured RAM
	memcpy(	&secureRamFuncs_runstart,
			&secureRamFuncs_loadstart,
			&secureRamFuncs_loadend - &secureRamFuncs_loadstart);

//--- Initialize the Flash and OTP
	InitFlash();						// Initialize the Flash

#endif
    
//--- Peripheral Initialization
	InitAdc();							// Initialize the ADC
//	InitEPwm();							// Initialize the PWM
//	InitECap();							// Initialize the Capture units
    InitDma();
	led(0);
    for (i=0; i<BUF_SIZE; i++)
	{
	  DMABuf1[i] = 0xffff;
	}
    for (i=0; i<BUF_SIZE; i++)
	{
		ADC_Result[i] = 0.0;
	}
	

//--- Enable interrupts
	SetDBGIER(IER | 0x6000);							// Enable everything in IER, plus TINT2 and DLOGINT
	*(volatile unsigned int *)0x00000C14 |= 0x0C00;		// Set TIMER2 FREE=SOFT=1

    // DSP/BIOS will enable global interrupts (INTM and DBGM)

    init_timer();  //ʱ׼ԼʱBIOSκ
	PRD_start(&Timer0_PRD);   //TIMER0_PRD,TIMER1_PRDóone-shot mode
    PRD_start(&Timer1_PRD);
} // end of main()



/**********************************************************************
* Function: UserInit()
*
* Description: This is the user initialization file to be specified in
* the DSP/BIOS configuration file, System - Global Settings.
**********************************************************************/
void UserInit(void)
{
#ifdef EXAMPLE_FLASH					// EXAMPLE_FLASH, if defined, is in CCS project options

// Section .trcdata is generated by DSP/BIOS.
// It must be copied from its load to its run address BEFORE main().
	memcpy(&trcdata_runstart, &trcdata_loadstart, &trcdata_loadend - &trcdata_loadstart);

#endif

} // end of UserInit()

void DDSwork()  //dds_task
{
    int mag=69;
//	led(0);
	dds_init4();
	mcbspb_xmit(freq,0);
    mcbspa_AGC(mag);
}

/**********************************************************************
* Function: LedBlink()
*
* Description: Blinks LED on eZdspF28335 board.
**********************************************************************/
/*void LedBlink(void)
{
static Uint16 LedPrdCount=0;					// Used for LOG_printf example

	GpioDataRegs.GPBTOGGLE.bit.GPIO32 = 1;		// Toggle the pin

//--- Show an example of using LOG_printf() to write to a log buffer
	LOG_printf(&trace, "LedPrdCount = %u", LedPrdCount++);

} // end of LedBlink()
*/
/**********************************************************************
* Function: Timer0Func()
*
* Description: PRD interrupt TIMER0 swi
**********************************************************************/
void Timer0Func()
{
	int1_count++;
	//CpuTimer0Regs.TCR.bit.TSS = 1;   //ж
	if(int1_count==1){
       if(flag) GpioDataRegs.GPADAT.bit.GPIO3=0; //gpio30----gpio3  5us
       else GpioDataRegs.GPADAT.bit.GPIO1=0; //5us
	   DelayUs(2);
       GpioDataRegs.GPACLEAR.bit.GPIO13=1;  //50us
//       AdcRegs.ADCTRL2.bit.SOC_SEQ1=0x1;  //ADC
//	   StartDMACH1();
	}
    PRD_start(&Timer0_PRD);  //	CpuTimer0Regs.TCR.bit.TSS = 0;    //ʱ0ж
	if(int1_count==11)   //5usپ50us
	{
		GpioDataRegs.GPASET.bit.GPIO13=1;  //50us
		AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1 = 0x0; //50usֹADC_seqж
     	PRD_stop(&Timer0_PRD);//	CpuTimer0Regs.TCR.bit.TSS = 1;    //ж
	}
}

/**********************************************************************
* Function: Timer1Func()
*
* Description: PRD interrupt TIMER1 swi
**********************************************************************/
void Timer1Func()
{
//	PRD_stop(&Timer1_PRD);//CpuTimer1Regs.TCR.bit.TSS = 1;   //ж
    LOG_printf(&trace, "ticks = %d", PRD_getticks()); 
    int2_count++;
    sample_count1++;
	if(sample_count1>9)
	{
	    sample_count1=0;  
	}
   	if(int2_count==5)
   	{  // 8.0<->count=0 8.12<->count=4
    
	    flag=1;
	    GpioDataRegs.GPACLEAR.bit.GPIO15=1;
	    GpioDataRegs.GPASET.bit.GPIO16=1;
		GpioDataRegs.GPADAT.bit.GPIO1=0; //5us
	    GpioDataRegs.GPASET.bit.GPIO3=1;
    }
   if(int2_count==10)
   {
	    freq=freq-0x000b;
		freq_num++;
	    int2_count=0;//  CpuTimer1.InterruptCount=0;  //¿ʼ1,freqż
	    flag=0;
	    GpioDataRegs.GPASET.bit.GPIO15=1;
	    GpioDataRegs.GPACLEAR.bit.GPIO16=1;
	    GpioDataRegs.GPADAT.bit.GPIO3=0;
	    GpioDataRegs.GPASET.bit.GPIO1=1;
    }
   if(flag)GpioDataRegs.GPADAT.bit.GPIO3=1;  //5usø׼
   else GpioDataRegs.GPADAT.bit.GPIO1=1;
   GpioDataRegs.GPASET.bit.GPIO13=1;  //50usø׼
   PRD_start(&Timer0_PRD);    //CpuTimer0Regs.TCR.bit.TSS = 0;    //ʱ0ж
   int1_count=0;
   mcbspb_xmit(freq,0);
   if(freq_num==16){freq=0x4AE5;int2_count=0;freq_num=0;}
   PRD_start(&Timer1_PRD);   //CpuTimer1Regs.TCR.bit.TSS = 0;   //ʱ1ж
}

/**********************************************************************
* Function: AdcSwi()
*
* Description: ADC interrupt SWI
**********************************************************************/
void AdcSwi(void)
{
static Uint16 *AdcBufPtr = AdcBuf;				// Pointer to buffer

//--- Manage the ADC registers
	AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;			// Reset SEQ1 to CONV00 state
	AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;			// Clear ADC SEQ1 interrupt flag

//--- Read the ADC result
	*AdcBufPtr++ = AdcRegs.ADCRESULT0 >> 4;		// Read the result

//--- Brute-force the circular buffer
	if( AdcBufPtr == (AdcBuf + ADC_BUF_LEN) )
		AdcBufPtr = AdcBuf;						// Rewind the pointer to beginning

} // end of AdcSwi()

void Dma1Swi(void)
{
 /*   Uint16 i,m,t;
    static int16 y[10][40]={0};
    int16 correl_value=0;
	int max;
    int16 correl_freq[16];
	Uint16 vm;
	float fft_sum=0;
	static float fft_ref=0;
	float v_time=0;
	vm=0;
    AdcRegs.ADCST.bit.INT_SEQ1_CLR = 0x1; //ADCת־
	for(i=0; i < (CFFT_SIZE*2); i=i+2)
	{
		CFFTin1Buff[i] = 0.0f;
		CFFTin1Buff[i+1] = 0.0f;
		CFFTin2Buff[i] = 0.0f;
		CFFTin2Buff[i+1] = 0.0f;
		CFFToutBuff[i] = 0.0f;
		CFFToutBuff[i+1] = 0.0f;
	} 
	for (i=0; i<BUF_SIZE; i++)
    {
         ADC[i] =(float) DMABuf1[i] * 3.0 / 4095.0 ;
         ADC_Result[i]+=ADC[i];
		// 
		if(i<40)
		{
		   if(ADC[i]>2.5) y[sample_count1][i]=1; 
		   else if(ADC[i]>1.5)y[sample_count1][i]=0;
		   else y[sample_count1][i]=-1;
		}   
    }
		
	if(sample_count1==9)
	{  
	    for(t=0;t<7;t++){
		   for(i=0;i<40;i++){
	          correl_value+=y[t][i]*y[t+3][i];
		   }
		}
		correl_freq[freq_num]=correl_value;
		max=correl_freq[0];
		for(i=1;i<freq_num;i++)
		if(correl_freq[i]>max) {max=correl_freq[i];freq_mark=i;}
		if(max>20) conside_tag=1;
   }*/
}
void idleFunc()
{
    Uint16 hold;
  	if(conside_tag)
	{
		   GpioDataRegs.GPACLEAR.bit.GPIO1=1;  //5usø׼1
	       PRD_stop(&Timer0_PRD);   //StopCpuTimer0();
    	   PRD_stop(&Timer1_PRD);   //StopCpuTimer1();
        	count=0;
            led(5);
			hold=START_FREQ-freq_mark*0x000b;
			mcbspb_xmit(hold,0);
			delayxms(1000);
			init_timer();
		    PRD_start(&Timer0_PRD);    //	StartCpuTimer0();
		    PRD_start(&Timer1_PRD);    //  StartCpuTimer0();
             led(0);
			 alarm_flag=0;

     } 

       else alarm_flag=0;  
	   conside_tag=0;     
}
/*-------------------------------------------------------------------------------------*/
void dds_init4()
{
   mcbspb_xmit(0x2138,0);
   mcbspb_xmit(0x2038,0);
   mcbspb_xmit(0xE000,0);
   mcbspb_xmit(0x7439,0);
   //mcbspb_xmit(0x4003,0);
   mcbspb_xmit(0x1038,0);  //1038Ϊ1028ĿSIGN BIT OUTƵʼĴMSB
   DelayUs(80);
   mcbspb_xmit(0x4000,0);
   DelayUs(80);
   mcbspb_xmit(0x4B22,0); //ƵʼĴ0дMSB=0B22  
   //mcbspb_xmit(0x4223,0);
   mcbspb_xmit(0xE000,0);  //λĴ10
   mcbspb_xmit(0xD000,0);  //λĴ00

}

/*-------------------------------------------------------------------------------------------*/
void error(void)
{
    asm("     ESTOP0");  // test failed!! Stop!
    for (;;);
}
/*---------------------------------------------------------------------------------------------*/
void mcbspb_xmit(int a, int b)
{
  //  McbspbRegs.DXR2.all=b;
    McbspbRegs.DXR1.all=a;
}
/*----------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------------*/
void mcbspa_AGC(int a)
{
   McbspaRegs.DXR1.all=a;
}
void delayxms(Uint32 xms)
{
	Uint32 i,j;
	i=15000;
	j=xms*i;

    while(j>0)
	  j--;
}
//--- end of file -----------------------------------------------------
