//#############################################################################
//
//! \file  Application\Isr.c
//!
//! \brief  Interrupt Service Routine
//
//  Author:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2014, Texas Instruments, Inc.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "Application/isr.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions

//interrupt void isr(void)
//{
//
//    // Acknowledge this interrupt to get more from group 1
//    PIE_clearInt(myPie, PIE_GroupNumber_1);
//
//}


//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void KEY_XINT1_isr(void)
{
    LED_toggle(LED1);

	// Acknowledge this interrupt to get more from group 1
	//void PIE_clearInt(PIE_Handle pieHandle,const PIE_GroupNumber_e groupNumber)
	PIE_clearInt(myPie, PIE_GroupNumber_1);

}


//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void KEY_XINT2_isr(void)
{
    LED_toggle(LED1);

	// Acknowledge this interrupt to get more from group 1
	//void PIE_clearInt(PIE_Handle pieHandle,const PIE_GroupNumber_e groupNumber)
	PIE_clearInt(myPie, PIE_GroupNumber_1);

}

//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void cpu_timer0_isr(void)
{
    LED_toggle(LED1);


	// Acknowledge this interrupt to get more from group 1
	//void PIE_clearInt(PIE_Handle pieHandle,const PIE_GroupNumber_e groupNumber)
	PIE_clearInt(myPie, PIE_GroupNumber_1);
	//void TIMER_clearFlag(TIMER_Handle timerHandle)
	TIMER_clearFlag(myTimer0);

}

//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void cap1_isr(void)
{
	uint32_t captemp1,captemp2;

	//uint32_t CAP_getCap1(CAP_Handle capHandle)
	captemp1 = CAP_getCap1(myCap1);
	captemp2 = CAP_getCap2(myCap1);

	//ģʽ
	myPeroid1 = captemp1 - myCapVal1;
	myPeroid2 = captemp2 - myCapVal2;

	myHigh = captemp2 - captemp1;
    //ģʽ
	myPeroid1 = captemp1;
	myHigh = captemp2;

	myCapVal1 = captemp1;
	myCapVal2 = captemp2;

		// Acknowledge this interrupt to get more from group 4
	//void PIE_clearInt(PIE_Handle pieHandle,const PIE_GroupNumber_e groupNumber)
	PIE_clearInt(myPie, PIE_GroupNumber_4);
	//void CAP_clearInt(CAP_Handle capHandle, const CAP_Int_Type_e intType)
	CAP_clearInt(myCap1, CAP_Int_Type_CEVT2);
	CAP_clearInt(myCap1, CAP_Int_Type_Global);
}

//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void pwm1_isr(void)
{
	myCmpA1 +=10 ;
	if(myCmpA1 >= 60000) myCmpA1 = 0;

	PWM_setCmpA(myPwm1,myCmpA1);

	// Acknowledge this interrupt to get more from group 3
	PIE_clearInt(myPie, PIE_GroupNumber_3);
	//void PWM_clearIntFlag(PWM_Handle pwmHandle)
	PWM_clearIntFlag(myPwm1);

}

//! \brief     Interrupt Service Routine
//! \param[in] None
//! \param[out] None
interrupt void adc1_isr(void)
{
//    uint16_t dat;

	Temp = ADC_readResult(myAdc, ADC_ResultNumber_0);
	TempC = ADC_getTemperatureC(myAdc, Temp);

/*	dat = TempC - 25;
	if(dat & 0x1)  LED_on(LED1);
	else LED_off(LED1);

	if(dat & 0x2)  LED_on(LED2);
	else LED_off(LED2);

	if(dat & 0x4)  LED_on(LED3);
	else LED_off(LED3);

	if(dat & 0x8)  LED_on(LED4);
	else LED_off(LED4);
*/

	// Acknowledge this interrupt to get more from group 1
	PIE_clearInt(myPie, PIE_GroupNumber_1);
	//void ADC_clearIntFlag(ADC_Handle adcHandle, const ADC_IntNumber_e intNumber)
	ADC_clearIntFlag(myAdc, ADC_IntNumber_1);

}


// end of file
