//#############################################################################
//
//! \file   User_Component/KEY/KEY.c
//!
//! \brief   Get KEY status by GPIO
//!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/KEY/KEY.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions

// (1) module Initial
//! \brief     KEY module initial
//! \param[in] None
//! \param[out] None
void KEY_initial(void)
{
	Flag = 0;
	KeyCount = 0;
}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     KEY Pin configure
//! \param[in] None
//! \param[out] None
void KEY_pinConfigure(void)
{   //1. set pullup
	//void GPIO_setPullUp(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_PullUp_e pullUp);
	GPIO_setPullUp(myGpio, GPIO_Number_12, GPIO_PullUp_Disable);

	//2. set mode
	//void GPIO_setMode(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Mode_e mode);
	GPIO_setMode(myGpio, GPIO_Number_12, GPIO_12_Mode_GeneralPurpose);

	//3. set direction
	//void GPIO_setDirection(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Direction_e direction);
	GPIO_setDirection(myGpio, GPIO_Number_12, GPIO_Direction_Input);

	//4. filter
	//void GPIO_setQualification(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const GPIO_Qual_e qualification);
	//void GPIO_setQualificationPeriod(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const uint16_t period);
	GPIO_setQualification(myGpio, GPIO_Number_12, GPIO_Qual_ASync);
}
//
// (2.2) module function configure
//! \brief     KEY function configure
//! \param[in] None
//! \param[out] None
void KEY_functionConfigure(void)
{


}
//
// (2.3) module Event configure
//! \brief     KEY Event configure
//! \param[in] None
//! \param[out] None
void KEY_eventConfigure(void)
{   //1. set xint
	//void GPIO_setExtInt(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const CPU_ExtIntNumber_e intNumber)
	GPIO_setExtInt(myGpio, GPIO_Number_12, CPU_ExtIntNumber_2);

	//2. set polarity
	//void PIE_setExtIntPolarity(PIE_Handle pieHandle,
	//                           const CPU_ExtIntNumber_e intNumber,
	//                           const PIE_ExtIntPolarity_e polarity)
	PIE_setExtIntPolarity(myPie, CPU_ExtIntNumber_2, PIE_ExtIntPolarity_FallingEdge);

}
                      
// **************************************************************************
// the API functions
//! \brief     Get Key Status
//! \param[in] key
//! \param[out] key stautus
uint16_t GetKeyStatus(GPIO_Number_e key)
{
	//uint16_t GPIO_getData(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber);
	return GPIO_getData(myGpio, key);
}


// end of file
