//#############################################################################
//
//! \file   User_Component/LED_PWM/LED_PWM.c
//!
//! \brief   LED Control by EPWM
//!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/LED_PWM/LED_PWM.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions

// (1) module Initial
//! \brief     LED_PWM module initial
//! \param[in] None
//! \param[out] None
void LED_PWM_initial(void)
{
	myCmpA1 = 0;

}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     LED_PWM Pin configure
//! \param[in] None
//! \param[out] None
void LED_PWM_pinConfigure(void)
{   //1. set pullup
	//void GPIO_setPullUp(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_PullUp_e pullUp);
	GPIO_setPullUp(myGpio, GPIO_Number_0, GPIO_PullUp_Disable);
	GPIO_setPullUp(myGpio, GPIO_Number_1, GPIO_PullUp_Disable);
	GPIO_setPullUp(myGpio, GPIO_Number_2, GPIO_PullUp_Disable);
	GPIO_setPullUp(myGpio, GPIO_Number_3, GPIO_PullUp_Disable);

	//2. set mode
	//void GPIO_setMode(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Mode_e mode);
	GPIO_setMode(myGpio, GPIO_Number_0, GPIO_0_Mode_EPWM1A);
	GPIO_setMode(myGpio, GPIO_Number_1, GPIO_1_Mode_EPWM1B);
	GPIO_setMode(myGpio, GPIO_Number_2, GPIO_2_Mode_EPWM2A);
	GPIO_setMode(myGpio, GPIO_Number_3, GPIO_3_Mode_EPWM2B);

	//3. set direction
	//void GPIO_setDirection(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Direction_e direction);
	GPIO_setDirection(myGpio, GPIO_Number_0, GPIO_Direction_Output);
	GPIO_setDirection(myGpio, GPIO_Number_1, GPIO_Direction_Output);
	GPIO_setDirection(myGpio, GPIO_Number_2, GPIO_Direction_Output);
	GPIO_setDirection(myGpio, GPIO_Number_3, GPIO_Direction_Output);

}
//
// (2.2) module function configure
//! \brief     LED_PWM function configure
//! \param[in] None
//! \param[out] None
void LED_PWM_functionConfigure(void)
{
	//1. TBClkSYNC = 0
	//void CLK_disableTbClockSync(CLK_Handle clkHandle)
	CLK_disableTbClockSync(myClk);
	//2. set TBCLK
	//void PWM_setHighSpeedClkDiv(PWM_Handle pwmHandle,const PWM_HspClkDiv_e clkDiv);
	//void PWM_setClkDiv(PWM_Handle pwmHandle,const PWM_ClkDiv_e clkDiv);
	PWM_setHighSpeedClkDiv(myPwm1, PWM_HspClkDiv_by_1);
	PWM_setClkDiv(myPwm1, PWM_ClkDiv_by_1);
	//3. set TBCTR Mode
	//void PWM_setCounterMode(PWM_Handle pwmHandle,const PWM_CounterMode_e counterMode);
	PWM_setCounterMode(myPwm1, PWM_CounterMode_Up);
	//4. set Period
	//void PWM_setPeriod(PWM_Handle pwmHandle, const uint16_t period)
	//void PWM_setPeriodLoad(PWM_Handle pwmHandle, const PWM_PeriodLoad_e periodLoad)
	PWM_setPeriod(myPwm1, 60000);
	PWM_setPeriodLoad(myPwm1, PWM_PeriodLoad_Shadow);
	//5. set CMPA
	//void PWM_setCmpA(PWM_Handle pwmHandle,const uint16_t pwmData)
	//void PWM_setShadowMode_CmpA(PWM_Handle pwmHandle,const PWM_ShadowMode_e shadowMode);
	//void PWM_setLoadMode_CmpA(PWM_Handle pwmHandle,const PWM_LoadMode_e loadMode);
	PWM_setCmpA(myPwm1,30000);
	PWM_setShadowMode_CmpA(myPwm1,PWM_ShadowMode_Shadow);
	PWM_setLoadMode_CmpA(myPwm1,PWM_LoadMode_Period);
	//6. set CMPB
	//void PWM_setCmpB(PWM_Handle pwmHandle,const uint16_t pwmData)
	//void PWM_setShadowMode_CmpB(PWM_Handle pwmHandle,const PWM_ShadowMode_e shadowMode);
	//void PWM_setLoadMode_CmpB(PWM_Handle pwmHandle,const PWM_LoadMode_e loadMode);
    //7. set Action
	//void PWM_setActionQual_CntUp_CmpA_PwmA(PWM_Handle pwmHandle,const PWM_ActionQual_e actionQual);
	//void PWM_setActionQual_Period_PwmA(PWM_Handle pwmHandle,const PWM_ActionQual_e actionQual);
	PWM_setActionQual_CntUp_CmpA_PwmA(myPwm1,PWM_ActionQual_Clear);
	PWM_setActionQual_Period_PwmA(myPwm1,PWM_ActionQual_Set);
	//8. TBClkSYNC = 1
	//void CLK_enableTbClockSync(CLK_Handle clkHandle)
	CLK_enableTbClockSync(myClk);

}
//
// (2.3) module Event configure
//! \brief     LED_PWM Event configure
//! \param[in] None
//! \param[out] None
void LED_PWM_eventConfigure(void)
{
	//1. PWMINT
	//void PWM_setIntMode(PWM_Handle pwmHandle,const PWM_IntMode_e intMode);
    //void PWM_setIntPeriod(PWM_Handle pwmHandle,const PWM_IntPeriod_e intPeriod);
	PWM_setIntMode(myPwm1, PWM_IntMode_CounterEqualZero);
    PWM_setIntPeriod(myPwm1, PWM_IntPeriod_FirstEvent);

    //2.ADC EPWMxSOCA/EPWMxSOCA
	//void PWM_setSocAPulseSrc(PWM_Handle pwmHandle,const PWM_SocPulseSrc_e pulseSrc);
	//void PWM_setSocAPeriod(PWM_Handle pwmHandle,const PWM_SocPeriod_e intPeriod);
	//void PWM_enableSocAPulse(PWM_Handle pwmHandle);
	PWM_setSocAPulseSrc(myPwm1, PWM_SocPulseSrc_CounterEqualPeriod);
	PWM_setSocAPeriod(myPwm1, PWM_SocPeriod_FirstEvent);
	PWM_enableSocAPulse(myPwm1);
}
                      
// **************************************************************************
// the API functions




// end of file
