//#############################################################################
//
//! \file  User_Component/User_Pie/User_Pie.h
//!
//! \brief   Interruption System
//!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/User_Pie/User_Pie.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions
// (1) module Initial
//! \brief     USER_PIE module initial
//! \param[in] None
//! \param[out] None
void USER_PIE_initial(void)
{

}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     USER_PIE Pin configure
//! \param[in] None
//! \param[out] None
void USER_PIE_pinConfigure(void)
{

}
//
// (2.2) module function configure
//! \brief     USER_PIE function configure
//! \param[in] None
//! \param[out] None
void USER_PIE_functionConfigure(void)
{   //1. Register PIE Vector
	//void PIE_registerPieIntHandler(PIE_Handle pieHandle,
	//                           const PIE_GroupNumber_e groupNumber,
	//                           const PIE_SubGroupNumber_e subGroupNumber,
	//                           const intVec_t vector)
	//PIE_registerPieIntHandler(myPie, PIE_GroupNumber_1, PIE_SubGroupNumber_4, KEY_XINT1_isr);
	PIE_registerPieIntHandler(myPie, PIE_GroupNumber_1, PIE_SubGroupNumber_5, KEY_XINT2_isr);
	PIE_registerPieIntHandler(myPie, PIE_GroupNumber_1, PIE_SubGroupNumber_7, cpu_timer0_isr);
	PIE_registerPieIntHandler(myPie, PIE_GroupNumber_4, PIE_SubGroupNumber_1, cap1_isr);
	PIE_registerPieIntHandler(myPie, PIE_GroupNumber_3, PIE_SubGroupNumber_1, pwm1_isr);
	PIE_registerPieIntHandler(myPie, PIE_GroupNumber_1, PIE_SubGroupNumber_1, adc1_isr);

	//2. Register System Vector
	//void PIE_registerSystemIntHandler(PIE_Handle pieHandle,
	//                           const PIE_SystemInterrupts_e systemInt,
	//                           const intVec_t vector)


}
//
// (2.3) module Event configure
//! \brief     USER_PIE Event configure
//! \param[in] None
//! \param[out] None
void USER_PIE_eventConfigure(void)
{   //1. Module IE
	//1.1 XINT2
	//void PIE_enableExtInt(PIE_Handle pieHandle, const CPU_ExtIntNumber_e intNumber)
	PIE_enableExtInt(myPie, CPU_ExtIntNumber_2);
    //1.2 TINT0
	//void TIMER_enableInt(TIMER_Handle timerHandle)
	TIMER_enableInt(myTimer0);
	//1.3 ECAPINT
	//void CAP_enableInt(CAP_Handle capHandle, const CAP_Int_Type_e intType);
	CAP_enableInt(myCap1, CAP_Int_Type_CEVT2);
	//1.4 EPWM1INT
	//void PWM_enableInt(PWM_Handle pwmHandle);
	PWM_enableInt(myPwm1);
	//1.5 ADCINT1
	//void ADC_enableInt(ADC_Handle adcHandle, const ADC_IntNumber_e intNumber);
	ADC_enableInt(myAdc, ADC_IntNumber_1);

	//2. PIE PIEIERx.y
	//2.1 INT1.4
	//void PIE_enableInt(PIE_Handle pieHandle, const PIE_GroupNumber_e group, const PIE_InterruptSource_e intSource)
	PIE_enableInt(myPie, PIE_GroupNumber_1, PIE_InterruptSource_XINT_2);
	//2.2 INT1.7
	PIE_enableInt(myPie, PIE_GroupNumber_1, PIE_InterruptSource_TIMER_0);
	//2.3 INT4.1
	PIE_enableInt(myPie, PIE_GroupNumber_4, PIE_InterruptSource_ECAP1);
	//2.4 INT3.1
	PIE_enableInt(myPie, PIE_GroupNumber_3, PIE_InterruptSource_EPWM1);
	//2.5 INT1.1
	PIE_enableInt(myPie, PIE_GroupNumber_1, PIE_InterruptSource_ADCINT_1_1);

	//3. CPU IERx
	//3.1 INT1
	//void CPU_enableInt(CPU_Handle cpuHandle, const CPU_IntNumber_e intNumber)
	CPU_enableInt(myCpu, CPU_IntNumber_1);
	//3.2 INT4
	CPU_enableInt(myCpu, CPU_IntNumber_4);
	//3.3 INT3
	CPU_enableInt(myCpu, CPU_IntNumber_3);

}
                      
// **************************************************************************
// the API functions

//! \brief     Eanble all interruption
//! \param[in] None
//! \param[out] None
void USER_PIE_start(void)
{
	//void CPU_enableGlobalInts(CPU_Handle cpuHandle)
	CPU_enableGlobalInts(myCpu);
}


// end of file
