//#############################################################################
//
//! \file   User_Component/myAdc/myAdc.c
//!
//! \brief   ADC
///!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/myAdc/myAdc.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions
// (1) module Initial
//! \brief     MYADC module initial
//! \param[in] None
//! \param[out] None
void MYADC_initial(void)
{
	Temp = 0;
	TempC = 0;
}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     MYADC Pin configure
//! \param[in] None
//! \param[out] None
void MYADC_pinConfigure(void)
{

}
//
// (2.2) module function configure
//! \brief     MYADC function configure
//! \param[in] None
//! \param[out] None
void MYADC_functionConfigure(void)
{
	//1. setup power
	//void ADC_powerUp(ADC_Handle adcHandle);
	//void ADC_enableBandGap(ADC_Handle adcHandle);
	//void ADC_enableRefBuffers(ADC_Handle adcHandle);
	ADC_powerUp(myAdc);
	ADC_enableBandGap(myAdc);
	ADC_enableRefBuffers(myAdc);
	//2. enable ADC
	//void ADC_enable(ADC_Handle adcHandle);
	ADC_enable(myAdc);
	//3. Volt ref
	ADC_setVoltRefSrc(myAdc, ADC_VoltageRefSrc_Int);
    //4. SOC
	//void ADC_setSocChanNumber(ADC_Handle adcHandle, const ADC_SocNumber_e socNumber, const ADC_SocChanNumber_e chanNumber);
	//void ADC_setSocSampleWindow(ADC_Handle adcHandle, const ADC_SocNumber_e socNumber, const ADC_SocSampleWindow_e sampleWindow);
	//void ADC_setSocTrigSrc(ADC_Handle adcHandle, const ADC_SocNumber_e socNumber, const ADC_SocTrigSrc_e trigSrc);
	ADC_setSocChanNumber(myAdc, ADC_SocNumber_0, ADC_SocChanNumber_A5);
	ADC_setSocSampleWindow(myAdc, ADC_SocNumber_0, ADC_SocSampleWindow_7_cycles);
	ADC_setSocTrigSrc(myAdc, ADC_SocNumber_0, ADC_SocTrigSrc_EPWM1_ADCSOCA);
    //6. temp sensor
	//void ADC_enableTempSensor(ADC_Handle adcHandle);
	ADC_enableTempSensor(myAdc);

}
//
// (2.3) module Event configure
//! \brief     MYADC Event configure
//! \param[in] None
//! \param[out] None
void MYADC_eventConfigure(void)
{
	//void ADC_setIntMode(ADC_Handle adcHandle, const ADC_IntNumber_e intNumber, const ADC_IntMode_e intMode);
	//void ADC_setIntPulseGenMode(ADC_Handle adcHandle, const ADC_IntPulseGenMode_e pulseMode);
	//void ADC_setIntSrc(ADC_Handle adcHandle, const ADC_IntNumber_e intNumber, const ADC_IntSrc_e intSrc);
	ADC_setIntMode(myAdc, ADC_IntNumber_1, ADC_IntMode_ClearFlag);
	ADC_setIntPulseGenMode(myAdc, ADC_IntPulseGenMode_Prior);
	ADC_setIntSrc(myAdc, ADC_IntNumber_1, ADC_IntSrc_EOC0);

}
                      
// **************************************************************************
// the API functions



// end of file
