//#############################################################################
//
//! \file   User_Component/myCap/myCap.c
//!
//! \brief   Capture
//!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/myCap/myCap.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions
// (1) module Initial
//! \brief     MYCAP module initial
//! \param[in] None
//! \param[out] None
void MYCAP_initial(void)
{
	myCapVal1 = 0;
	myCapVal2 = 0;
	myPeroid1 = 0;
	myPeroid2 = 0;
	myHigh = 0;

}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     MYCAP Pin configure
//! \param[in] None
//! \param[out] None
void MYCAP_pinConfigure(void)
{  //1. set pullup
	//void GPIO_setPullUp(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_PullUp_e pullUp);
	GPIO_setPullUp(myGpio, GPIO_Number_5, GPIO_PullUp_Disable);

	//2. set mode
	//void GPIO_setMode(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Mode_e mode);
	GPIO_setMode(myGpio, GPIO_Number_5, GPIO_5_Mode_ECAP1);

	//3. set direction
	//void GPIO_setDirection(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Direction_e direction);
	GPIO_setDirection(myGpio, GPIO_Number_5, GPIO_Direction_Input);

	//4. filter
	//void GPIO_setQualification(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const GPIO_Qual_e qualification);
	//void GPIO_setQualificationPeriod(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const uint16_t period);
	GPIO_setQualification(myGpio, GPIO_Number_5, GPIO_Qual_ASync);



}
//
// (2.2) module function configure
//! \brief     MYCAP function configure
//! \param[in] None
//! \param[out] None
void MYCAP_functionConfigure(void)
{
	//1. TSCTR
	//void CAP_enableTimestampCounter(CAP_Handle capHandle);
	CAP_enableTimestampCounter(myCap1);
	//2. set StopWrap
	//void CAP_setStopWrap(CAP_Handle capHandle, const CAP_Stop_Wrap_e stopWrap);
	CAP_setStopWrap(myCap1, CAP_Stop_Wrap_CEVT2);
	//3. set Polarity
	//void CAP_setCapEvtPolarity(CAP_Handle capHandle, const CAP_Event_e event, const CAP_Polarity_e polarity);
	CAP_setCapEvtPolarity(myCap1, CAP_Event_1, CAP_Polarity_Rising);
	CAP_setCapEvtPolarity(myCap1, CAP_Event_2, CAP_Polarity_Falling);
	//4. TSCTR Reset?
	//void CAP_setCapEvtReset(CAP_Handle capHandle, const CAP_Event_e event, const CAP_Reset_e reset);
	//CAP_setCapEvtReset(myCap1, CAP_Event_1, CAP_Reset_Disable); //ģʽ
	//CAP_setCapEvtReset(myCap1, CAP_Event_2, CAP_Reset_Disable);

	CAP_setCapEvtReset(myCap1, CAP_Event_1, CAP_Reset_Enable);//ģʽ
	CAP_setCapEvtReset(myCap1, CAP_Event_2, CAP_Reset_Disable);
	//5 set Capture Mode
	//void CAP_setCapContinuous(CAP_Handle capHandle);
	CAP_setCapContinuous(myCap1);
	//6. Load Capture
	//void CAP_enableCaptureLoad(CAP_Handle capHandle);
	CAP_enableCaptureLoad(myCap1);

}
//
// (2.3) module Event configure
//! \brief     MYCAP Event configure
//! \param[in] None
//! \param[out] None
void MYCAP_eventConfigure(void)
{

}
                      
// **************************************************************************
// the API functions



// end of file
