//#############################################################################
//
//! \file   User_Component/mySci/mySci.c
//!
//! \brief   SCI
///!
//  Quthor:
//  Group:          C2000
//  Target Device:  TMS320F2802x
//
//  (C) Copyright 2015, Fuzhou University.
//#############################################################################
// $TI Release: f2802x Support Library v210 $
// $Release Date: Mon Sep 17 09:13:31 CDT 2012 $
//#############################################################################

// **************************************************************************
// the includes
#include "User_Component/mySci/mySci.h"


// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions
// (1) module Initial
//! \brief     MYSCI module initial
//! \param[in] None
//! \param[out] None
void MYSCI_initial(void)
{
	SciSendPoint = 0;
	SciReceivePoint = 0;
}
//
// (2) module Configure
// (2.1) module Pin configure
//! \brief     MYSCI Pin configure
//! \param[in] None
//! \param[out] None
void MYSCI_pinConfigure(void)
{   //1. set pullup
	//void GPIO_setPullUp(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_PullUp_e pullUp);
	GPIO_setPullUp(myGpio, GPIO_Number_28, GPIO_PullUp_Disable);
    GPIO_setPullUp(myGpio, GPIO_Number_29, GPIO_PullUp_Disable);

	//2. set mode
	//void GPIO_setMode(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Mode_e mode);
    GPIO_setMode(myGpio, GPIO_Number_28, GPIO_28_Mode_SCIRXDA);
    GPIO_setMode(myGpio, GPIO_Number_29, GPIO_29_Mode_SCITXDA);

	//3. set direction
	//void GPIO_setDirection(GPIO_Handle gpioHandle,const GPIO_Number_e gpioNumber,const GPIO_Direction_e direction);
	GPIO_setDirection(myGpio, GPIO_Number_28, GPIO_Direction_Input);
	GPIO_setDirection(myGpio, GPIO_Number_29, GPIO_Direction_Output);

	//4. filter
	//void GPIO_setQualification(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const GPIO_Qual_e qualification);
	//void GPIO_setQualificationPeriod(GPIO_Handle gpioHandle, const GPIO_Number_e gpioNumber, const uint16_t period);
	GPIO_setQualification(myGpio, GPIO_Number_28, GPIO_Qual_ASync);


}
//
// (2.2) module function configure
//! \brief     MYSCI function configure
//! \param[in] None
//! \param[out] None
void MYSCI_functionConfigure(void)
{
    //1. SCI BRR = LSPCLK/(SCI BAUDx8) - 1
	//void SCI_setBaudRate(SCI_Handle sciHandle, const SCI_BaudRate_e baudRate)
    SCI_setBaudRate(mySci, SCI_BaudRate_9_6_kBaud);
    //2. configure package(1 stop bit,  No loopback, No parity,8 char bits, async mode, idle-line protocol)
    //void SCI_disableParity(SCI_Handle sciHandle)
    //void SCI_setNumStopBits(SCI_Handle sciHandle, const SCI_NumStopBits_e numBits)
    //void SCI_setCharLength(SCI_Handle sciHandle, const SCI_CharLength_e charLength)
    SCI_disableParity(mySci);
    SCI_setNumStopBits(mySci, SCI_NumStopBits_One);
    SCI_setCharLength(mySci, SCI_CharLength_8_Bits);
    //3. enable SCI TX&RX
    //void SCI_enableTx(SCI_Handle sciHandle)
    //void SCI_enableRx(SCI_Handle sciHandle)
    SCI_enableTx(mySci);
    SCI_enableRx(mySci);
    //4. enable SCI module
    //void SCI_enable(SCI_Handle sciHandle)
    SCI_enable(mySci);
}
//
// (2.3) module Event configure
//! \brief     MYSCI Event configure
//! \param[in] None
//! \param[out] None
void MYSCI_eventConfigure(void)
{

}
                      
// **************************************************************************
// the API functions

//! \brief     Transmit a char from the SCI
//! \param[in] string
//! \param[out] None
void mySCI_sendCharBlocking(uint16_t ch)
{
	SCI_putDataBlocking(mySci, ch);
}

void mySCI_sendMessageBlocking(uint16_t * msg)
{
    uint16_t i = 0;

    while('\0' != msg[i])
    {
    	mySCI_sendCharBlocking(msg[i]);
        i++;
    }
}

//! \brief     Receive a char from the SCI
//! \param[in] None
//! \param[out] receive data
uint16_t mySCI_receiveCharBlocking(void)
{
	return SCI_getDataBlocking(mySci);
}

//! \brief     Receive a char from the SCI
//! \param[in] None
//! \param[out] SciReceiveBuf: receive data; <50 data
uint16_t* mySCI_receiveMessageBlocking(void)
{
	SciReceivePoint = 0;
	while( SciReceivePoint <50 )
	{
		SciReceiveBuf[SciReceivePoint]=mySCI_receiveCharBlocking();
		if('\0' == SciReceiveBuf[SciReceivePoint]) break;
		SciReceivePoint += 1;
	}
	return SciReceiveBuf;
}


// end of file
