#include "DSP2833x_Device.h"
#include "DSP2833x_Examples.h"
#include "DSP2833x_GlobalPrototypes.h"
#include "rtwtypes.h"
#include "Copy_of_c28335pmsmfocorigin.h"
#include "Copy_of_c28335pmsmfocorigin_private.h"

void config_QEP_eQEP1(uint32_T pcmaximumvalue, uint32_T pcInitialvalue, uint32_T
                      unittimerperiod, uint32_T comparevalue, uint16_T
                      watchdogtimer, uint16_T qdecctl, uint16_T qepctl, uint16_T
                      qposctl, uint16_T qcapctl, uint16_T qeint)
{
  EALLOW;                              /* Enable EALLOW*/

  /* Enable internal pull-up for the selected pins */
  GpioCtrlRegs.GPBPUD.bit.GPIO50 = 0;  /* Enable pull-up on GPIO50 (EQEP1A)*/
  GpioCtrlRegs.GPBPUD.bit.GPIO51 = 0;  /* Enable pull-up on GPIO51 (EQEP1B)*/
  GpioCtrlRegs.GPBPUD.bit.GPIO52 = 0;  /* Enable pull-up on GPIO52 (EQEP1S)*/
  GpioCtrlRegs.GPBPUD.bit.GPIO53 = 0;  /* Enable pull-up on GPIO53 (EQEP1I)*/

  /* Configure eQEP-1 pins using GPIO regs*/
  GpioCtrlRegs.GPBMUX2.bit.GPIO50 = 1; /* Configure GPIO50 as EQEP1A*/
  GpioCtrlRegs.GPBMUX2.bit.GPIO51 = 1; /* Configure GPIO51 as EQEP1B  */
  GpioCtrlRegs.GPBMUX2.bit.GPIO52 = 1; /* Configure GPIO52 as EQEP1S*/
  GpioCtrlRegs.GPBMUX2.bit.GPIO53 = 1; /* Configure GPIO53 as EQEP1I*/
  EDIS;
  EQep1Regs.QPOSINIT= pcInitialvalue;  /*eQEP Initialization Position Count*/
  EQep1Regs.QPOSMAX= pcmaximumvalue;   /*eQEP Maximum Position Count*/
  EQep1Regs.QUPRD= unittimerperiod;    /*eQEP Unit Period Register*/
  EQep1Regs.QWDPRD= watchdogtimer;     /*eQEP watchdog timer Register*/
  EQep1Regs.QDECCTL.all = qdecctl;     /*eQEP Decoder Control (QDECCTL) Register*/
  EQep1Regs.QEPCTL.all = qepctl;       /*eQEP Control (QEPCTL) Register*/
  EQep1Regs.QPOSCTL.all = qposctl;     /*eQEP Position-compare Control (QPOSCTL) Register*/
  EQep1Regs.QCAPCTL.all = qcapctl;     /*eQEP Capture Control (QCAPCTL) Register*/
  EQep1Regs.QEPCTL.bit.FREE_SOFT= 2;   /*unaffected by emulation suspend*/
  EQep1Regs.QPOSCMP = comparevalue;    /*eQEP Position-compare*/
  EQep1Regs.QEINT.all = qeint;         /*eQEPx interrupt enable register*/
}
