/****************************************************************************/
/* SINEWAVE.CMD - COMMAND FILE FOR LINKING TMS27xx/TMS28xx C PROGRAMS       */
/*                                                                          */
/*   Description: This file is a sample command file that can be used       */
/*                for linking programs built with the TMS320C28xx C         */
/*                Compiler.   Use it as a guideline; you may want to change */
/*                the allocation scheme according to the size of your       */
/*                program and the memory layout of your target system.      */
/****************************************************************************/


MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode      */
   /* BOOT_RSVD is used by the boot ROM for stack.               */
   /* This section is only reserved to keep the BOOT ROM from    */
   /* corrupting this area during the debug process              */
   
   BEGIN      : origin = 0x000000, length = 0x000002     /* Boot to M0 will go here                      */
   BOOT_RSVD  : origin = 0x000002, length = 0x00004E     /* Part of M0, BOOT rom will use this for stack */               
   RAMM0      : origin = 0x000050, length = 0x0003B0

   RAML0      : origin = 0x008000, length = 0x001000    
   RAML1      : origin = 0x009000, length = 0x001000    
   ZONE7A     : origin = 0x200000, length = 0x00FC00    /* XINTF zone 7 - program space */ 
   CSM_RSVD   : origin = 0x33FF80, length = 0x000076     /* Part of FLASHA.  Program with all 0x0000 when CSM is in use. */
   CSM_PWL    : origin = 0x33FFF8, length = 0x000008     /* Part of FLASHA.  CSM password locations in FLASHA            */
   ADC_CAL    : origin = 0x380080, length = 0x000009
   RESET      : origin = 0x3FFFC0, length = 0x000002
   IQTABLES   : origin = 0x3FE000, length = 0x000b50
   IQTABLES2  : origin = 0x3FEB50, length = 0x00008c
   FPUTABLES  : origin = 0x3FEBDC, length = 0x0006A0
   BOOTROM    : origin = 0x3FF27C, length = 0x000D44               

         
PAGE 1 : 
   RAMM1      : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */
   RAML2      : origin = 0x00A000, length = 0x000400    
   RAML3      : origin = 0x00A400, length = 0x001000 
   RAML4      : origin = 0x00B400, length = 0x001800    
   RAML5      : origin = 0x00CC00, length = 0x001000    
   RAML61      : origin = 0x00DC00, length = 0x001000   
   RAML62      : origin = 0x00EC00, length = 0x001000
   RAML7      : origin = 0x00FC00, length = 0x000400 
   ZONE7B     : origin = 0x20FC00, length = 0x000400     /* XINTF zone 7 - data space */
}
 
SECTIONS
{
   /* Setup for "boot to SARAM" mode: 
      The codestart section (found in DSP28_CodeStartBranch.asm)
      re-directs execution to the start of user code.  */
   codestart        : > BEGIN,     PAGE = 0
   ramfuncs         : > RAML0,     PAGE = 0  
   .text            : > RAML1,     PAGE = 0
   .cinit           : > RAML0,     PAGE = 0
   .pinit           : > RAML0,     PAGE = 0
   .switch          : > RAML0,     PAGE = 0
   
   .stack           : > RAMM1,     PAGE = 1
   .ebss            : > RAML2,     PAGE = 1
   .econst          : > RAML3,     PAGE = 1      
   .esysmem         : > RAMM1,     PAGE = 1

   DLOG	 			: >	RAML5,	   PAGE = 1
   SGENipcb			: > RAML61,    PAGE = 1  
   SGENipcbsrc   	: >	RAML62,	   PAGE = 1
   
   ipcb1			: > RAML61,	   PAGE = 1  
   ipcb2   			: >	RAML62,	   PAGE = 1
   ipcb3	 		: >	RAML5,	   PAGE = 1
   ipcb4	 		: >	RAML5,	   PAGE = 1
   ipcb5	 		: >	RAML4,	   PAGE = 1
   ipcb6	 		: >	RAML4,	   PAGE = 1
   
   SINTBL			: > RAML7,     PAGE = 1
   
   IQmath           : > RAML1,     PAGE = 0
   IQmathTables     : > IQTABLES,  PAGE = 0, TYPE = NOLOAD 
   
   /* Uncomment the section below if calling the IQNexp() or IQexp()
      functions from the IQMath.lib library in order to utilize the 
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM 
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
   /*
   IQmathTables2    : > IQTABLES2, PAGE = 0, TYPE = NOLOAD 
   {
   
              IQmath.lib<IQNexpTable.obj> (IQmathTablesRam)
   
   }
   */   

   FPUmathTables    : > FPUTABLES, PAGE = 0, TYPE = NOLOAD 
      
   DMARAML4         : > RAML4,     PAGE = 1   
   DMARAML5         : > RAML5,     PAGE = 1 
   DMARAML6         : > RAML61,     PAGE = 1
   DMARAML7         : > RAML7,     PAGE = 1
   
   ZONE7DATA        : > ZONE7B,    PAGE = 1  

   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used                    */
   csm_rsvd         : > CSM_RSVD   PAGE = 0, TYPE = DSECT /* not used for SARAM examples */
   csmpasswds       : > CSM_PWL    PAGE = 0, TYPE = DSECT /* not used for SARAM examples */
   
   /* Allocate ADC_cal function (pre-programmed by factory into TI reserved memory) */
   .adc_cal     : load = ADC_CAL,   PAGE = 0, TYPE = NOLOAD
}

