/**********************************************************************
* File: F2802x_FLASH_Renewable.cmd
* Devices: TMS320F28027
* Author: 
* History:
*  
**********************************************************************/

MEMORY
{
PAGE 0:    /* Program Memory */
   BEGIN_M0        : origin = 0x000000, length = 0x000002     /* Part of M0SARAM.  Used for "Boot to M0" bootloader mode. */
   L0SARAM         : origin = 0x008000, length = 0x001000     /* L0 SARAM, CSM secure */
   OTP             : origin = 0x3D7800, length = 0x000400     /* 1Kw OTP */
   DEVICE_CAL      : origin = 0x3D7C80, length = 0x000040     /* Device_cal function in Reserved memory */
   FLASH_ABCD      : origin = 0x3F0000, length = 0x007F80     /* On-chip FLASH */
   CSM_RSVD        : origin = 0x3F7F80, length = 0x000076     /* Part of FLASH Sector A.  Reserved when CSM is in use. */
   BEGIN_FLASH     : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASH Sector A.  Used for "Jump to flash" bootloader mode. */
   PASSWORDS       : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASH Sector A.  CSM password locations. */
   IQTABLES        : origin = 0x3FE000, length = 0x000B50     /* Part of Boot ROM */
   IQTABLES2       : origin = 0x3FEB50, length = 0x00008C     /* Part of Boot ROM */
   IQTABLES3       : origin = 0x3FEBDC, length = 0x0000AA     /* Part of Boot ROM */
   
   BOOTROM    : origin = 0x3FF27C, length = 0x000D44     /* 8Kw Boot ROM */         
   RESET           : origin = 0x3FFFC0, length = 0x000002     /* part of Boot ROM */

 PAGE 1 :   /* Data Memory */
   M0SARAM         : origin = 0x000002, length = 0x0003FE     /* 1Kw M0 SARAM */
   M1SARAM         : origin = 0x000400, length = 0x000400     /* 1Kw M1 SARAM */
   DATALOG		   : origin = 0x008800, length = 0x000800     /* Logging the Data,Part of L0SARAM*/
}

 
SECTIONS
{
/*** Compiler Required Sections ***/

  /* Program memory (PAGE 0) sections */
   .text             : > FLASH_ABCD,            PAGE = 0
   .cinit            : > FLASH_ABCD,            PAGE = 0
   .const            : > FLASH_ABCD,            PAGE = 0
   .econst           : > FLASH_ABCD,            PAGE = 0      
   .pinit            : > FLASH_ABCD,            PAGE = 0
   .reset            : > RESET,                 PAGE = 0, TYPE = DSECT  /* Not using the .reset section */
   .switch           : > FLASH_ABCD,            PAGE = 0

   SINTBL		 	 : > FLASH_ABCD ,  		    PAGE = 0 
   IQmath            : > FLASH_ABCD ,  		    PAGE = 0
   IQmathTables      : >IQTABLES ,              PAGE = 0, TYPE = NOLOAD

  /* Data Memory (PAGE 1) sections */
   .bss              : > M0SARAM,               PAGE = 1
   .ebss             : > M0SARAM,               PAGE = 1
   .cio              : > M0SARAM,               PAGE = 1
   .stack            : > M1SARAM,               PAGE = 1
   .sysmem           : > M1SARAM,               PAGE = 1
   .esysmem          : > M1SARAM,               PAGE = 1

    DLOG             : > DATALOG,				PAGE = 1

/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,           PAGE = 0                /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,              PAGE = 0                /* Used by file passwords.asm */
   passwords         : > PASSWORDS,             PAGE = 0                /* Used by file passwords.asm */

  
   ramfuncs     :   LOAD = FLASH_ABCD,     PAGE = 0                /* Should be Flash */ 
                    RUN = L0SARAM,         PAGE = 0                /* Must be CSM secured RAM */
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart)
}

/******************* end of file ************************/
