/* =================================================================================
File name:       PID_REG3.H  (IQ version)                    
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description: 
Header file containing constants, data type definitions, and 
function prototypes for the PIDREG3.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 04-15-2005	Version 3.20
------------------------------------------------------------------------------*/
#ifndef __CNTL2P2Z_H__
#define __CNTL2P2Z_H__

typedef struct {  _iq  Ref;   			// Input: Reference input 
				  _iq  Fdb;   			// Input: Feedback input 
				  _iq  Errn;				// Variable: Error
				  _iq26  Errn1;				// Parameter: Proportional gain
				  _iq26  Errn2;				// Variable: Proportional output 
				  _iq  Out;				// Variable: Integral output 
				  _iq26  Out1;				// Variable: Derivative output 	
				  _iq26  Out2;				// Variable: Derivative output 	
				  _iq26  OutPreSat; 		// Variable: Pre-saturated output
				  _iq  OutMax;		    // Parameter: Maximum output 
				  _iq  OutMin;	    	// Parameter: Minimum output
				  _iq26  Coeff_B0;   			// Output: PID output 
				  _iq26  Coeff_B1;			// Variable: Saturated difference
				  _iq26  Coeff_B2;			    // Parameter: Integral gain
				  _iq26  Coeff_A1;		     	// Parameter: Integral correction gain
				  _iq26  Coeff_A2; 		        // Parameter: Derivative gain
				  _iq26  temp1;
				  _iq26  temp2;
				  _iq26  temp3;
				  void  (*calc)();	  	// Pointer to calculation function
				 } CNTL2P2Z;	            


typedef CNTL2P2Z *CNTL2P2Z_handle;
/*-----------------------------------------------------------------------------
Default initalizer for the PIDREG3 object.
-----------------------------------------------------------------------------*/                     
#define CNTL2P2Z_DEFAULTS { 0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           (void (*)(Uint32)) cntl_2p2z_calc }

/*------------------------------------------------------------------------------
Prototypes for the functions in PIDREG3.C
------------------------------------------------------------------------------*/
void cntl_2p2z_calc(CNTL2P2Z_handle);

#endif // __PIDREG3_H__
