/* 
==============================================================================

System Name:    Signal Generator Module demo 

File Name:      SGENTI1.C

Description:    Primary System file for demonstrating the Signal Generator module

Originator:     Digital control systems Group - Texas Instruments

Target dependency:  C28x

Description:
============

   The "C" frame work, for demonstrating the signal generator module is given below
                 ___________           _____________
                |           |         |             |
                |           | X1=OUT  |   EVMDAC    |
                |  SGENTI_1 |-------->|   DLOG_4CH  |
                |           |         |   PWMDAC    |
                |___________|         |_____________|

*/

#include "PeripheralHeaderIncludes.h"
//#include "DSP280x_Device.h"     // DSP280x Headerfile Include File --Changed for piccolo

#include "sgen.h"
#include "dlog4ch_Renewable.h"
#include "stdlib.h"
#include "stdio.h"
#include "IQmathLib.h"

#pragma CODE_SECTION(sinewave, "ramfuncs");

int DlogCh1 = 0;
int DlogCh2 = 0;
int DlogCh3 = 0;
int DlogCh4 = 0;
int halfperiodd;
extern int EPWM1_TIMER_TBPRD;
extern int LineVoltage;

long GlobalQ = GLOBAL_Q;

#define slope _IQ(-11.2375719519)
#define inter _IQ(9974.91836735)

/* Create an instance of DATALOG Module             */
DLOG_4CH dlog = DLOG_4CH_DEFAULTS;      
    
/* Create an instance of Signal generator module    */
SGENTI_1 sgen1 = SGENTI_1_DEFAULTS;

 _iq periodIQ, x11, test1,test2,test3, frequency1IQ;
         
/* Temp variable to store the signal genr output    */   
int x1, frequency2,temp,cnt; 
long frequency1;
int PhaseFlag=0;		//****
int Flag_max = 0;
int sunc = 4295, pulse, Flag;  //sunc=5142

long PWMperiod = 400;
int period = 333; 
long halfperiod = 0x3FFF;
//short xx1;
int	xx1,tune_inc=1;

extern int16 frequencyset;
extern int16 temp1,ref_duty; 

extern int16 	ref_duty;  
 _iq5 freqconv = 12.359712;

 extern int16	dlog_cnt;

int sinewave(void)
 {    

	DlogCh2 = 0x0;
	cnt++;

	if (PieCtrlRegs.PIEIFR1.bit.INTx4 == 1)
	{ 

	temp1=cnt;
	cnt=0;
	temp=sgen1.out;
	sgen1.alpha = 0;
	DlogCh2 = 0x7FFF;

	dlog_cnt = 3;

	period = Flag;
	Flag = 0;
	PieCtrlRegs.PIEIFR1.bit.INTx4 = 0;

//-----------------------------------------------------------------------------------------------------------------------	
	
	if (sgen1.out>1000 ||sgen1.out<-1000)	// if the phase difference is big incremental freq step is 10 
	{tune_inc=10;}
	else
	{tune_inc=1;}				// else 1

	if (sgen1.out < 300 && sgen1.out >-300)	// if the phase difference is within the range of minimum possible
	{tune_inc=0;}				// stop updating freq

	if (sgen1.out > 300)			// if the phase angle is positive reduce the freq
	{sunc=sunc-tune_inc;}
	if (sgen1.out <-300)			// if the phase angle is negative increase the freq
	{sunc=sunc+tune_inc;}			// "sign" needed if line voltage and ref. are out of phase
	
	
	}

	sgen1.gain=ref_duty;

	frequency1IQ = sunc;

	halfperiodd = EPWM1_TIMER_TBPRD/2; //added 090908
   
 	sgen1.freq = sunc;

    sgen1.calc(&sgen1);

		DlogCh1 = sgen1.out;
		x1 = sgen1.out;

		xx1 = x1; //EPWM1_TIMER_TBPRD

		x1 = _IQint(_IQmpy(_IQ15toIQ(xx1),_IQ(halfperiodd)));
	    x1 = EPWM1_TIMER_TBPRD/2 + x1;
    	
       
    //    dlog.update(&dlog);
	
		return (x1);
  }       

void sine_init(void)
 { 
       sgen1.offset=0x0;
       sgen1.gain=0x7fff;        /* gain=1 in Q15                              */
//       sgen1.freq=5369;        /* freq = (Required Freq/Max Freq)*2^15       */
       sgen1.freq=4295;                         /*      = (50/305.17)*2^15 = 5369             */  
								/* freq50 = (50/381.47)*2^15 = 4295 */
								/* freq60 = (60/381.47)*2^15 = 5154 */
								/* freq70 = (70/381.47)*2^15 = 6013 */

       sgen1.freq = frequency1;       
       sgen1.step_max= 1000;    /* Max Freq= (step_max * sampling freq)/65536 */
                                /* Max Freq = (1000*20k)/65536 = 305.17       */
								/* Max Freq = (1000*25k)/65536 = 381.47 */
	 	sgen1.alpha = 0;
 }


void dlog_init(void)
 {
/* DATALOG module initialization */        
       dlog.iptr1= &DlogCh1;
	   dlog.iptr2= &DlogCh2;
	   dlog.iptr3= &DlogCh3;
	   dlog.iptr4= &DlogCh4;

       dlog.trig_value=0x0;
       dlog.size=0x200;         /* Can log 512 Samples   */
       dlog.init(&dlog);
  	   dlog.update(&dlog);
 }

              
